/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.java.collectionmaps.MapMap;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.shared.IPermissionsChangeListener;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class EOUserAndGroupAndPermissions
extends EOEncodableObject {
    public static final String XML_NAME = "UserWithPermissions";
    private static final String GROUP_LIST = "groups";
    private static final String PERMISSION_LIST = "permissions";
    private final Collection<IPermissionsChangeListener> permissionsChangeListeners = new ArrayList<IPermissionsChangeListener>();
    private MapMap<String, String, ArrayList<EOPermission>> permissions_of_subset_for_operand = new MapMap();
    private EOList<EOPermission> allPermissions = new EOList("permissions");
    private EOList<EOGroup> groups = new EOList("groups");
    private EOUser user;

    public EOUserAndGroupAndPermissions() {
        super(XML_NAME);
    }

    public EOUserAndGroupAndPermissions(EOUser user, Collection<? extends EOGroup> groups, Collection<? extends EOPermission> permissions, Collection<? extends EOPermission> allRolesPermissions) {
        super(XML_NAME);
        this.setUser(user);
        this.setGroups(groups);
        this.setPermissions(permissions);
        this.addPermissions(allRolesPermissions);
    }

    public EOUserAndGroupAndPermissions(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        return false;
    }

    @Override
    protected boolean hasChildren() {
        return this.user != null || this.allPermissions != null;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.user != null) {
            this.user.writeXMLBody(writeContext, depth);
        }
        if (this.allPermissions != null) {
            this.allPermissions.writeXMLBody(writeContext, depth);
        }
        if (this.groups != null) {
            this.groups.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild.getTag().equals("User")) {
            this.user = (EOUser)newChild;
            return true;
        }
        if (newChild.getTag().equals("List")) {
            EOList list = (EOList)newChild;
            if (GROUP_LIST.equals(list.getRole())) {
                this.groups = list;
                return true;
            }
            if (PERMISSION_LIST.equals(list.getRole())) {
                this.setPermissions(list);
                return true;
            }
        }
        return false;
    }

    public void addPermissionsChangeListener(IPermissionsChangeListener listener) {
        if (!this.permissionsChangeListeners.contains(listener)) {
            this.permissionsChangeListeners.add(listener);
        }
    }

    public void removePermissionsChangeListener(IPermissionsChangeListener listener) {
        this.permissionsChangeListeners.remove(listener);
    }

    public ArrayList<EOPermission> getAllPermissionsOfSubsetForOperand(String subSetUID, String operandUID) {
        return this.permissions_of_subset_for_operand.get(subSetUID, operandUID);
    }

    public Collection<EOPermission> getAllPermissions() {
        return this.allPermissions;
    }

    public EOList<EOGroup> getGroups() {
        return this.groups;
    }

    public EOUser getUser() {
        return this.user;
    }

    public void setPermissions(Collection<? extends EOPermission> permissions) {
        this.allPermissions = new EOList(PERMISSION_LIST);
        this.permissions_of_subset_for_operand = new MapMap();
        this.addPermissions(permissions);
    }

    public void setGroups(Collection<? extends EOGroup> groups) {
        this.groups.clear();
        this.groups.addAll(groups);
    }

    public void addPermission(EOPermission permission) {
        this.allPermissions.add(permission);
        ArrayList<EOPermission> permissions = this.permissions_of_subset_for_operand.get(permission.getSubSetUID(), permission.getOperandUID());
        if (permissions == null) {
            permissions = new ArrayList();
            this.permissions_of_subset_for_operand.put(permission.getSubSetUID(), permission.getOperandUID(), permissions);
        }
        permissions.add(permission);
        for (IPermissionsChangeListener listener : this.permissionsChangeListeners) {
            listener.permissionAdded(permission);
        }
    }

    public void addPermissions(Collection<? extends EOPermission> permissionsToAdd) {
        for (EOPermission eOPermission : permissionsToAdd) {
            this.addPermission(eOPermission);
        }
    }

    public void removePermission(EOPermission permission) {
        Iterator<EOPermission> i = this.allPermissions.iterator();
        while (i.hasNext()) {
            EOPermission contained = i.next();
            if (!contained.getPermissionUID().equals(permission.getPermissionUID())) continue;
            i.remove();
            break;
        }
        ArrayList<EOPermission> containedList = this.permissions_of_subset_for_operand.get(permission.getSubSetUID(), permission.getOperandUID());
        if (containedList != null) {
            Iterator<EOPermission> i2 = containedList.iterator();
            while (i2.hasNext()) {
                EOPermission contained = i2.next();
                if (!contained.getPermissionUID().equals(permission.getPermissionUID())) continue;
                i2.remove();
                break;
            }
        }
        for (IPermissionsChangeListener listener : this.permissionsChangeListeners) {
            listener.permissionsRemoved(permission);
        }
    }

    public void removePermissions(Collection<EOPermission> permissionsToRemoved) {
        for (EOPermission permission : permissionsToRemoved) {
            this.removePermission(permission);
        }
    }

    public void addGroup(EOGroup group) {
        this.groups.add(group);
    }

    public void setUser(EOUser user) {
        this.user = user;
    }
}

