/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.DumpFileHasInvalidFileTypeException;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.io.IOException;

public abstract class ServerDumpFileAccess {
    private static final ILogger logger = Logger.getLogger(ServerDumpFileAccess.class);
    private static final int STATE_ERROR = 1;
    private static final int STATE_EVERYTHING_ACCESSIBLE = 3;
    private static final int STATE_DISPOSED = 4;
    protected static final String UNZIP_DIRECTORY_NAME = "cockpit_serverdump_tmp";
    private final File serverDumpFile;
    private File rootDirectoryOfUnzippedServerDumpFile;
    private int state;
    private EOVersionFileContent versionFileContent;

    public ServerDumpFileAccess(File serverDumpFile) {
        assert (serverDumpFile != null);
        this.serverDumpFile = serverDumpFile;
    }

    protected void init() throws DumpFileAccessException {
        String fileType;
        try {
            this.rootDirectoryOfUnzippedServerDumpFile = this.createRootDirectoryOfUnzippedServerDumpFile();
        }
        catch (DumpFileAccessException dfaE) {
            this.state = 1;
            throw dfaE;
        }
        this.unzipServerDump();
        EOVersionFileContent versionFileContent_ = this.getVersionFileContent();
        if (versionFileContent_ != null && (fileType = versionFileContent_.getFileType()) != null && fileType.trim().length() > 0 && !fileType.equals("psc.server-dump")) {
            throw new DumpFileHasInvalidFileTypeException("The given file is not a Cockpit project dump (file type: " + fileType + ").", fileType);
        }
        this.state = 3;
    }

    public int getBaseVersion() throws DumpFileAccessException {
        this.checkState();
        return this.getVersion("com.arcway.psc");
    }

    public int getVersion(String moduleID) throws DumpFileAccessException {
        this.checkState();
        EOVersionFileContent versionsMap_ = this.getVersionFileContent();
        if (versionsMap_ != null) {
            Integer versionAsInteger = versionsMap_.getVersion(moduleID);
            if (versionAsInteger != null) {
                return versionAsInteger;
            }
            return -1;
        }
        return -1;
    }

    public EOVersionFileContent getVersionFileContent() throws DumpFileAccessException {
        this.checkState();
        if (this.versionFileContent == null) {
            try {
                this.versionFileContent = this.readVersionFile();
            }
            catch (DumpFileAccessException pfaE) {
                this.versionFileContent = null;
            }
        }
        return this.versionFileContent;
    }

    public void setVersions(EOVersionFileContent newVersions) {
        this.versionFileContent = newVersions;
    }

    public File getModuleDirectory(String moduleID) throws DumpFileAccessException {
        this.checkState();
        File moduleDirectory = new File(this.getRootDirectoryOfUnzippedServerDumpFile(), moduleID);
        if (moduleDirectory.exists() && moduleDirectory.isDirectory()) {
            return moduleDirectory;
        }
        return null;
    }

    public void dispose() {
        this.dispose_internal();
    }

    protected void dispose_internal() {
        if (this.state != 4) {
            try {
                try {
                    FileHelper.deleteExistingFileOrDirectory(this.rootDirectoryOfUnzippedServerDumpFile);
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    logger.warn("Could not delete the unzipped server dump file contents during disposal (" + this.rootDirectoryOfUnzippedServerDumpFile.getAbsolutePath() + ").", jeriE);
                    this.rootDirectoryOfUnzippedServerDumpFile = null;
                    this.state = 4;
                }
            }
            finally {
                this.rootDirectoryOfUnzippedServerDumpFile = null;
                this.state = 4;
            }
        }
    }

    protected abstract File createRootDirectoryOfUnzippedServerDumpFile() throws DumpFileAccessException;

    public File getRootDirectoryOfUnzippedServerDumpFile() {
        return this.rootDirectoryOfUnzippedServerDumpFile;
    }

    private void unzipServerDump() throws DumpFileAccessException {
        try {
            Zip.unzipFile(this.serverDumpFile.getAbsolutePath(), this.rootDirectoryOfUnzippedServerDumpFile.getAbsolutePath());
        }
        catch (IOException ioE) {
            logger.error("Can't unzip server dump file (" + this.serverDumpFile.getName() + ") into temp directory (" + this.rootDirectoryOfUnzippedServerDumpFile.getAbsolutePath() + ").", ioE);
            this.state = 1;
            throw new DumpFileAccessException(ioE);
        }
    }

    private EOVersionFileContent readVersionFile() throws DumpFileAccessException {
        File versionFile = new File(this.rootDirectoryOfUnzippedServerDumpFile, "versions.xml");
        EncodableObjectBase eo = this.readVersionFromFile(versionFile);
        if (eo instanceof EOVersionFileContent) {
            return (EOVersionFileContent)eo;
        }
        return null;
    }

    protected abstract EncodableObjectBase readVersionFromFile(File var1) throws DumpFileAccessException;

    protected void checkState() throws DumpFileAccessException {
        if (this.state == 1) {
            throw new DumpFileAccessException("Calling a method on this ServerDumpFileAccess is not possible, because it is in an error state. At least one exception should have been thrown earlier (e.g. by the constructor).");
        }
        if (this.state == 4) {
            throw new DumpFileAccessException("Calling this method is not possible, because this ServerDumpFileAccess is in the wrong state (e.g. disposed).");
        }
    }
}

