/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.eclipseplugin;

import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.eclipseplugin.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MessageListener
implements INotificationBusListener {
    private static final ILogger logger = Logger.getLogger(MessageListener.class);

    public MessageListener() {
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListener(this, ".show.infomsg", null);
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListener(this, ".show.errormsg", null);
    }

    @Override
    public void receiveNotification(Notification notification) {
        Object parameter = notification.getParameter();
        if ((notification.getType().equals(".show.infomsg") || notification.getType().equals(".show.errormsg")) && parameter instanceof String) {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new AsyncMessageBoxStarter(notification.getType(), (String)parameter, new Exception()));
        }
    }

    private class AsyncMessageBoxStarter
    implements Runnable {
        private String msg;
        private String msgType;
        private final Exception ex;

        private AsyncMessageBoxStarter(String msgType, String msg, Exception ex) {
            if (msgType == null) {
                assert (false);
                this.msgType = "";
            } else {
                this.msgType = msgType;
            }
            if (msg == null) {
                assert (false);
                this.msg = "";
            } else {
                this.msg = msg;
            }
            this.ex = ex;
        }

        @Override
        public void run() {
            Shell shell = EclipseSWTHelper.getShell();
            if (shell == null || !shell.isDisposed()) {
                MessageDialog mDialog = this.msgType.equals(".show.infomsg") ? new MessageDialog(shell, Messages.getString("MessageListener.Information_1"), null, this.msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0) : (this.msgType.equals(".show.errormsg") ? new MessageDialog(shell, Messages.getString("MessageListener.Error_2"), null, this.msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0) : new MessageDialog(shell, Messages.getString("MessageListener.Message_3"), null, this.msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0));
                mDialog.open();
            } else {
                logger.error("AsyncMessageBoxStarter could not open Message Box. (Shell has been disposed)", new Exception());
                logger.error("    The message that should have been displayed in the MessageBox was:");
                logger.error("        Message-Type:  " + this.msgType);
                logger.error("        Message     :  " + this.msg);
                if (this.ex != null) {
                    logger.error("    The Stacktrace at the time when the Creation of the messageBox was requested was the following:", this.ex);
                }
            }
        }
    }
}

