/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.eclipseplugin;

import de.plans.psc.client.eclipseplugin.IExceptionDecoder;
import de.plans.psc.shared.message.EOException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import de.plans.psc.shared.serverexceptions.PSCAbstractExceptionDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EclipsePluginExceptionDecoder
extends PSCAbstractExceptionDecoder {
    private static final String CONFIGURATION_ELEMENT_NAME = "ExceptionDecoder";
    private static final String CLASS_ATTRIBUTE = "class";
    private List decoders;

    private void loadExceptionDecoderExtensions() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        assert (registry != null) : "registry must not be null";
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.lib.psc.client", "factories");
        assert (extensionPoint != null) : "extensionPoint must not be null";
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (CONFIGURATION_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    try {
                        IExceptionDecoder decoder = (IExceptionDecoder)currentConfigElement.createExecutableExtension(CLASS_ATTRIBUTE);
                        this.addDecoder(decoder);
                    }
                    catch (CoreException e) {
                        WorkbenchPlugin.log((String)("Unable to instantiate Exception Decoder for PSC system " + e.getStatus()));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public void throwApplServerException(EOException eMsg) throws EXServerException {
        if (this.decoders == null) {
            this.decoders = new ArrayList();
            this.loadExceptionDecoderExtensions();
        }
        int i = 0;
        while (i < this.decoders.size()) {
            IExceptionDecoder decoder = (IExceptionDecoder)this.decoders.get(i);
            decoder.throwServerException(eMsg);
            ++i;
        }
    }

    private void addDecoder(IExceptionDecoder decoder) {
        this.decoders.add(decoder);
    }
}

