/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.io.FileSystemDefaultPaths;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.SSLCommunicationException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.dialogs.swt.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.eclipse.equinox.internal.provisional.security.ui.X509CertificateViewDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SSLProblemDialog
extends ModificationProblemsDialog {
    private static final ILogger LOGGER = Logger.getLogger(SSLProblemDialog.class);
    private static final Integer BTNID_ReviewCert = 1025;
    private static final String BTNLabel_ReviewCert = Messages.getString("SSLProblemDialog.BTNLabel_ReviewCert");
    private static final Integer BTNID_ExportCert = 1026;
    private static final String BTNLabel_ExportCert = Messages.getString("SSLProblemDialog.BTNLabel_ExportCert");
    private static final Integer BTNID_Close = 12;
    private static final String BTNLabel_Close = IDialogConstants.CLOSE_LABEL;
    private static final Map<Integer, String> ButtonIdLabelMap = new HashMap<Integer, String>();
    private static final String DEFAULT_TRUSTSTORE_FILEFORMAT = "JKS";
    private static final String TRUSTSORE_ENTRY_ALIAS_FALLBACK = "ServerCertificate";
    private static final String DEFAULT_TRUSTSTORE_PASSWORD = "arcway";
    private static final String[] FILE_EXTENSIONS_FOR_JAVAKEYSTOREFILES;
    private final Certificate serverCertificate;
    private final String trustStoreEntryAliasName;
    private final ArrayList<Integer> dialogButtonIdList;

    static {
        ButtonIdLabelMap.put(BTNID_ReviewCert, BTNLabel_ReviewCert);
        ButtonIdLabelMap.put(BTNID_ExportCert, BTNLabel_ExportCert);
        ButtonIdLabelMap.put(BTNID_Close, BTNLabel_Close);
        FILE_EXTENSIONS_FOR_JAVAKEYSTOREFILES = new String[]{"*.jks", "*.ks"};
    }

    public SSLProblemDialog(Shell parentShell, String serverID, String dialogTitle, String dialogMessage, Collection<IModificationProblem> mProblems, SSLException sslException) {
        super(mProblems, dialogTitle, dialogMessage, parentShell);
        if (sslException instanceof SSLCommunicationException) {
            SSLCommunicationException sslCommunicationException = (SSLCommunicationException)sslException;
            Certificate[] serverCertificates = sslCommunicationException.getServerCertificates();
            if (serverCertificates != null && serverCertificates.length > 0) {
                PSCClientServiceFacade facade;
                ServerConnection serverConnection;
                this.serverCertificate = serverCertificates[0];
                this.trustStoreEntryAliasName = serverID != null ? ((serverConnection = (facade = PSCClientServiceFacade.getFacade()).getServerConnection(serverID)) != null ? serverConnection.getURL() : TRUSTSORE_ENTRY_ALIAS_FALLBACK) : TRUSTSORE_ENTRY_ALIAS_FALLBACK;
            } else {
                this.serverCertificate = null;
                this.trustStoreEntryAliasName = null;
            }
        } else {
            this.serverCertificate = null;
            this.trustStoreEntryAliasName = null;
        }
        this.dialogButtonIdList = new ArrayList();
        if (this.serverCertificate instanceof X509Certificate) {
            this.dialogButtonIdList.add(BTNID_ReviewCert);
        }
        if (this.serverCertificate != null) {
            this.dialogButtonIdList.add(BTNID_ExportCert);
        }
        this.dialogButtonIdList.add(BTNID_Close);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        for (Integer buttonId : this.dialogButtonIdList) {
            this.createButton(parent, buttonId, ButtonIdLabelMap.get(buttonId), buttonId.equals(BTNID_Close));
        }
    }

    protected void buttonPressed(int buttonId) {
        Integer button = buttonId;
        if (BTNID_ReviewCert.equals(button)) {
            this.reviewPressed();
        } else if (BTNID_ExportCert.equals(button)) {
            this.exportPressed();
        } else if (BTNID_Close.equals(button)) {
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void reviewPressed() {
        if (this.serverCertificate instanceof X509Certificate) {
            X509CertificateViewDialog d = new X509CertificateViewDialog(this.getShell(), (X509Certificate)this.serverCertificate);
            d.open();
        } else assert (false);
    }

    private void exportPressed() {
        if (this.serverCertificate != null) {
            boolean confirmed;
            FileChooserDialog fileChooserDialog = new FileChooserDialog(FILE_EXTENSIONS_FOR_JAVAKEYSTOREFILES, FileSystemDefaultPaths.getDefaultUserPathForSaving(), this.getShell());
            File keystoreFile = fileChooserDialog.openForSave();
            if (keystoreFile == null) {
                return;
            }
            if (keystoreFile.exists() && !(confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("SSLProblemDialog.KeystoreOverwriteConfirm_Title"), (String)NLS.bind((String)Messages.getString("SSLProblemDialog.KeystoreOverwriteConfirm_Message"), (Object)keystoreFile)))) {
                return;
            }
            try {
                KeyStore ks;
                FileOutputStream fos = new FileOutputStream(keystoreFile);
                try {
                    ks = KeyStore.getInstance(DEFAULT_TRUSTSTORE_FILEFORMAT);
                    ks.load(null, DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
                    KeyStore.TrustedCertificateEntry skEntry = new KeyStore.TrustedCertificateEntry(this.serverCertificate);
                    ks.setEntry(this.trustStoreEntryAliasName, skEntry, null);
                    ks.store(fos, DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error while closing Trust-/Keystore FileOutputStream.", e);
                    }
                }
                FileInputStream fin = new FileInputStream(keystoreFile);
                try {
                    ks = KeyStore.getInstance(DEFAULT_TRUSTSTORE_FILEFORMAT);
                    ks.load(fin, DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
                }
                finally {
                    try {
                        fin.close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error while closing Trust-/Keystore FileInputStream.", e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("An Error occured while saving the Keystore" + keystoreFile + ". The File may be unuseable.", e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("SSLProblemDialog.KeystoreExportFailed_Title"), (String)NLS.bind((String)Messages.getString("SSLProblemDialog.KeystoreExportFailed_Message"), (Object)keystoreFile));
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("SSLProblemDialog.KeystoreExportSuccess_Title"), (String)NLS.bind((String)Messages.getString("SSLProblemDialog.KeystoreExportSuccess_Message"), (Object)keystoreFile, (Object)DEFAULT_TRUSTSTORE_PASSWORD));
        } else assert (false);
    }
}

