/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import de.plans.lib.eclipse.LoggerCategoriesMgr;
import de.plans.lib.util.Log4jLoggerManager;
import de.plans.lib.util.LogCategory;
import de.plans.psc.client.dialogs.swt.Messages;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LoggerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFERENCE_KEY_VERBOSE_LEVEL = "logging.verboselevel";
    private static final String DEFAULT_VERBOSE_LEVEL = "LoggerPreferencePage.debugEnabled";
    private static final List levelList = new ArrayList();
    private UsableCheckboxTreeViewer tblCategories;
    private String selectedLevel;
    private Group debugCategories;
    private Label lblDebugCategories;

    static {
        levelList.add("LoggerPreferencePage.fatalEnabled");
        levelList.add("LoggerPreferencePage.errorEnabled");
        levelList.add("LoggerPreferencePage.warnEnabled");
        levelList.add("LoggerPreferencePage.infoEnabled");
        levelList.add(DEFAULT_VERBOSE_LEVEL);
        levelList.add("LoggerPreferencePage.traceEnabled");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite preferencePageRoot = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        preferencePageRoot.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        preferencePageRoot.setLayout((Layout)layout);
        preferencePageRoot.setFont(parent.getFont());
        this.createContent(preferencePageRoot);
        return preferencePageRoot;
    }

    private void createContent(Composite preferencePageRoot) {
        Composite verboseLevelBase = new Composite(preferencePageRoot, 0);
        verboseLevelBase.setLayoutData((Object)new GridData(768));
        verboseLevelBase.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(verboseLevelBase, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.getString("LoggerPreferencePage.verbosity"));
        final Combo levelCombo = new Combo(verboseLevelBase, 2048);
        levelCombo.setLayoutData((Object)new GridData(768));
        this.addLevelEntry("LoggerPreferencePage.fatalEnabled", "Fatal", levelCombo);
        this.addLevelEntry("LoggerPreferencePage.errorEnabled", "Error", levelCombo);
        this.addLevelEntry("LoggerPreferencePage.warnEnabled", "Warn", levelCombo);
        this.addLevelEntry("LoggerPreferencePage.infoEnabled", "Info", levelCombo);
        this.addLevelEntry(DEFAULT_VERBOSE_LEVEL, "Debug", levelCombo);
        this.addLevelEntry("LoggerPreferencePage.traceEnabled", "Trace", levelCombo);
        levelCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String index = Integer.toString(levelCombo.getSelectionIndex());
                LoggerPreferencePage.this.selectedLevel = (String)levelCombo.getData(index);
                LoggerPreferencePage.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.debugCategories = new Group(preferencePageRoot, 0);
        this.debugCategories.setLayoutData((Object)new GridData(1808));
        this.debugCategories.setLayout((Layout)new GridLayout());
        this.lblDebugCategories = new Label((Composite)this.debugCategories, 0);
        this.lblDebugCategories.setText(Messages.getString("LoggerPreferencePage.Select_the_debug_categories_which_shall_be_logged_on_client_side__3"));
        this.lblDebugCategories.setLayoutData((Object)new GridData(768));
        this.tblCategories = new UsableCheckboxTreeViewer((Composite)this.debugCategories);
        this.tblCategories.getTree().setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 170;
        this.tblCategories.getTree().setLayoutData((Object)gridData);
        ContentAndLabelProvider cp = new ContentAndLabelProvider();
        this.tblCategories.setContentProvider((IContentProvider)cp);
        this.tblCategories.setLabelProvider((IBaseLabelProvider)cp);
        this.tblCategories.setSorter(new ViewerSorter());
        List allCategories = LoggerCategoriesMgr.getLogCategories();
        this.tblCategories.setInput((Object)allCategories);
        ArrayList<LogCategory> checkedElements = new ArrayList<LogCategory>();
        for (LogCategory logCategory : allCategories) {
            if (!LoggerPreferencePage.getLogEnabled(logCategory)) continue;
            checkedElements.add(logCategory);
        }
        this.tblCategories.setCheckedElements(checkedElements.toArray());
        this.refresh();
    }

    private void refresh() {
        int selectedLevelIndex = levelList.indexOf(this.selectedLevel);
        if (selectedLevelIndex < levelList.indexOf(DEFAULT_VERBOSE_LEVEL)) {
            this.debugCategories.setEnabled(false);
            this.tblCategories.getTree().setEnabled(false);
            this.lblDebugCategories.setEnabled(false);
        } else {
            this.debugCategories.setEnabled(true);
            this.tblCategories.getTree().setEnabled(true);
            this.lblDebugCategories.setEnabled(true);
        }
    }

    private void addLevelEntry(String level, String text, Combo combo) {
        combo.add(text);
        int index = combo.getItemCount() - 1;
        String strIndex = Integer.toString(index);
        combo.setData(strIndex, (Object)level);
        if (Log4jLoggerManager.getVerboseLevelEnabled(level)) {
            combo.select(index);
            this.selectedLevel = level;
        }
    }

    public boolean performOk() {
        this.applySettings();
        return super.performOk();
    }

    private void applySettings() {
        List<Object> checkedElements = Arrays.asList(this.tblCategories.getCheckedElements());
        for (LogCategory category : LoggerCategoriesMgr.getLogCategories()) {
            if (checkedElements.contains(category)) {
                this.setShallBeLogged(category, true);
                continue;
            }
            this.setShallBeLogged(category, false);
        }
        LoggerPreferencePage.setLoggerToLevel(this.selectedLevel);
        LoggerPreferencePage.getStore().setValue(PREFERENCE_KEY_VERBOSE_LEVEL, this.selectedLevel);
    }

    private static boolean getLogEnabled(LogCategory category) {
        IPreferenceStore store = LoggerPreferencePage.getStore();
        boolean wasLogged = false;
        if (store != null) {
            wasLogged = store.getBoolean(LoggerPreferencePage.getCategoryKey(category));
        }
        return wasLogged;
    }

    private void setShallBeLogged(LogCategory category, boolean value) {
        IPreferenceStore store = LoggerPreferencePage.getStore();
        if (store != null) {
            store.setValue(LoggerPreferencePage.getCategoryKey(category), value);
        }
        if (value) {
            Log4jLoggerManager.enableDebugCategoryEnabled(category.getCategoryID());
        } else {
            Log4jLoggerManager.disableDebugCategoryEnabled(category.getCategoryID());
        }
    }

    private static String getCategoryKey(LogCategory category) {
        assert (category != null) : Messages.getString("LoggerPreferencePage.category_is_missing_6");
        return "LoggerPreferencePage" + category.getCategoryID();
    }

    protected static IPreferenceStore getStore() {
        if (EclipsePlugin.getDefault() != null) {
            return EclipsePlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    protected void performApply() {
        this.applySettings();
        super.performApply();
    }

    public static void initLogger() {
        List categories = LoggerCategoriesMgr.getLogCategories();
        int i = 0;
        while (i < categories.size()) {
            LogCategory category = (LogCategory)categories.get(i);
            boolean logEnabled = LoggerPreferencePage.getLogEnabled(category);
            if (logEnabled) {
                Log4jLoggerManager.enableDebugCategoryEnabled(category.getCategoryID());
            } else {
                Log4jLoggerManager.disableDebugCategoryEnabled(category.getCategoryID());
            }
            ++i;
        }
        if (!LoggerPreferencePage.getStore().contains(PREFERENCE_KEY_VERBOSE_LEVEL)) {
            LoggerPreferencePage.getStore().setValue(PREFERENCE_KEY_VERBOSE_LEVEL, DEFAULT_VERBOSE_LEVEL);
        }
        LoggerPreferencePage.setLoggerToLevel(LoggerPreferencePage.getStore().getString(PREFERENCE_KEY_VERBOSE_LEVEL));
    }

    private static void setLoggerToLevel(String level) {
        int i = levelList.size() - 1;
        while (i >= 0) {
            String currentLevel = (String)levelList.get(i);
            if (currentLevel.equals(level)) {
                int j = i;
                while (j >= 0) {
                    String levelToSet = (String)levelList.get(j);
                    Log4jLoggerManager.setVerboseLevelEnabled(levelToSet, true);
                    --j;
                }
                break;
            }
            Log4jLoggerManager.setVerboseLevelEnabled(currentLevel, false);
            --i;
        }
    }

    private class ContentAndLabelProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private Map logCategories;

        private ContentAndLabelProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Collection subEntries = (Collection)this.logCategories.get(parentElement);
            if (subEntries != null) {
                return subEntries.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof LogCategory) {
                LogCategory logCategory = (LogCategory)element;
                return logCategory.getComponent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.logCategories.containsKey(element);
        }

        public Object[] getElements(Object inputElement) {
            this.logCategories = new HashMap();
            Collection allLogCategories = (Collection)inputElement;
            for (LogCategory category : allLogCategories) {
                ArrayList<LogCategory> subEntries = (ArrayList<LogCategory>)this.logCategories.get(category.getComponent());
                if (subEntries == null) {
                    subEntries = new ArrayList<LogCategory>();
                    this.logCategories.put(category.getComponent(), subEntries);
                }
                subEntries.add(category);
            }
            return this.logCategories.keySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            LogCategory logCategory = (LogCategory)element;
            return logCategory.getHumanReadableName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

