/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import com.arcway.lib.java.collections.CollectionUtils;
import de.plans.psc.client.dialogs.admin.swt.LabelTextMatchFilter;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.shared.message.EOGroup;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class GroupListWrapper
implements ILabelProvider,
IStructuredContentProvider {
    private final ListViewer viewer;
    private final LabelTextMatchFilter labelTextMatchFilter = new LabelTextMatchFilter(this);

    public GroupListWrapper(Composite c, int style) {
        this.viewer = new ListViewer(c, style);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setSorter(new ViewerSorter(){});
        this.viewer.setFilters(new ViewerFilter[]{this.labelTextMatchFilter});
    }

    public void setFilter(String pattern) {
        this.labelTextMatchFilter.setFilter(pattern);
        this.viewer.setFilters(new ViewerFilter[]{this.labelTextMatchFilter});
    }

    public void setSelectionOnSingleDisplayedElement() {
        Object selectionElement = null;
        if (this.viewer.getElementAt(1) == null) {
            selectionElement = this.viewer.getElementAt(0);
        }
        if (selectionElement != null) {
            StructuredSelection sel = new StructuredSelection(selectionElement);
            this.viewer.setSelection((ISelection)sel);
        } else {
            this.viewer.setSelection(null);
        }
    }

    public String getText(Object element) {
        if (element instanceof UserGroup) {
            UserGroup group = (UserGroup)element;
            return String.valueOf(group.getDisplayName()) + "   (" + group.getGroupName() + ")";
        }
        if (element instanceof EOGroup) {
            EOGroup group = (EOGroup)element;
            return String.valueOf(group.getDisplayName()) + "   (" + group.getGroupName() + ")";
        }
        return "-";
    }

    public Object[] getElements(Object inputElement) {
        GroupListModel gm = (GroupListModel)inputElement;
        return gm.toArray();
    }

    public UserGroup getFirstSelectedGroup() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            return (UserGroup)selection.getFirstElement();
        }
        return null;
    }

    public List<UserGroup> getSelectedGroups() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        return CollectionUtils.getTypedList(selection.toList(), UserGroup.class);
    }

    public ListViewer getViewer() {
        return this.viewer;
    }

    public Image getImage(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void inputChanged(Viewer p_viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

