/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin;

import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.lib.util.PasswordEncoder2;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.ServerOperationsPermissionChecker;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.admin.AdminDialogFactoryIF;
import de.plans.psc.client.dialogs.admin.AssignGroupsToUserWizardIF;
import de.plans.psc.client.dialogs.admin.ChangePasswordWizardIF;
import de.plans.psc.client.dialogs.admin.CtrlChangePassword;
import de.plans.psc.client.dialogs.admin.DlgAdminUsersIF;
import de.plans.psc.client.dialogs.admin.EditUserDataWizardIF;
import de.plans.psc.client.dialogs.admin.ISetPermissionsOfUserWizard;
import de.plans.psc.client.dialogs.admin.Messages;
import de.plans.psc.client.dialogs.admin.NewUserDataWizardIF;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.PermissionListModel;
import de.plans.psc.client.model.User;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.client.model.UserListModel;
import de.plans.psc.client.model.UserWithGroups;
import de.plans.psc.shared.PSCPermissionConstants;
import de.plans.psc.shared.message.EOAddUserRequest;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.serverexceptions.EXPermissionException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class CtrlAdminUsers
implements INotificationBusListener {
    private final UserListModel userList = new UserListModel();
    private final PermissionListModel permissionListModel = new PermissionListModel();
    private final GroupListModel groupList = new GroupListModel();
    private String serverID;
    private DlgAdminUsersIF dialog;
    private final AdminDialogFactoryIF factory;
    boolean userAdmin = false;

    public CtrlAdminUsers(AdminDialogFactoryIF factory) {
        this.factory = factory;
    }

    public void construct() {
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListener(this, "admin.adminusers", null);
    }

    @Override
    public void receiveNotification(Notification notification) {
        this.dialog = this.factory.getUserAdminDialog();
        this.dialog.construct(this);
        this.dialog.show();
    }

    public void setServer(ServerConnection server) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        boolean hasPermissionToAdminUsers = false;
        hasPermissionToAdminUsers = ServerOperationsPermissionChecker.isAdminUser(server.getServerID(), true);
        if (!hasPermissionToAdminUsers) {
            this.showInsufficentPrivilegesMessage();
        } else {
            this.serverID = server.getServerID();
            if (this.serverID != null) {
                this.doRetrieveUserList();
                this.userAdmin = ServerOperationsPermissionChecker.isAdminUser(this.serverID);
                this.doRetrievePermissionList();
                this.dialog.construct(this.serverID, this.userList, this.userAdmin, this.permissionListModel);
            }
        }
    }

    public boolean isUserRealmWritable() {
        String userRealmRepositoryType;
        boolean writeable = false;
        if (this.serverID != null && "PSC-Server".equals(userRealmRepositoryType = PSCClientServiceFacade.getFacade().getUserRealmRepositoryType(this.serverID))) {
            writeable = true;
        }
        return writeable;
    }

    public void doRefresh() {
        try {
            this.doRetrieveUserList();
        }
        catch (EXServerException e) {
            PSCClientServiceFacade.getFacade().showException(e, this.serverID);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
        }
        catch (LoginCanceledException loginCanceledException) {
        }
        catch (UnknownServerException unknownServerException) {
            // empty catch block
        }
    }

    public User doAddUser() {
        UserWithGroups newUser;
        block14: {
            newUser = null;
            if (this.userAdmin && this.isUserRealmWritable()) {
                try {
                    this.doRetrievePermissionList();
                    this.doRetrieveGroupList();
                    String[] names = this.userList.getUserNames();
                    NewUserDataWizardIF wizard = this.factory.getNewUserWizard(this.dialog);
                    wizard.construct(Messages.getString("CtrlAdminUsers.New_User_1"), this.groupList, true, names, this.permissionListModel);
                    int result = wizard.invokeWizard();
                    if (result != 0) break block14;
                    newUser = wizard.getNewUser();
                    if (newUser != null) {
                        List deletedPermissions;
                        EOAddUserRequest requestData = new EOAddUserRequest();
                        requestData.setUser(newUser.getEOMUser());
                        requestData.setPasswd(PasswordEncoder2.encodePassword(wizard.getUserPassword()));
                        EOClientRequest request = new EOClientRequest("User", "AddUser", requestData);
                        PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                        request = new EOClientRequest("User", "AddUserToGroups", newUser.getEOMUserAndGroups());
                        PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                        this.doRetrieveUserList();
                        int c = 0;
                        while (c < this.userList.getSize()) {
                            User user = this.userList.getElement(c);
                            if (user.getUserName().equals(newUser.getUserName())) {
                                newUser = (UserWithGroups)user;
                                break;
                            }
                            ++c;
                        }
                        List addedPermissions = wizard.getAddedPermissions();
                        if (addedPermissions != null) {
                            int i = 0;
                            while (i < addedPermissions.size()) {
                                EOPermission addedPermission = (EOPermission)addedPermissions.get(i);
                                this.permissionListModel.addPermission(addedPermission);
                                ++i;
                            }
                        }
                        if ((deletedPermissions = wizard.getDeletedPermissions()) != null) {
                            int i = 0;
                            while (i < deletedPermissions.size()) {
                                EOPermission deletedPermission = (EOPermission)deletedPermissions.get(i);
                                this.permissionListModel.deletePermission(deletedPermission);
                                ++i;
                            }
                        }
                        this.permissionListModel.commitChanges();
                        break block14;
                    }
                    this.permissionListModel.discardChanges();
                }
                catch (EXServerException e) {
                    PSCClientServiceFacade.getFacade().showException(e, this.serverID);
                }
                catch (ServerNotAvailableException serverNotAvailableException) {
                }
                catch (UnknownServerException unknownServerException) {
                }
                catch (LoginCanceledException loginCanceledException) {}
            } else {
                this.showInsufficentPrivilegesMessage();
            }
        }
        return newUser;
    }

    public void doDeleteUser(User user) {
        if (this.userAdmin && this.isUserRealmWritable()) {
            EOClientRequest request = new EOClientRequest("User", "DelUser", new EOValue(user.getUserName()));
            try {
                PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                this.userList.removeElement(user);
                List<EOPermission> deletedPermissions = this.permissionListModel.getPermissionsOfUser(user.getUserName());
                if (deletedPermissions != null) {
                    int i = 0;
                    while (i < deletedPermissions.size()) {
                        EOPermission deletedPermission = deletedPermissions.get(i);
                        this.permissionListModel.deletePermission(deletedPermission);
                        ++i;
                    }
                }
                this.permissionListModel.commitChanges();
            }
            catch (EXServerException e) {
                PSCClientServiceFacade.getFacade().showException(e, this.serverID);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
            }
            catch (UnknownServerException unknownServerException) {
            }
            catch (LoginCanceledException loginCanceledException) {}
        } else {
            this.showInsufficentPrivilegesMessage();
        }
    }

    public User doEditUserData(User user) {
        if (this.userAdmin && this.isUserRealmWritable()) {
            EditUserDataWizardIF wizard = this.factory.getEditUserWizard(this.dialog);
            wizard.construct(user);
            wizard.invokeWizard();
            User editedUser = wizard.getResult();
            if (editedUser != null) {
                EOClientRequest request = new EOClientRequest("User", "UpdateUserData", editedUser.getEOMUser());
                try {
                    PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                    this.doRetrieveUserList();
                    user.setUserName(editedUser.getUserName());
                    user.setDisplayName(editedUser.getDisplayName());
                    user.setDescription(editedUser.getDescription());
                    user.setEmail(editedUser.getEMail());
                }
                catch (EXServerException e) {
                    PSCClientServiceFacade.getFacade().showException(e, this.serverID);
                }
                catch (ServerNotAvailableException serverNotAvailableException) {
                }
                catch (UnknownServerException unknownServerException) {
                }
                catch (LoginCanceledException loginCanceledException) {}
            }
        } else {
            this.showInsufficentPrivilegesMessage();
        }
        return user;
    }

    public void doChangePassword(User user) {
        if (this.userAdmin && this.isUserRealmWritable()) {
            ChangePasswordWizardIF wizard = this.factory.getChangePasswordWizard(this.dialog);
            boolean checkOldPassword = false;
            try {
                EOUser currentUser = PSCClientServiceFacade.getFacade().getUserData(this.serverID).getUser();
                checkOldPassword = currentUser.getUserName().equals(user.getUserName());
                wizard.invokeWizard(checkOldPassword ? 1 : 3);
                String password = wizard.getNewPassword();
                String oldPassword = wizard.getOldPassword();
                if (password != null) {
                    CtrlChangePassword.sendPasswortChangeRequest(this.serverID, user.getUserName(), checkOldPassword ? oldPassword : "", password);
                }
            }
            catch (EXPermissionException epe) {
                MessageDialog mDialog = new MessageDialog(EclipseSWTHelper.getShell(), Messages.getString("CtrlAdminUsers.ChangePassword.Error.NoPermission.Title"), null, checkOldPassword ? Messages.getString("CtrlAdminUsers.ChangePassword.Error.NoPermissionOrIncorrectOldPassword.Message") : Messages.getString("CtrlAdminUsers.ChangePassword.Error.NoPermission.Message"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
            }
            catch (EXServerException e) {
                PSCClientServiceFacade.getFacade().showException(e, this.serverID);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
            }
            catch (UnknownServerException unknownServerException) {
            }
            catch (LoginCanceledException loginCanceledException) {}
        } else {
            this.showInsufficentPrivilegesMessage();
        }
    }

    public void doAssignPermissions(UserWithGroups user) {
        try {
            if (this.userAdmin) {
                ISetPermissionsOfUserWizard wizard = this.factory.getSetPermissionsOfUserWizard(this.dialog);
                wizard.construct(user.getEOMUser(), this.permissionListModel);
                int result = wizard.invokeWizard();
                if (result == 0) {
                    List deletedPermissions;
                    List addedPermissions = wizard.getAddedPermissions();
                    if (addedPermissions != null) {
                        int i = 0;
                        while (i < addedPermissions.size()) {
                            EOPermission addedPermission = (EOPermission)addedPermissions.get(i);
                            this.permissionListModel.addPermission(addedPermission);
                            ++i;
                        }
                    }
                    if ((deletedPermissions = wizard.getDeletedPermissions()) != null) {
                        int i = 0;
                        while (i < deletedPermissions.size()) {
                            EOPermission deletedPermission = (EOPermission)deletedPermissions.get(i);
                            if (!PSCPermissionConstants.isMandatoryPermission(deletedPermission)) {
                                this.permissionListModel.deletePermission(deletedPermission);
                            }
                            ++i;
                        }
                    }
                    this.permissionListModel.commitChanges();
                } else {
                    this.permissionListModel.discardChanges();
                }
            }
        }
        catch (EXServerException e) {
            PSCClientServiceFacade.getFacade().showException(e, this.serverID);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
        }
        catch (UnknownServerException unknownServerException) {
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
    }

    public void doAssignGroups(UserWithGroups user) {
        if (this.isUserRealmWritable()) {
            try {
                this.doRetrieveGroupList();
                List<UserGroup> oldGroups = user.getGroups();
                AssignGroupsToUserWizardIF wizard = this.factory.getAssignGroupsToUserWizard(this.dialog);
                wizard.construct(user, this.groupList);
                wizard.invokeWizard();
                UserWithGroups editedUser = wizard.getResult();
                if (editedUser != null) {
                    List<UserGroup> newGroups = editedUser.getGroups();
                    ArrayList<UserGroup> addedGroups = new ArrayList<UserGroup>();
                    ArrayList<UserGroup> removedGroups = new ArrayList<UserGroup>();
                    int i = 0;
                    while (i < oldGroups.size()) {
                        if (!newGroups.contains(oldGroups.get(i))) {
                            removedGroups.add(oldGroups.get(i));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < newGroups.size()) {
                        if (!oldGroups.contains(newGroups.get(i))) {
                            addedGroups.add(newGroups.get(i));
                        }
                        ++i;
                    }
                    editedUser.setGroups(addedGroups);
                    EOClientRequest request = new EOClientRequest("User", "AddUserToGroups", editedUser.getEOMUserAndGroups());
                    PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                    editedUser.setGroups(removedGroups);
                    request = new EOClientRequest("User", "RemoveUserFromGroups", editedUser.getEOMUserAndGroups());
                    PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                    this.doRetrieveUserList();
                    user.setGroups(newGroups);
                }
            }
            catch (EXServerException e) {
                PSCClientServiceFacade.getFacade().showException(e, this.serverID);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
            }
            catch (UnknownServerException unknownServerException) {
            }
            catch (LoginCanceledException loginCanceledException) {}
        } else {
            this.showInsufficentPrivilegesMessage();
        }
    }

    private void doRetrieveUserList() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.userList.loadUsersWithGroupsFromServer(this.serverID);
    }

    private void doRetrievePermissionList() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.permissionListModel.loadPermissionsFromServer(this.serverID);
    }

    private void doRetrieveGroupList() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.groupList.loadGroupsFromServer(this.serverID);
    }

    private void showInsufficentPrivilegesMessage() {
        PSCClientServiceFacade.getFacade().showInfoMessage(String.valueOf(Messages.getString("CtrlAdminUsers.You_are_not_permitted_for_that_action_!__2")) + Messages.getString("CtrlAdminUsers.You_must_have_user_administration_permission._3"), this.serverID);
    }
}

