/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.AbstractRequestJob;
import de.plans.psc.client.communication.EXNotLoggedInOrConnectionBroken;
import de.plans.psc.client.communication.IDataTransferRequestJob;
import de.plans.psc.client.communication.SegmentExchangeSupervisor;
import de.plans.psc.client.communication.transmissionprocessor.ClientRequestTable;
import de.plans.psc.client.communication.transmissionprocessor.CommunicationSession;
import de.plans.psc.client.communication.transmissionprocessor.DownloadRequestJobProgressSummary;
import de.plans.psc.client.communication.transmissionprocessor.SegmentExchangeProcessorPool;
import de.plans.psc.client.communication.transmissionprocessor.WorkloadTransmissionThread;
import de.plans.psc.shared.message.RequestFamily;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;

public class StepFileDownloadRequestJob
extends AbstractRequestJob
implements IDataTransferRequestJob,
WorkloadTransmissionThread.IDiscreteWorkloadProcessorActivity {
    private static final ILogger logger = Logger.getLogger(StepFileDownloadRequestJob.class);
    private final List<String> transferIDs;
    private final List<File> files;
    private boolean transferCancellingRequested;
    private IDataTransferRequestJob.TransferState transferState;
    private Throwable errorCause;
    private int transferNumber;
    private ClientRequestTable.RequestTableEntry requestTableEntry;

    public StepFileDownloadRequestJob(List<String> transferIDs, List<File> files) {
        assert (transferIDs.size() == files.size());
        this.transferIDs = transferIDs;
        this.files = files;
        this.transferCancellingRequested = false;
        this.transferState = IDataTransferRequestJob.TransferState.TRANSFER_IN_PROGRESS;
        this.errorCause = null;
        this.transferNumber = -1;
        this.requestTableEntry = null;
    }

    private synchronized void updateTransferState(IDataTransferRequestJob.TransferState newState, Throwable th) {
        this.transferState = newState;
        this.errorCause = th;
    }

    @Override
    public synchronized void cancelTransfer() {
        this.transferCancellingRequested = true;
        if (this.requestTableEntry != null) {
            this.requestTableEntry.cancel();
        }
    }

    @Override
    public synchronized DownloadRequestJobProgressSummary getProgressSummary() {
        if (this.requestTableEntry != null) {
            return new DownloadRequestJobProgressSummary(this.transferNumber, this.transferIDs.size(), this.requestTableEntry.getProgressSummarySnapshot());
        }
        return new DownloadRequestJobProgressSummary(this.transferNumber, this.transferIDs.size(), null);
    }

    @Override
    public synchronized IDataTransferRequestJob.TransferState getTransferResult() {
        this.waitUntilRequestIsProcessed(0L);
        return this.transferState;
    }

    @Override
    public synchronized Throwable getErrorCause() {
        this.waitUntilRequestIsProcessed(0L);
        return this.errorCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(CommunicationSession communicationSession) {
        boolean communicationErrorOccured = false;
        try {
            if (communicationSession == null) {
                this.updateTransferState(IDataTransferRequestJob.TransferState.TRANSFER_TERMINATED_WITH_ERROR, new EXNotLoggedInOrConnectionBroken());
                boolean bl = communicationErrorOccured;
                return bl;
            }
            ClientRequestTable requestTable = communicationSession.getRequestTable();
            this.transferNumber = 0;
            while (this.transferNumber < this.transferIDs.size()) {
                String transferID = this.transferIDs.get(this.transferNumber);
                File file = this.files.get(this.transferNumber);
                LinkedHashMap<String, String> requestExtraHeaderFields = new LinkedHashMap<String, String>();
                requestExtraHeaderFields.put("TransferID", transferID);
                requestExtraHeaderFields.put("Direction", "Download");
                StepFileDownloadRequestJob stepFileDownloadRequestJob = this;
                synchronized (stepFileDownloadRequestJob) {
                    if (this.transferCancellingRequested) {
                        throw new SegmentExchangeSupervisor.ExSegmentExchangeCancelled();
                    }
                    this.requestTableEntry = requestTable.getNextFreeRequestEntry(RequestFamily.REQUEST_FAMILY_FileTransfer, requestExtraHeaderFields);
                }
                try {
                    this.requestTableEntry.getRequest().initialiseEmpty();
                    try {
                        SegmentExchangeSupervisor.exchangeSegments(communicationSession, this.requestTableEntry);
                    }
                    catch (SegmentExchangeSupervisor.ExSegmentExchangeCancelled e) {
                        throw e;
                    }
                    catch (SegmentExchangeProcessorPool.ExPrematureEndOfSegmentExchange e) {
                        communicationErrorOccured = true;
                        throw e;
                    }
                    DataCopyHelper.copyFile(this.requestTableEntry.getResponse().getContentAsStream(), file);
                }
                finally {
                    requestTable.requestCycleCompleted(this.requestTableEntry);
                }
                ++this.transferNumber;
            }
            this.updateTransferState(IDataTransferRequestJob.TransferState.TRANSFER_COMPLETED_SUCCESSFULLY, null);
            boolean bl = communicationErrorOccured;
            return bl;
        }
        catch (SegmentExchangeSupervisor.ExSegmentExchangeCancelled e) {
            this.updateTransferState(IDataTransferRequestJob.TransferState.TRANSFER_CANCELLED, e);
            boolean bl = communicationErrorOccured;
            return bl;
        }
        catch (Throwable th) {
            this.updateTransferState(IDataTransferRequestJob.TransferState.TRANSFER_TERMINATED_WITH_ERROR, th);
            boolean bl = communicationErrorOccured;
            return bl;
        }
        finally {
            if (this.transferState != IDataTransferRequestJob.TransferState.TRANSFER_COMPLETED_SUCCESSFULLY) {
                logger.warn("Download Transfer ended with status " + this.transferState, this.errorCause);
            }
            this.requestProcessingHasTerminated();
        }
    }
}

