/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.concurrent.Future;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.PasswordEncoder2;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.communication.EXNotLoggedInOrConnectionBroken;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.transmissionprocessor.AbstractSnoopRequestJobStep;
import de.plans.psc.client.communication.transmissionprocessor.CommunicationSession;
import de.plans.psc.client.communication.transmissionprocessor.ConnectionState;
import de.plans.psc.client.communication.transmissionprocessor.IControlProcessorStep;
import de.plans.psc.client.communication.transmissionprocessor.IControlProcessorStepTriggeringNotificationFetchRequest;
import de.plans.psc.client.communication.transmissionprocessor.IDiscreteControlProcessorStep;
import de.plans.psc.client.communication.transmissionprocessor.RequestTransmissionAndUpdateEnquiryProcessor;
import de.plans.psc.client.communication.transmissionprocessor.StepAbstractStandardRequestJob;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOLoginResponse;
import de.plans.psc.shared.message.EONotificationPacket;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.LinkedList;

public final class ControlAndUpdateEnquiryThread
implements Runnable {
    private static final ILogger logger = Logger.getLogger(ControlAndUpdateEnquiryThread.class);
    private static final String THREAD_NAME = "TransmissionProcessor - Control";
    private static final long MaxDueDate = Long.MAX_VALUE;
    private final XMLDecoder xmlDecoder;
    private final String serverName;
    private URL serverURL;
    private CommunicationSession communicationSession;
    private ConnectionState connectionState;
    private boolean sendEnquiries;
    private long notificationEnquiryInterval;
    private long latestNotificationPacketSerial;
    private long previouslyFetchedNotificationPacketSerial;
    private StepLoginRequestJob loginRequestInProgress;
    private StepAbstractStandardRequestJob pendingLoginPhase2Job;
    private StepAbstractStandardRequestJob pendingNotificationFetchJob;
    private final RequestTransmissionAndUpdateEnquiryProcessor requestTransmissionAndUpdateEnquiryProcessor;
    private final PSCAbstractMessageDataFactory messageFactory;
    private final RequestTransmissionAndUpdateEnquiryProcessor.INotificationEnquiryResponseConsumer notificationConsumer;
    private final LinkedList<IControlProcessorStep> processorStepQueue;
    private boolean mainLoopStopInitiated;
    private boolean mainLoopStopped;
    private final IControlProcessorStep stepNOP = new IDiscreteControlProcessorStep(){

        @Override
        public void executeStep() {
        }
    };
    private final IControlProcessorStep stepStopProcessor = new IDiscreteControlProcessorStep(){

        @Override
        public void executeStep() {
            ControlAndUpdateEnquiryThread.this.mainLoopStopped = true;
        }
    };
    private final IControlProcessorStep stepScheduleEnquiryRequestJob = new IDiscreteControlProcessorStep(){

        @Override
        public void executeStep() {
            EOClientRequest request = new EOClientRequest("Notification", "Fetch", null);
            if (!$assertionsDisabled && ControlAndUpdateEnquiryThread.this.pendingNotificationFetchJob != null) {
                throw new AssertionError();
            }
            ControlAndUpdateEnquiryThread.this.pendingNotificationFetchJob = ControlAndUpdateEnquiryThread.this.requestTransmissionAndUpdateEnquiryProcessor.chargeControlProcessorDelegatedRequestJob(request);
        }
    };

    void updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState newState) {
        assert (newState != ConnectionState.CONNECTIONOK || this.communicationSession != null) : "sessionURLAndNegotiatedCompressionType must be set when (just before) entering ConnectionState.CONNECTIONOK";
        this.connectionState = newState;
        if (this.connectionState != ConnectionState.CONNECTIONOK) {
            PSCAuthenticator.revokePasswordAuthentication(this);
        }
        if (this.connectionState != ConnectionState.CONNECTIONOK && this.communicationSession != null) {
            this.communicationSession.getSegmentExchangeProcessorPool().dispose();
        }
        if (this.connectionState == ConnectionState.DISCONNECTED) {
            this.communicationSession = null;
        }
    }

    private URL getCommunicationURL() {
        return this.communicationSession != null ? this.communicationSession.getUrl() : this.serverURL;
    }

    private CommunicationSession getCommunicationSession() {
        if (this.communicationSession == null) {
            logger.debug("CummunicationSession requested before it was established.", new Exception());
        }
        return this.communicationSession;
    }

    public ControlAndUpdateEnquiryThread(RequestTransmissionAndUpdateEnquiryProcessor requestTransmissionAndUpdateEnquiryProcessor, String serverName, URL serverURL, long notificationEnquiryInterval, PSCAbstractMessageDataFactory messageFactory, RequestTransmissionAndUpdateEnquiryProcessor.INotificationEnquiryResponseConsumer notificationConsumer) {
        this.xmlDecoder = new XMLDecoder();
        this.serverName = serverName;
        this.serverURL = serverURL;
        this.communicationSession = null;
        this.connectionState = ConnectionState.DISCONNECTED;
        this.sendEnquiries = false;
        this.notificationEnquiryInterval = notificationEnquiryInterval;
        this.latestNotificationPacketSerial = 0L;
        this.previouslyFetchedNotificationPacketSerial = 0L;
        this.pendingNotificationFetchJob = null;
        this.requestTransmissionAndUpdateEnquiryProcessor = requestTransmissionAndUpdateEnquiryProcessor;
        this.messageFactory = messageFactory;
        this.notificationConsumer = notificationConsumer;
        this.processorStepQueue = new LinkedList();
        this.mainLoopStopInitiated = false;
        this.mainLoopStopped = false;
        Thread t = new Thread((Runnable)this, "TransmissionProcessor - Control -- " + serverName);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastNotificationFetchRequestSendTime = 0L;
        long currentTimeMillis = 0L;
        while (!this.mainLoopStopped) {
            IControlProcessorStep nextStep = null;
            currentTimeMillis = System.currentTimeMillis();
            ControlAndUpdateEnquiryThread controlAndUpdateEnquiryThread = this;
            synchronized (controlAndUpdateEnquiryThread) {
                if (!this.processorStepQueue.isEmpty()) {
                    nextStep = this.processorStepQueue.removeFirst();
                } else if (this.connectionState == ConnectionState.CONNECTIONOK && this.loginRequestInProgress == null && this.sendEnquiries && this.pendingNotificationFetchJob == null && (lastNotificationFetchRequestSendTime + this.notificationEnquiryInterval < currentTimeMillis || this.latestNotificationPacketSerial > this.previouslyFetchedNotificationPacketSerial)) {
                    nextStep = this.stepScheduleEnquiryRequestJob;
                } else {
                    long nextEnquiryTriggerDueTime2;
                    long waitDueDate = Long.MAX_VALUE;
                    if (this.connectionState == ConnectionState.CONNECTIONOK && this.sendEnquiries && this.loginRequestInProgress == null && this.pendingNotificationFetchJob == null && waitDueDate > (nextEnquiryTriggerDueTime2 = lastNotificationFetchRequestSendTime + this.notificationEnquiryInterval)) {
                        waitDueDate = nextEnquiryTriggerDueTime2;
                    }
                    if (waitDueDate == Long.MAX_VALUE) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException nextEnquiryTriggerDueTime2) {}
                    } else {
                        long durationToWait = waitDueDate - currentTimeMillis;
                        if (durationToWait > 0L) {
                            try {
                                this.wait(durationToWait);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    nextStep = this.stepNOP;
                }
            }
            try {
                if (nextStep instanceof IControlProcessorStepTriggeringNotificationFetchRequest) {
                    IControlProcessorStepTriggeringNotificationFetchRequest fetchStep = (IControlProcessorStepTriggeringNotificationFetchRequest)nextStep;
                    lastNotificationFetchRequestSendTime = currentTimeMillis;
                    fetchStep.executeStep();
                    continue;
                }
                if (nextStep instanceof IDiscreteControlProcessorStep) {
                    IDiscreteControlProcessorStep discreteStep = (IDiscreteControlProcessorStep)nextStep;
                    discreteStep.executeStep();
                    continue;
                }
                assert (false) : "A ControlAndUpdateEnquiryThread-RequestJob is expected to be either a instanceof IControlProcessorStepTriggeringNotificationFetchRequest or a instanceof IDiscreteControlProcessorStep";
            }
            catch (Throwable throwable) {
                logger.error("TransmissionProcessor - Control: An Exception was encountered within the main-loop.", throwable);
            }
        }
    }

    public synchronized void stopProcessor() {
        if (!this.mainLoopStopInitiated) {
            this.mainLoopStopInitiated = true;
            this.processorStepQueue.clear();
            this.processorStepQueue.add(this.stepStopProcessor);
            this.notifyAll();
        }
    }

    private synchronized void queueNewProcessorStep(IControlProcessorStep newStep) {
        if (this.mainLoopStopInitiated) {
            logger.warn("Attempt to enque new control processor Steps after the processor has been taken out of service.", new Exception());
        } else {
            this.processorStepQueue.add(newStep);
            this.notifyAll();
        }
    }

    public ISnoopRequestJob chargeSnoopRequest() {
        SnoopRequestJobStep newRequestJob = new SnoopRequestJobStep();
        this.queueNewProcessorStep(newRequestJob);
        return newRequestJob;
    }

    public IRequestJob chargeLoginRequest(PSCApplicationIdentifier applicationIdentifier, PSCClientLicenseInfo clientLicenseSetting, PasswordAuthentication passwordAuthentication, PSCAuthenticator.RequestorInfo requestorInfo, String username, String password2) {
        StepLoginRequestJob newRequestJob = new StepLoginRequestJob(applicationIdentifier, clientLicenseSetting, passwordAuthentication, requestorInfo, username, password2);
        this.queueNewProcessorStep(newRequestJob);
        return newRequestJob;
    }

    public CommunicationSession approveStartOfWorkloadRequestWithNotificationFetch(StepAbstractStandardRequestJob requestJob) {
        StepApproveStartOfWorkloadRequestWithNotificationFetchRequestJob newStep = new StepApproveStartOfWorkloadRequestWithNotificationFetchRequestJob(requestJob);
        this.queueNewProcessorStep(newStep);
        return newStep.getApprovalResult();
    }

    public void finalizeWorkloadRequestWithNotificationFetch(CommunicationSession workloadCommunicationSession, StepAbstractStandardRequestJob requestJob) {
        StepFinalizeWorkloadRequestWithNotificationFetchRequestJob newStep = new StepFinalizeWorkloadRequestWithNotificationFetchRequestJob(requestJob, workloadCommunicationSession);
        this.queueNewProcessorStep(newStep);
    }

    public CommunicationSession approveStartOfDiscreteWorkloadRequestJob() {
        StepApproveStartOfDiscreteWorkloadRequestJob newStep = new StepApproveStartOfDiscreteWorkloadRequestJob();
        this.queueNewProcessorStep(newStep);
        return newStep.getApprovalResult();
    }

    public void considerDiscreteWorkloadRequestJobFeedback(CommunicationSession workloadCommunicationSession, boolean communicationErrorOccured) {
        StepConsiderDiscreteWorkloadRequestJobFeedback newStep = new StepConsiderDiscreteWorkloadRequestJobFeedback(workloadCommunicationSession, communicationErrorOccured);
        this.queueNewProcessorStep(newStep);
    }

    public IRequestJob chargeDisconnectRequest() {
        StepDisconnectRequestJob disconnectRequestJob = new StepDisconnectRequestJob();
        this.queueNewProcessorStep(disconnectRequestJob);
        return disconnectRequestJob;
    }

    public void updateServerURL(final URL url) {
        IDiscreteControlProcessorStep newStep = new IDiscreteControlProcessorStep(){

            @Override
            public void executeStep() {
                ControlAndUpdateEnquiryThread.this.serverURL = url;
            }
        };
        this.queueNewProcessorStep(newStep);
    }

    public void updateNotificationEnquiryInterval(final long interval) {
        IDiscreteControlProcessorStep newStep = new IDiscreteControlProcessorStep(){

            @Override
            public void executeStep() {
                ControlAndUpdateEnquiryThread.this.notificationEnquiryInterval = interval;
            }
        };
        this.queueNewProcessorStep(newStep);
    }

    public void stopNotificationEnquiry() {
        IDiscreteControlProcessorStep newStep = new IDiscreteControlProcessorStep(){

            @Override
            public void executeStep() {
                ControlAndUpdateEnquiryThread.this.sendEnquiries = false;
            }
        };
        this.queueNewProcessorStep(newStep);
    }

    public void startNotificationEnquiry() {
        IDiscreteControlProcessorStep newStep = new IDiscreteControlProcessorStep(){

            @Override
            public void executeStep() {
                ControlAndUpdateEnquiryThread.this.sendEnquiries = true;
            }
        };
        this.queueNewProcessorStep(newStep);
    }

    private class SnoopRequestJobStep
    extends AbstractSnoopRequestJobStep
    implements IDiscreteControlProcessorStep {
        private SnoopRequestJobStep() {
        }

        @Override
        public void executeStep() {
            URL communicationURL = ControlAndUpdateEnquiryThread.this.getCommunicationURL();
            this.do_snoop(communicationURL);
            this.requestProcessingHasTerminated();
        }
    }

    private class StepApproveStartOfDiscreteWorkloadRequestJob
    extends StepApproveStartOfWorkloadRequest
    implements IDiscreteControlProcessorStep {
    }

    private abstract class StepApproveStartOfWorkloadRequest {
        private final Future future = new Future();
        private CommunicationSession approvalResult;

        public void executeStep() {
            this.approvalResult = ControlAndUpdateEnquiryThread.this.connectionState == ConnectionState.CONNECTIONOK ? ControlAndUpdateEnquiryThread.this.getCommunicationSession() : null;
            this.future.triggerWaitingThreads();
        }

        public CommunicationSession getApprovalResult() {
            this.future.waitUntilTriggered();
            return this.approvalResult;
        }
    }

    private class StepApproveStartOfWorkloadRequestWithNotificationFetchRequestJob
    extends StepApproveStartOfWorkloadRequest
    implements IControlProcessorStepTriggeringNotificationFetchRequest {
        public StepApproveStartOfWorkloadRequestWithNotificationFetchRequestJob(StepAbstractStandardRequestJob requestJob) {
            assert (requestJob != null);
        }
    }

    private class StepConsiderDiscreteWorkloadRequestJobFeedback
    implements IDiscreteControlProcessorStep {
        private final CommunicationSession workloadCommunicationSession;
        private final boolean communicationErrorOccured;

        public StepConsiderDiscreteWorkloadRequestJobFeedback(CommunicationSession communicationSession, boolean communicationErrorOccured) {
            this.workloadCommunicationSession = communicationSession;
            this.communicationErrorOccured = communicationErrorOccured;
        }

        @Override
        public void executeStep() {
            if (this.workloadCommunicationSession == ControlAndUpdateEnquiryThread.this.getCommunicationSession() && this.communicationErrorOccured) {
                ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
            }
        }
    }

    class StepDisconnectRequestJob
    extends StepAbstractStandardRequestJob
    implements IDiscreteControlProcessorStep {
        StepDisconnectRequestJob() {
        }

        @Override
        public void executeStep() {
            if (ControlAndUpdateEnquiryThread.this.connectionState == ConnectionState.CONNECTIONOK) {
                try {
                    this.request = new EOClientRequest("User", "Logout", null);
                    this.response = StepDisconnectRequestJob.sendRequestAndParseResponse(ControlAndUpdateEnquiryThread.this.getCommunicationSession().getUrl(), this.request, ControlAndUpdateEnquiryThread.this.xmlDecoder, ControlAndUpdateEnquiryThread.this.messageFactory);
                }
                catch (IOException e) {
                    this.ioException = e;
                }
                catch (EXDecoderException e) {
                    this.exDecoderException = e;
                }
            } else {
                this.exNotConnected = new EXNotLoggedInOrConnectionBroken();
            }
            ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.DISCONNECTED);
            this.requestProcessingHasTerminated();
        }
    }

    private class StepFinalizeWorkloadRequestWithNotificationFetchRequestJob
    implements IDiscreteControlProcessorStep {
        private final StepAbstractStandardRequestJob requestJob;
        private final CommunicationSession workloadCommunicationSession;

        public StepFinalizeWorkloadRequestWithNotificationFetchRequestJob(StepAbstractStandardRequestJob requestJob, CommunicationSession workloadCommunicationSession) {
            this.requestJob = requestJob;
            this.workloadCommunicationSession = workloadCommunicationSession;
        }

        @Override
        public void executeStep() {
            if (this.workloadCommunicationSession == ControlAndUpdateEnquiryThread.this.getCommunicationSession()) {
                if (this.requestJob.exNotConnected != null || ControlAndUpdateEnquiryThread.this.connectionState != ConnectionState.CONNECTIONOK) {
                    if (this.requestJob.exNotConnected == null) {
                        this.requestJob.exNotConnected = new EXNotLoggedInOrConnectionBroken();
                    }
                } else if (this.requestJob.getRequest().getReqGroup().equals("User") && this.requestJob.getRequest().getReqSubID().equals("LoginPhase2")) {
                    if (this.requestJob == ControlAndUpdateEnquiryThread.this.pendingLoginPhase2Job) {
                        ((ControlAndUpdateEnquiryThread)ControlAndUpdateEnquiryThread.this).loginRequestInProgress.response = this.requestJob.response;
                        ((ControlAndUpdateEnquiryThread)ControlAndUpdateEnquiryThread.this).loginRequestInProgress.exNotConnected = this.requestJob.exNotConnected;
                        ((ControlAndUpdateEnquiryThread)ControlAndUpdateEnquiryThread.this).loginRequestInProgress.ioException = this.requestJob.ioException;
                        ((ControlAndUpdateEnquiryThread)ControlAndUpdateEnquiryThread.this).loginRequestInProgress.exDecoderException = this.requestJob.exDecoderException;
                        try {
                            this.requestJob.requestProcessingHasTerminated();
                            EOServerResponse response = this.requestJob.getServerResponse();
                            if (response != null && response.getResponseData() != null && "loginOk".equals(((EOLoginResponse)response.getResponseData()).getLoginStatus())) {
                                ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.CONNECTIONOK);
                            } else {
                                ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.DISCONNECTED);
                            }
                        }
                        catch (EXNotLoggedInOrConnectionBroken e) {
                            ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                        }
                        catch (IOException e) {
                            ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                        }
                        catch (EXDecoderException e) {
                            ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                        }
                        ControlAndUpdateEnquiryThread.this.loginRequestInProgress.requestProcessingHasTerminated();
                        ControlAndUpdateEnquiryThread.this.loginRequestInProgress = null;
                        ControlAndUpdateEnquiryThread.this.pendingLoginPhase2Job = null;
                    } else {
                        assert (false);
                        logger.error("LoginPhase2Job must NOT be initiated by anyone else than the ControlAndUpdateEnquiryThread.");
                        ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                    }
                } else if (this.requestJob.ioException != null || this.requestJob.exDecoderException != null) {
                    ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                } else if (this.requestJob.isExNeedReloginOccured()) {
                    ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.DISCONNECTED);
                } else {
                    if (this.requestJob.extractLatestNotificationPacketSerial() != null) {
                        long extractedLatestNotificationPacketSerial = this.requestJob.extractLatestNotificationPacketSerial();
                        if (extractedLatestNotificationPacketSerial > ControlAndUpdateEnquiryThread.this.latestNotificationPacketSerial) {
                            ControlAndUpdateEnquiryThread.this.latestNotificationPacketSerial = extractedLatestNotificationPacketSerial;
                        }
                    } else {
                        assert (false);
                        logger.error("WorkloadRequestWithNotificationFetchRequestJob terminated but its response did not contain the latestNotificationPacketSerial. This should not occur!");
                        ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                    }
                    if (this.requestJob.getRequest().getReqGroup().equals("Notification") && this.requestJob.getRequest().getReqSubID().equals("Fetch")) {
                        if (this.requestJob == ControlAndUpdateEnquiryThread.this.pendingNotificationFetchJob) {
                            ControlAndUpdateEnquiryThread.this.pendingNotificationFetchJob = null;
                            if (this.requestJob.response != null && this.requestJob.response.getResponseData() instanceof EONotificationPacket) {
                                EONotificationPacket notificationPacket = (EONotificationPacket)this.requestJob.response.getResponseData();
                                ControlAndUpdateEnquiryThread.this.previouslyFetchedNotificationPacketSerial = notificationPacket.getNotificationPacketSerial();
                                this.requestJob.requestProcessingHasTerminated();
                                ControlAndUpdateEnquiryThread.this.notificationConsumer.processNotificationEnquiryResponse(this.requestJob);
                            } else {
                                assert (false);
                                logger.error("Notification Fetch Request did not return a valid EONotificationPacket.");
                                ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                            }
                        } else {
                            assert (false);
                            logger.error("Notifications must NOT be fetched by anyone else than the ControlAndUpdateEnquiryThread.");
                            ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
                        }
                    }
                }
            } else if (this.requestJob.exNotConnected == null) {
                this.requestJob.exNotConnected = new EXNotLoggedInOrConnectionBroken();
            }
            this.requestJob.requestProcessingHasTerminated();
        }
    }

    private class StepLoginRequestJob
    extends StepAbstractStandardRequestJob
    implements IControlProcessorStepTriggeringNotificationFetchRequest {
        private final PSCApplicationIdentifier applicationIdentifier;
        private final PSCClientLicenseInfo clientLicenseSetting;
        private final PasswordAuthentication passwordAuthentication;
        private final PSCAuthenticator.RequestorInfo requestorInfo;
        private final String username;
        private final String password2;

        public StepLoginRequestJob(PSCApplicationIdentifier applicationIdentifier, PSCClientLicenseInfo clientLicenseSetting, PasswordAuthentication passwordAuthentication, PSCAuthenticator.RequestorInfo requestorInfo, String username, String password2) {
            this.applicationIdentifier = applicationIdentifier;
            this.clientLicenseSetting = clientLicenseSetting;
            this.passwordAuthentication = passwordAuthentication;
            this.requestorInfo = requestorInfo;
            this.username = username;
            this.password2 = password2;
        }

        @Override
        public void executeStep() {
            if (this.requestorInfo != null) {
                PSCAuthenticator.memorizePasswordAuthentication(this, this.requestorInfo, this.passwordAuthentication);
            }
            EOGenericMessage loginReq = new EOGenericMessage();
            loginReq.setMsgID("loginReq");
            loginReq.addAttribute("username", this.username);
            loginReq.addAttribute("password2", this.password2);
            String clientVersionForServer = this.applicationIdentifier.getClientVersionForServer();
            if (clientVersionForServer == null || clientVersionForServer.length() == 0) {
                clientVersionForServer = this.applicationIdentifier.getClientVersion();
            }
            loginReq.addAttribute("clientVersion", clientVersionForServer);
            loginReq.addAttribute("clientBuild", this.applicationIdentifier.getClientBuild());
            if (this.clientLicenseSetting != null && this.clientLicenseSetting.isClientRunByClientLicense()) {
                loginReq.addAttribute("licensedAppl", PasswordEncoder2.encodePassword(this.clientLicenseSetting.getRequiredServerApplicationID()));
            } else {
                loginReq.addAttribute("requestedLicensedAppl", this.clientLicenseSetting.getRequiredServerApplicationID());
            }
            this.request = new EOClientRequest("User", "Login", loginReq);
            try {
                this.response = StepLoginRequestJob.sendRequestAndParseResponse(ControlAndUpdateEnquiryThread.this.getCommunicationURL(), this.request, ControlAndUpdateEnquiryThread.this.xmlDecoder, ControlAndUpdateEnquiryThread.this.messageFactory);
                if (this.response.getException() != null && "ServerLoginException".equals(this.response.getException().getGroup()) && "NeedReloginException".equals(this.response.getException().getId())) {
                    logger.debug("Stale Server Session noticed during login to server (\"" + ControlAndUpdateEnquiryThread.this.getCommunicationURL().toString() + "\"). " + "Was Client-Host in Standby before? " + "Server-Message: " + (this.response.getException().getDescription() == null ? "<null>" : this.response.getException().getDescription()));
                    this.response = StepLoginRequestJob.sendRequestAndParseResponse(ControlAndUpdateEnquiryThread.this.getCommunicationURL(), this.request, ControlAndUpdateEnquiryThread.this.xmlDecoder, ControlAndUpdateEnquiryThread.this.messageFactory);
                }
                if (this.response != null && this.response.getResponseData() != null && "loginOk".equals(((EOLoginResponse)this.response.getResponseData()).getLoginStatus()) && CommunicationSession.isValidSegmentExchangeProtocolSessionID(((EOLoginResponse)this.response.getResponseData()).getSegmentExchangeProtocolSessionID())) {
                    EOLoginResponse loginResponse = (EOLoginResponse)this.response.getResponseData();
                    String sessionID = loginResponse.getSessionID();
                    String segmentExchangeProtocolSessionID = loginResponse.getSegmentExchangeProtocolSessionID();
                    ControlAndUpdateEnquiryThread.this.communicationSession = new CommunicationSession(segmentExchangeProtocolSessionID, new URL(String.valueOf(ControlAndUpdateEnquiryThread.this.serverURL.toExternalForm()) + ";jsessionid=" + sessionID), ControlAndUpdateEnquiryThread.this.serverName);
                    ControlAndUpdateEnquiryThread.this.latestNotificationPacketSerial = 0L;
                    ControlAndUpdateEnquiryThread.this.previouslyFetchedNotificationPacketSerial = 0L;
                    ControlAndUpdateEnquiryThread.this.pendingNotificationFetchJob = null;
                    ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.CONNECTIONOK);
                } else {
                    ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.DISCONNECTED);
                }
            }
            catch (IOException e) {
                this.ioException = e;
                ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
            }
            catch (EXDecoderException e) {
                this.exDecoderException = e;
                ControlAndUpdateEnquiryThread.this.updateConnectionStateAndRevokeAuthIfConnectionBroken(ConnectionState.ERROR);
            }
            if (ControlAndUpdateEnquiryThread.this.connectionState == ConnectionState.CONNECTIONOK) {
                this.request.setReqSubID("LoginPhase2");
                ControlAndUpdateEnquiryThread.this.loginRequestInProgress = this;
                ControlAndUpdateEnquiryThread.this.pendingLoginPhase2Job = ControlAndUpdateEnquiryThread.this.requestTransmissionAndUpdateEnquiryProcessor.chargeControlProcessorDelegatedRequestJob(this.request);
            } else {
                this.requestProcessingHasTerminated();
            }
        }
    }
}

