/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.java.tuples.Tuple;
import de.plans.psc.client.communication.transmissionprocessor.ProgressSummarySnapshot;
import de.plans.psc.client.communication.transmissionprocessor.RequestProgressStatus;
import de.plans.psc.shared.message.AbstractStreamDataBuffer;
import de.plans.psc.shared.message.FragmentedStreamDataBuffer;
import de.plans.psc.shared.message.RequestFamily;
import de.plans.psc.shared.message.RequestID;
import de.plans.psc.shared.message.StreamDataBuffer;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;

public class ClientRequestTable {
    private final String protocolSessionID;
    private RequestID highestKnownRequestID;
    private final LinkedList<RequestTableEntry> requestTableEntries;

    public ClientRequestTable(String protocolSessionID) {
        this.protocolSessionID = protocolSessionID;
        this.highestKnownRequestID = null;
        this.requestTableEntries = new LinkedList();
    }

    public synchronized RequestTableEntry getNextFreeRequestEntry(RequestFamily requestFamily, LinkedHashMap<String, String> requestExtraHeaderFields) throws IOException {
        this.highestKnownRequestID = this.highestKnownRequestID == null ? new RequestID(this.protocolSessionID, 0L) : new RequestID(this.protocolSessionID, this.highestKnownRequestID.getRequestnumber() + 1L);
        RequestTableEntry requestTableEntry = new RequestTableEntry(this.highestKnownRequestID, this, requestFamily, requestExtraHeaderFields);
        this.requestTableEntries.add(requestTableEntry);
        return requestTableEntry;
    }

    public synchronized Tuple<RequestID, Set<RequestID>> getActiveRequestInfo() {
        HashSet<RequestID> activeRequests = new HashSet<RequestID>();
        for (RequestTableEntry entry : this.requestTableEntries) {
            activeRequests.add(entry.requestID);
        }
        return new Tuple<RequestID, Set<RequestID>>(this.highestKnownRequestID, activeRequests);
    }

    public synchronized void requestCycleCompleted(RequestTableEntry requestEntry) {
        boolean wasContained = this.requestTableEntries.remove(requestEntry);
        assert (wasContained);
        requestEntry.dispose();
    }

    public static class RequestTableEntry {
        private final RequestID requestID;
        private final ClientRequestTable requestTable;
        private final RequestFamily requestFamily;
        private final LinkedHashMap<String, String> requestExtraHeaderFields;
        private final StreamDataBuffer request;
        private final FragmentedStreamDataBuffer response;
        private final RequestProgressStatus progressStatus;

        public RequestTableEntry(RequestID requestID, ClientRequestTable requestTable, RequestFamily requestFamily, LinkedHashMap<String, String> requestExtraHeaderFields) throws IOException {
            this.requestID = requestID;
            this.requestTable = requestTable;
            this.requestFamily = requestFamily;
            this.requestExtraHeaderFields = requestExtraHeaderFields;
            this.request = new StreamDataBuffer(AbstractStreamDataBuffer.DefaultTempFileManager.getSingleton());
            this.response = new FragmentedStreamDataBuffer(AbstractStreamDataBuffer.DefaultTempFileManager.getSingleton());
            this.progressStatus = new RequestProgressStatus();
        }

        public RequestID getRequestID() {
            return this.requestID;
        }

        public RequestFamily getRequestFamily() {
            return this.requestFamily;
        }

        public LinkedHashMap<String, String> getRequestExtraHeaderFields() {
            return this.requestExtraHeaderFields;
        }

        public StreamDataBuffer getRequest() {
            return this.request;
        }

        public FragmentedStreamDataBuffer getResponse() {
            return this.response;
        }

        public ClientRequestTable getRequestTable() {
            return this.requestTable;
        }

        public void dispose() {
            if (this.request != null) {
                this.request.dispose();
            }
            if (this.response != null) {
                this.response.dispose();
            }
        }

        public RequestProgressStatus getProgressStatus() {
            return this.progressStatus;
        }

        public void cancel() {
            this.progressStatus.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProgressSummarySnapshot getProgressSummarySnapshot() {
            ProgressSummarySnapshot progressSummarySnapshot = new ProgressSummarySnapshot();
            RequestProgressStatus requestProgressStatus = this.progressStatus;
            synchronized (requestProgressStatus) {
                this.request.getStatus(progressSummarySnapshot);
                this.response.getStatus(progressSummarySnapshot);
                this.progressStatus.getStatus(progressSummarySnapshot);
                return progressSummarySnapshot;
            }
        }
    }
}

