/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.httputil;

import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;

public class HTTPUtil {
    private static final ILogger LOGGER = Logger.getLogger(HTTPUtil.class);
    public static final int HTTP_OK = 200;
    private static final String HTTP_HEADER_REDIRECT_LOCATION = "Location";
    public static final String DEFAULT_CHARSET_FOR_MEDIATYPE_TEXT = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String SYSPROP_COCKPIT_HTTP_URL_CONNECTION_FOLLOW_REDIRECTS = "cockpit.HttpURLConnection.FollowRedirects";
    private static final String SYSPROP_LINE_SEPARATOR = "line.separator";
    public static final String LINE_SEPARATOR;

    static {
        String lineSeparator = null;
        try {
            lineSeparator = System.getProperty(SYSPROP_LINE_SEPARATOR);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to determine value of SystemProperty \"line.separator\".", e);
        }
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        LINE_SEPARATOR = lineSeparator;
    }

    private HTTPUtil() {
    }

    private void connectFollowRedirects(URL cockpitServerURL, String username, char[] password) {
    }

    private static boolean isAutomaticRedirectAdvisable(int responseCode) {
        switch (responseCode) {
            case 300: {
                return true;
            }
            case 301: {
                return true;
            }
            case 302: {
                return true;
            }
            case 303: {
                return true;
            }
            case 304: {
                return false;
            }
            case 305: {
                return false;
            }
            case 306: {
                return false;
            }
            case 307: {
                return true;
            }
        }
        return false;
    }

    private static URL constructRedirectURL(HttpURLConnection httpURLConnection) {
        URL locUrl;
        block6: {
            String loc = httpURLConnection.getHeaderField(HTTP_HEADER_REDIRECT_LOCATION);
            if (loc == null) {
                return null;
            }
            try {
                locUrl = new URL(loc);
                if (httpURLConnection.getURL().getProtocol().equalsIgnoreCase(locUrl.getProtocol())) break block6;
                return null;
            }
            catch (MalformedURLException mue) {
                try {
                    return new URL(httpURLConnection.getURL(), loc);
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Unable to construct Redirect target URL (original URL=\"" + httpURLConnection.getURL() + "\", Redirect Location=\"" + loc + "\").", e);
                    return null;
                }
            }
        }
        return locUrl;
    }

    public static ByteArrayOutputStream copyResponseStreamToByteArrayOutputStream(InputStream responseStream) {
        ByteArrayOutputStream responseContentBytes = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataCopyHelper.copyFile(responseStream, byteArrayOutputStream);
            responseContentBytes = byteArrayOutputStream;
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.debug("Unable to read server response stream.", e);
        }
        return responseContentBytes;
    }

    /*
     * Unable to fully structure code
     */
    public static String convertResponseContentToString(byte[] responseContentBytes, String contentType) {
        block9: {
            responseContentString = new StringBuilder();
            if (responseContentBytes == null) {
                responseContentString.append("[null content, contentType: " + contentType + "]");
            } else {
                charset = HTTPUtil.guessContentTypeCharset(contentType);
                try {
                    responseContentString.append(new String(responseContentBytes, charset));
                    break block9;
                }
                catch (Throwable e) {
                    responseContentString.append("<!-- ContentType: ");
                    responseContentString.append(contentType);
                    responseContentString.append("\n");
                    responseContentString.append("\n");
                    responseContentString.append("     guessedContentTypeCharset: ");
                    responseContentString.append(charset);
                    responseContentString.append("\n");
                    responseContentString.append("\n");
                    responseContentString.append("     The Following exception occured while Converting the Content Bytes to a String: ");
                    responseContentString.append("\n");
                    cause = e;
                    loggedCauses = new HashSet<E>();
                    ** while (cause != null && !loggedCauses.contains((Object)cause))
                }
lbl-1000:
                // 1 sources

                {
                    if (loggedCauses.size() == 0) {
                        responseContentString.append("     Caused By:\n");
                    }
                    responseContentString.append("          " + e.getLocalizedMessage() + "\n");
                    var10_11 = e.getStackTrace();
                    var9_10 = var10_11.length;
                    var8_9 = 0;
                    while (var8_9 < var9_10) {
                        stackTraceElement = var10_11[var8_9];
                        responseContentString.append("               " + stackTraceElement.toString() + "\n");
                        ++var8_9;
                    }
                    responseContentString.append("\n");
                    cause = cause.getCause();
                    continue;
                }
lbl53:
                // 1 sources

                responseContentString.append("-->\n");
                i = 0;
                while (i < responseContentBytes.length) {
                    if (i > 0) {
                        responseContentString.append(", ");
                    }
                    responseContentString.append(responseContentBytes[i]);
                    ++i;
                }
                responseContentString.append("\n");
            }
        }
        return responseContentString.toString();
    }

    private static String guessContentTypeCharset(String contentType) {
        String charset = null;
        if (contentType != null && contentType.trim().startsWith("text")) {
            String[] fragments = contentType.split("\\s*;\\s*");
            int i = 1;
            while (i < fragments.length) {
                String parameter = fragments[i];
                int equalSignIndex = parameter.indexOf(61);
                if (parameter.startsWith("charset") && equalSignIndex != -1) {
                    charset = parameter.substring(equalSignIndex + 1);
                    break;
                }
                ++i;
            }
        }
        if (charset == null || charset.trim().length() == 0) {
            charset = DEFAULT_CHARSET_FOR_MEDIATYPE_TEXT;
        }
        return charset;
    }

    private static boolean shouldCockpitClientFollowRedirects() {
        boolean followRedirects = false;
        try {
            followRedirects = Boolean.parseBoolean(System.getProperty(SYSPROP_COCKPIT_HTTP_URL_CONNECTION_FOLLOW_REDIRECTS, "false"));
        }
        catch (Throwable e) {
            LOGGER.debug("Unable to determine value of SystemProperty \"cockpit.HttpURLConnection.FollowRedirects\" (Using default value: false).", e);
        }
        return followRedirects;
    }
}

