/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client;

import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.NotificationBus;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EONotification;
import de.plans.psc.shared.serverexceptions.EXServerException;

public class PSCClientNotificationBus
extends NotificationBus {
    private PSCClientServiceFacade serviceFacade;
    private IFetchedNotificationsExhaustedListener fetchedNotificationsExhaustedListener = null;

    public void construct(PSCClientServiceFacade p_serviceFacade) {
        this.serviceFacade = p_serviceFacade;
    }

    public void subscribeFetchedNotificationsExhaustedListener(IFetchedNotificationsExhaustedListener listener) {
        assert (this.fetchedNotificationsExhaustedListener == null);
        this.fetchedNotificationsExhaustedListener = listener;
    }

    public void postFetchedNotificationsExhausted(String serverID) {
        if (this.fetchedNotificationsExhaustedListener != null) {
            this.fetchedNotificationsExhaustedListener.fetchedNotificationsExhausted(serverID);
        }
    }

    public void subscribeListenerOnServer(INotificationBusListener listener, String notificationtype, String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest req = this.subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(listener, notificationtype, serverID);
        this.serviceFacade.sendRequest(serverID, req);
    }

    public EOClientRequest subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(INotificationBusListener listener, String notificationtype, String serverID) {
        this.subscribeListener(listener, notificationtype, serverID);
        EONotification n = new EONotification(notificationtype, null);
        EOClientRequest req = new EOClientRequest("Notification", "Subscribe", n);
        return req;
    }

    public void unsubscribeListenerOnServer(INotificationBusListener listener, String notificationtype, String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.unsubscribeListener(listener, notificationtype, serverID);
        EONotification n = new EONotification(notificationtype, null);
        EOClientRequest req = new EOClientRequest("Notification", "Unsubscribe", n);
        this.serviceFacade.sendRequest(serverID, req);
    }

    public void postOnServer(String notificationType, String serverID, EncodableObjectBase param) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EONotification n = new EONotification(notificationType, param);
        EOClientRequest req = new EOClientRequest("Notification", "Post", n);
        this.serviceFacade.sendRequest(serverID, req);
    }

    public static interface IFetchedNotificationsExhaustedListener {
        public void fetchedNotificationsExhausted(String var1);
    }
}

