/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.primitiveTypes;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOLong
extends EOEncodableObjectWithRole {
    private static final ILogger logger = Logger.getLogger(EOLong.class);
    private static final String DEFAULT_ROLE = "value";
    public static final String XML_NAME = "frame.datatype.long";
    private Long longValue;

    public EOLong(Long longValue) {
        this(longValue, DEFAULT_ROLE);
    }

    public EOLong(Long longValue, String role) {
        super(XML_NAME);
        this.longValue = longValue;
        this.setRole(role);
    }

    public EOLong(long longValue, String role) {
        this(new Long(longValue), role);
    }

    public EOLong(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public Long getValue() {
        return this.longValue;
    }

    @Override
    protected boolean hasContent() {
        return true;
    }

    @Override
    protected void writeContentToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendContentToXML(writeContext, this.longValue);
    }

    @Override
    protected boolean setContentFromXML(String value) {
        try {
            this.longValue = new Long(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            logger.error("invalid format in xml file: \"" + value + "\"", e);
            this.longValue = new Long(0L);
        }
        return true;
    }
}

