/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.incrementalsearch;

import de.plans.lib.util.incrementalsearch.DeltaPacket;
import de.plans.lib.util.incrementalsearch.SearchStringNormalizer;
import de.plans.lib.util.incrementalsearch.SearchableObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Search<DT> {
    private String plainQueryString;
    private final String normalizedQueryString;
    private Object preprocessedQueryString;
    private final HashSet<SearchableObject<DT>> searchResult;
    private final List<DeltaPacket<DT>> unconsideredSearchInputDeltaPackets;

    public Search(String queryString, Object preprocessedQueryString) {
        this.plainQueryString = queryString;
        this.normalizedQueryString = SearchStringNormalizer.normalizeString(queryString);
        this.preprocessedQueryString = preprocessedQueryString;
        this.searchResult = new HashSet();
        this.unconsideredSearchInputDeltaPackets = new ArrayList<DeltaPacket<DT>>();
    }

    public String getPlainQueryString() {
        return this.plainQueryString;
    }

    public void setPlainQueryString(String p_plainQueryString) {
        assert (p_plainQueryString != null);
        assert (SearchStringNormalizer.normalizeString(p_plainQueryString).equals(this.normalizedQueryString));
        this.plainQueryString = p_plainQueryString;
    }

    public String getNormalizedQueryString() {
        return this.normalizedQueryString;
    }

    public void setPreprocessedQueryString(Object preprocessedQueryString) {
        this.preprocessedQueryString = preprocessedQueryString;
    }

    public Object getPreprocessedQueryString() {
        return this.preprocessedQueryString;
    }

    public Collection<SearchableObject<DT>> getSearchResult() {
        return this.searchResult;
    }

    public List<DeltaPacket<DT>> getUnconsideredSearchInputDeltaPackets() {
        return this.unconsideredSearchInputDeltaPackets;
    }

    public int pendingMatches() {
        int numberOfMatches = 0;
        for (DeltaPacket<DT> unconsideredDeltaPacket : this.unconsideredSearchInputDeltaPackets) {
            numberOfMatches += unconsideredDeltaPacket.getAdds() == null ? 0 : unconsideredDeltaPacket.getAdds().size();
            numberOfMatches += unconsideredDeltaPacket.getMods() == null ? 0 : unconsideredDeltaPacket.getMods().size();
        }
        return numberOfMatches;
    }
}

