/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.util.HTMLLogFormatter;
import de.plans.lib.util.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.parameter.EOParameterSet;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.MemoryHandler;

public class LoggingMgr
implements IEncodableObjectFactory {
    private static final Logger pscLogger = Logger.getLogger(LoggingMgr.class);
    private static LoggingMgr uniqueInstance = null;
    protected LoggingParameterSet parameterSet = new LoggingParameterSet();
    private java.util.logging.Logger logger;
    private MemoryHandler memoryHandler = null;
    private Handler fileHandler = null;
    private boolean enabled = false;

    public void construct() {
        this.initializeLogger();
    }

    public static LoggingMgr getLoggingMgr() {
        if (uniqueInstance == null) {
            uniqueInstance = new LoggingMgr();
        }
        return uniqueInstance;
    }

    public void registerParameterSets(XMLConfigParameterMgr parameterMgr) {
        parameterMgr.registerEncodableObjectFactory(this.parameterSet.getTag(), this);
        parameterMgr.addSubtreeRootElement(this.parameterSet);
    }

    @Override
    public EncodableObjectBase createEncodableObject(String elementName, XMLContext context) throws EXDecoderException {
        if (this.parameterSet.getTag().equals(elementName)) {
            return this.parameterSet;
        }
        return null;
    }

    private void initializeLogger() {
        this.enabled = this.parameterSet.isEnabled();
        if (this.enabled) {
            this.logger = java.util.logging.Logger.getLogger(this.parameterSet.getLogLocation());
            this.logger.setLevel(Level.ALL);
            LogManager.getLogManager().addLogger(this.logger);
            try {
                File parent;
                File f = new File(this.parameterSet.getLogFilePath());
                if (!f.exists() && (parent = f.getParentFile()) != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.fileHandler = new FileHandler(f.getAbsolutePath(), this.parameterSet.getMaxFileLength(), 1, false);
                this.fileHandler.setFormatter(new HTMLLogFormatter());
            }
            catch (IOException e) {
                throw new IllegalStateException("Corrupt path to LogFile!");
            }
            if (this.parameterSet.getLogToMemory()) {
                this.memoryHandler = new MemoryHandler(this.fileHandler, this.parameterSet.getMemoryBufferSize(), Level.WARNING);
                this.logger.addHandler(this.memoryHandler);
            } else {
                this.logger.addHandler(this.fileHandler);
            }
        }
    }

    public void warning(String msg) {
        if (this.enabled) {
            StackTraceElement ste = this.getStackTraceElementOfCaller();
            this.logger.logp(Level.WARNING, ste.getClassName(), ste.getMethodName(), msg);
        }
    }

    public void severe(String msg) {
        if (this.enabled) {
            StackTraceElement ste = this.getStackTraceElementOfCaller();
            this.logger.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName(), msg);
        }
    }

    public void info(String msg) {
        if (this.enabled) {
            StackTraceElement ste = this.getStackTraceElementOfCaller();
            this.logger.logp(Level.INFO, ste.getClassName(), ste.getMethodName(), msg);
        }
    }

    public void exception(String msg, Throwable t) {
        if (this.enabled) {
            StackTraceElement ste = this.getStackTraceElementOfCaller();
            this.logger.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName(), msg, t);
        }
    }

    private StackTraceElement getStackTraceElementOfCaller() {
        return new Throwable().getStackTrace()[2];
    }

    public String getLogLevel() {
        if (this.enabled) {
            return this.logger.getLevel().getName();
        }
        return "LOG_DISABLED";
    }

    public void setLogLevel(String level) {
        if (this.enabled) {
            Level newLevel = null;
            newLevel = Level.parse(level.toUpperCase());
            this.logger.setLevel(newLevel);
        }
    }

    public void setLogLevel(Level newLevel) {
        if (this.enabled) {
            this.logger.setLevel(newLevel);
        }
    }

    public void flushBuffer() {
        if (this.enabled) {
            if (this.memoryHandler != null) {
                this.memoryHandler.push();
            }
            this.fileHandler.flush();
        }
    }

    public boolean configurationIsLoadedFromFile() {
        return this.parameterSet.hasBeenReadFromXMLFile();
    }

    public String buildHtmlReport() {
        FileReader fileReader;
        String fileName = this.parameterSet.getLogFilePath();
        try {
            fileReader = new FileReader(fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find logfile " + fileName, e);
        }
        char[] buf = new char[2048];
        int charsRead = 0;
        CharArrayWriter writer = new CharArrayWriter();
        try {
            try {
                while ((charsRead = fileReader.read(buf)) > 0) {
                    writer.write(buf, 0, charsRead);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while reading from logFile", e);
            }
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
        }
        writer.close();
        return writer.toString();
    }

    public LoggingParameterSet getParameterSet() {
        return this.parameterSet;
    }

    public static class LoggingParameterSet
    extends EOParameterSet {
        public static String XML_NAME = "LogFile";
        private String logLocation = "Client";
        private boolean logToMemory = false;
        private int memoryBufferSize = 1000;
        private String logFilePath = "logfile.log";
        private int maxFileLength = 32768;
        private boolean enabled = false;
        private static final String ATTR_TAG_LOG_LOCATION = "logLocation";
        private static final String ATTR_TAG_LOG_TO_MEMORY = "logToMemory";
        private static final String ATTR_TAG_MEMORY_BUFFER_SIZE = "memoryBufferSize";
        private static final String ATTR_TAG_LOGFILE_PATH = "logFilePath";
        private static final String ATTR_TAG_MAX_FILE_LENTGH = "maxFileLength";
        private static final String ATTR_TAG_ENABLED = "enabled";
        private boolean isReadFromFile = false;

        public LoggingParameterSet(XMLContext xmlContext) {
            super(XML_NAME, xmlContext);
        }

        public LoggingParameterSet() {
            super(XML_NAME);
        }

        @Override
        protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
            this.appendAttrToXML(writeContext, ATTR_TAG_LOG_LOCATION, this.logLocation);
            this.appendAttrToXML(writeContext, ATTR_TAG_LOG_TO_MEMORY, this.logToMemory);
            if (this.logToMemory) {
                this.appendAttrToXML(writeContext, ATTR_TAG_MEMORY_BUFFER_SIZE, this.memoryBufferSize);
            }
            this.appendAttrToXML(writeContext, ATTR_TAG_ENABLED, this.enabled);
            this.appendAttrToXML(writeContext, ATTR_TAG_LOGFILE_PATH, this.logFilePath);
            this.appendAttrToXML(writeContext, ATTR_TAG_MAX_FILE_LENTGH, this.maxFileLength);
        }

        @Override
        protected boolean setAttributeFromXML(String name, String value) {
            boolean knownAttribute = true;
            this.isReadFromFile = true;
            if (name.equals(ATTR_TAG_LOG_LOCATION)) {
                this.logLocation = value;
            } else if (name.equals(ATTR_TAG_LOG_TO_MEMORY)) {
                this.logToMemory = Boolean.valueOf(value);
            } else if (name.equals(ATTR_TAG_ENABLED)) {
                this.enabled = Boolean.valueOf(value);
            } else if (name.equals(ATTR_TAG_MEMORY_BUFFER_SIZE)) {
                this.memoryBufferSize = Integer.parseInt(value);
            } else if (name.equals(ATTR_TAG_LOGFILE_PATH)) {
                this.logFilePath = value;
            } else if (name.equals(ATTR_TAG_MAX_FILE_LENTGH)) {
                this.maxFileLength = Integer.parseInt(value);
            } else {
                knownAttribute = false;
            }
            return knownAttribute;
        }

        @Override
        protected boolean hasChildren() {
            return false;
        }

        @Override
        protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        }

        @Override
        protected boolean addChildFromXML(EncodableObjectBase newChild) {
            return false;
        }

        public String getLogLocation() {
            return this.logLocation;
        }

        public boolean getLogToMemory() {
            return this.logToMemory;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getMemoryBufferSize() {
            return this.memoryBufferSize;
        }

        public String getLogFilePath() {
            return this.logFilePath;
        }

        public int getMaxFileLength() {
            return this.maxFileLength;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setLogLocation(String value) {
            this.logLocation = value;
        }

        public void setLogFilePath(String path) {
            this.logFilePath = path;
        }

        public void setLogToMemory(boolean logToMemory) {
            this.logToMemory = logToMemory;
        }

        public void setMaxFileLength(int length) {
            this.maxFileLength = length;
        }

        public void setMemoryBufferSize(int size) {
            this.memoryBufferSize = size;
        }

        public boolean hasBeenReadFromXMLFile() {
            return this.isReadFromFile;
        }

        @Override
        public void reset() {
        }
    }
}

