/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public class DebuggerInputStream
extends InputStream {
    private OutputStream outStream;
    private Writer writer;
    private final InputStream is;

    public DebuggerInputStream(InputStream is, OutputStream outStream) {
        this.outStream = outStream;
        this.is = is;
    }

    public DebuggerInputStream(InputStream is, Writer writer) {
        this.writer = writer;
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int i = this.is.read();
        if (this.outStream != null) {
            this.outStream.write(i);
        } else if (this.writer != null) {
            this.writer.write(i);
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = this.is.read(b);
        if (i > 0) {
            if (this.outStream != null) {
                this.outStream.write(b, 0, i);
            } else if (this.writer != null) {
                int j = 0;
                while (j < i) {
                    this.writer.write(b[j]);
                    ++j;
                }
            }
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.is.read(b, off, len);
        if (i > 0) {
            if (this.outStream != null) {
                this.outStream.write(b, off, i);
            } else if (this.writer != null) {
                int j = off;
                while (j < i + off) {
                    this.writer.write(b[j]);
                    ++j;
                }
            }
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        if (this.outStream != null) {
            this.outStream.close();
        } else if (this.writer != null) {
            this.writer.close();
        }
        this.is.close();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public void mark(int readLimit) {
        this.is.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }
}

