/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.psc.eclipse.client.update.updateurl;

import com.arcway.lib.eclipse.EclipseProductRetriever;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.java.date.RFC1123DateFormatter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUpdateFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PSCClientUpdateURLConnection
extends URLConnection {
    private static final ILogger logger = Logger.getLogger(PSCClientUpdateURLConnection.class);
    private static String defaultServerID = null;
    private static boolean alreadyTriedToWaitUntilServerConnectionIsEstablished = false;
    private static final long MaxWaitTimeUntilServerConnectionIsEstablished = 60000L;
    private static final long ServerConnectionIsEstablishedPollInterval = 100L;
    private LinkedHashMap<String, List<String>> headerFields = new LinkedHashMap();
    private File localFileCopy = null;
    private Exception couldNotCreateLocalCopyReason = null;

    public static URL createPSCClientUpdateURLForPSCServer(ServerConnection serverConnection) throws MalformedURLException {
        String serverURL = serverConnection.getURL();
        int colonpos = serverURL.indexOf(":");
        if (colonpos == -1) {
            throw new MalformedURLException();
        }
        String strippedURL = serverURL.substring(colonpos);
        StringBuffer updateUrlString = new StringBuffer();
        updateUrlString.append("update");
        updateUrlString.append(strippedURL);
        if (!strippedURL.endsWith("/")) {
            updateUrlString.append("/");
        }
        return new URL(updateUrlString.toString());
    }

    public PSCClientUpdateURLConnection(URL url) {
        super(url);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return false;
    }

    @Override
    public boolean getDoInput() {
        return true;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public String getHeaderField(int n) {
        Iterator<List<String>> it = this.getHeaderFields().values().iterator();
        int i = n;
        while (i > 0 && it.hasNext()) {
            it.next();
        }
        List<String> fldValues = null;
        if (it.hasNext()) {
            fldValues = it.next();
        }
        if (fldValues instanceof List && fldValues.size() > 0) {
            return fldValues.get(fldValues.size() - 1);
        }
        return null;
    }

    @Override
    public String getHeaderField(String name) {
        List<String> fldValues = this.getHeaderFields().get(name);
        if (fldValues != null && fldValues.size() > 0) {
            return fldValues.get(fldValues.size() - 1);
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        Iterator<String> it = this.getHeaderFields().keySet().iterator();
        int i = n;
        while (i > 0 && it.hasNext()) {
            it.next();
        }
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.connect_internal();
        return this.headerFields;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return new FileInputStream(this.localFileCopy);
    }

    @Override
    public void connect() throws IOException {
        this.connect_internal();
        if (this.localFileCopy == null) {
            throw new IOException("Unable to access update site location: " + this.getURL() + " using \"" + "update" + "\" protocol " + this.couldNotCreateLocalCopyReason.getLocalizedMessage());
        }
    }

    private ParsedURL getParsedURL() throws Exception {
        String relativeURLString = null;
        String serverID = null;
        String updateURLString = this.getURL().toExternalForm();
        for (ServerConnection sc : PSCClientUpdateURLConnection.getServiceFacade().getServerConnections()) {
            URL scUpdateURL;
            try {
                scUpdateURL = PSCClientUpdateURLConnection.createPSCClientUpdateURLForPSCServer(sc);
            }
            catch (MalformedURLException e) {
                logger.error("unhandled catch block", e);
                continue;
            }
            String scUpdateURLString = scUpdateURL.toExternalForm();
            if (scUpdateURLString.endsWith("/")) {
                scUpdateURLString = scUpdateURLString.substring(0, scUpdateURLString.length() - 1);
            }
            if (!updateURLString.startsWith(scUpdateURLString) || updateURLString.length() != scUpdateURLString.length() && (updateURLString.length() <= scUpdateURLString.length() || !updateURLString.substring(scUpdateURLString.length()).startsWith("/"))) continue;
            serverID = sc.getServerID();
            if (updateURLString.length() == scUpdateURLString.length()) {
                relativeURLString = "";
                break;
            }
            relativeURLString = updateURLString.substring(scUpdateURLString.length() + 1);
            break;
        }
        if (serverID == null && updateURLString.startsWith("update://localhost/updates") && (relativeURLString = updateURLString.substring("update://localhost/updates".length())).startsWith("/")) {
            relativeURLString = relativeURLString.substring(1);
        }
        if (relativeURLString == null) {
            throw new Exception("Unkown Server. Unable to connect to this server.");
        }
        return new ParsedURL(serverID, relativeURLString);
    }

    private void connect_internal() {
        block11: {
            if (!this.connected) {
                this.connected = true;
                try {
                    ParsedURL parsedURL = this.getParsedURL();
                    String updateServerID = parsedURL.serverID != null ? parsedURL.serverID : PSCClientUpdateURLConnection.getDefaultUpdateServerID();
                    EOUpdateFileInfo updateSiteFileInfo = null;
                    String[] stringArray = new String[]{String.valueOf(EclipseProductRetriever.getEclipseProduct()) + "/" + parsedURL.relativeURLString, parsedURL.relativeURLString};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String relativeURLStringCandidate = stringArray[n2];
                        EOList<EOString> updateSiteFilenames = new EOList<EOString>();
                        updateSiteFilenames.add(new EOString(relativeURLStringCandidate));
                        EOClientRequest req = new EOClientRequest("update.client.eclipse", "update.GetUpdateSiteDownloadTransferIDs", updateSiteFilenames);
                        EOServerResponse res = PSCClientUpdateURLConnection.getServiceFacade().sendRequest(updateServerID, req);
                        EOList updateSiteFileInfoIDs = (EOList)res.getResponseData();
                        updateSiteFileInfo = (EOUpdateFileInfo)updateSiteFileInfoIDs.get(0);
                        if (updateSiteFileInfo.isAvailableOnUpdateSite()) break;
                        ++n2;
                    }
                    assert (updateSiteFileInfo != null);
                    if (!updateSiteFileInfo.isAvailableOnUpdateSite()) {
                        throw new Exception("File not available on Update Site.");
                    }
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.add(updateSiteFileInfo.getTransferID());
                    this.localFileCopy = SessionTempDirectoryManager.createSessionTempFile((String)"update", null);
                    this.localFileCopy.deleteOnExit();
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(this.localFileCopy);
                    PSCClientUpdateURLConnection.getServiceFacade().downloadFiles(updateServerID, ids, files);
                    this.headerFields = new LinkedHashMap();
                    if (updateSiteFileInfo.getLastModified() != null) {
                        Date date = new Date(updateSiteFileInfo.getLastModified());
                        String dateString = RFC1123DateFormatter.getRFC1123String(date);
                        ArrayList<String> values = new ArrayList<String>();
                        values.add(dateString);
                        this.headerFields.put("last-modified", values);
                    }
                    int intContentLength = -1;
                    long size = this.localFileCopy.length();
                    if (size <= Integer.MAX_VALUE) {
                        intContentLength = (int)size;
                    }
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(Integer.toString(intContentLength));
                    this.headerFields.put("content-length", values);
                }
                catch (Throwable th1) {
                    Throwable th = th1 instanceof ExPrematureEndOfTransfer && th1.getCause() != null ? th1.getCause() : th1;
                    if (!(th instanceof RuntimeException) && this.localFileCopy != null) {
                        this.localFileCopy.delete();
                        this.localFileCopy = null;
                    }
                    if (th instanceof Exception) {
                        this.couldNotCreateLocalCopyReason = (Exception)th;
                    } else {
                        this.couldNotCreateLocalCopyReason = new IOException();
                        this.couldNotCreateLocalCopyReason.initCause(th);
                    }
                    if (!(th instanceof RuntimeException)) break block11;
                    throw (RuntimeException)th;
                }
            }
        }
    }

    private static String getDefaultUpdateServerID() throws Exception {
        if (defaultServerID == null) {
            List<ServerConnection> connectedServers = PSCClientUpdateURLConnection.getServiceFacade().getOpenServerConnections();
            List<ServerConnection> servers = PSCClientUpdateURLConnection.getServiceFacade().getServerConnections();
            if (connectedServers.size() == 1) {
                defaultServerID = connectedServers.get(0).getServerID();
            } else if (servers.size() == 1 && !alreadyTriedToWaitUntilServerConnectionIsEstablished) {
                alreadyTriedToWaitUntilServerConnectionIsEstablished = true;
                ServerConnection sc = (ServerConnection)servers.iterator().next();
                long dueDate = System.currentTimeMillis() + 60000L;
                while (!sc.isConnected() && System.currentTimeMillis() < dueDate) {
                    Thread.sleep(100L);
                }
                if (sc.isConnected()) {
                    defaultServerID = sc.getServerID();
                }
            } else {
                if (connectedServers.size() > 1) {
                    throw new Exception("Aborted update request because update source is ambiguous (Client is currently connected to several Cockpit servers.");
                }
                if (servers.size() == 0) {
                    throw new Exception("No Cockpit Server configured.");
                }
            }
            if (defaultServerID == null) {
                throw new Exception("Not connected to any Cockpit server.");
            }
        }
        return defaultServerID;
    }

    private static PSCClientServiceFacade getServiceFacade() {
        return EclipsePlugin.getDefault().getClientServiceFacade();
    }

    private class ParsedURL {
        public final String serverID;
        public final String relativeURLString;

        public ParsedURL(String p_serverID, String p_relativeURLString) {
            this.serverID = p_serverID;
            this.relativeURLString = p_relativeURLString;
        }
    }
}

