/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.operating;

import com.arcway.lib.operating.IExceptionFactory;

public class SafeRunner {
    public static <T, E extends Throwable> T safeExecute(Runnable<T> runnable, IExceptionFactory<E> exceptionFactory) throws E {
        try {
            return runnable.run();
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable th) {
            throw exceptionFactory.createException(th);
        }
    }

    public static <E extends Throwable> void safeVoidExecute(VoidRunnable runnable, IExceptionFactory<E> exceptionFactory) throws E {
        try {
            runnable.run();
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable th) {
            throw exceptionFactory.createException(th);
        }
    }

    public static interface Runnable<T> {
        public T run() throws Throwable;
    }

    public static interface VoidRunnable {
        public void run() throws Throwable;
    }
}

