/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.operating;

import com.arcway.lib.java.Assert;
import com.arcway.lib.operating.CancelMode;
import com.arcway.lib.operating.EXProcessingCanceled;
import com.arcway.lib.operating.EXProcessingException;
import com.arcway.lib.operating.EXRevertProcessingFailed;
import com.arcway.lib.operating.IProcessMonitor;
import com.arcway.lib.operating.IProcessStepLabel;
import com.arcway.lib.operating.IProcessorContext;
import com.arcway.lib.operating.IProcessorLabelProvider;
import com.arcway.lib.operating.Monitor;

public abstract class AbstractProcessor {
    private final IProcessorLabelProvider processorLabelProvider;
    private final CancelMode cancelMode;

    protected AbstractProcessor(IProcessorLabelProvider processorLabelProvider, CancelMode cancelMode) {
        Assert.checkArgumentBeeingNotNull(processorLabelProvider);
        Assert.checkArgumentBeeingNotNull(cancelMode);
        this.processorLabelProvider = processorLabelProvider;
        this.cancelMode = cancelMode;
    }

    protected final Object process(QuantificationMode quantificationMode, IProcessorContext processorContext, IProcessMonitor processMonitor) throws EXProcessingException, EXProcessingCanceled, EXRevertProcessingFailed {
        Object result = null;
        Monitor processingMonitor = Monitor.createProcessingMonitor(this, this.cancelMode, quantificationMode, processMonitor);
        processingMonitor.initTask();
        int workTotal = this.calculateTotalWork(processorContext);
        processingMonitor.beginTask(workTotal);
        boolean succeeded = false;
        boolean cancel = false;
        while (!succeeded && !cancel) {
            cancel = processingMonitor.isTaskToCancel();
            if (cancel) continue;
            try {
                try {
                    result = this.excecute(processorContext, processingMonitor);
                    succeeded = true;
                }
                catch (EXProcessingCanceled e) {
                    cancel = true;
                }
            }
            catch (EXProcessingException processingException) {
                if (this.repair(processorContext, processingException)) continue;
                throw processingException;
            }
        }
        if (cancel) {
            processingMonitor.reportCancelingInProgress();
            this.revertProcess(processorContext);
        }
        processingMonitor.endTask();
        if (cancel) {
            throw new EXProcessingCanceled();
        }
        return result;
    }

    protected abstract int calculateTotalWork(IProcessorContext var1) throws EXProcessingException;

    protected abstract Object excecute(IProcessorContext var1, IMonitor var2) throws EXProcessingException, EXProcessingCanceled;

    protected abstract boolean repair(IProcessorContext var1, EXProcessingException var2);

    protected abstract void revertProcess(IProcessorContext var1) throws EXRevertProcessingFailed;

    protected final IProcessorLabelProvider getProcessorLabelProvider() {
        return this.processorLabelProvider;
    }

    protected final CancelMode getCancelMode() {
        return this.cancelMode;
    }

    protected static interface IMonitor {
    }

    protected static interface IMonitorQuantified
    extends IMonitor {
        public void reportQuantifiedProgress(int var1, IProcessStepLabel var2);

        public void reportQuantifiedProgress(int var1);
    }

    protected static interface IMonitorQuantifiedWithCancel
    extends IMonitorQuantified {
        public void checkForCancel() throws EXProcessingCanceled;
    }

    protected static interface IMonitorUnquantified
    extends IMonitor {
        public void reportUnquantifiedProgress(IProcessStepLabel var1);
    }

    protected static interface IMonitorUnquantifiedWithCancel
    extends IMonitorUnquantified {
        public void checkForCancel() throws EXProcessingCanceled;
    }

    protected static class QuantificationMode {
        public static final QuantificationMode QUANTIFIED_PROCESS = new QuantificationMode("QUANTIFIED_PROCESS");
        public static final QuantificationMode UNQUANTIFIED_PROCESS = new QuantificationMode("UNQUANTIFIED_PROCESS");
        private final String label;

        private QuantificationMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

