/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.network;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class HostNameRetriever {
    private static final ILogger logger = Logger.getLogger(HostNameRetriever.class);
    private static String cachedHostname = null;
    private static String retrieveFailureMsg = null;
    private static Throwable retrieveFailureCause = null;

    private static void detectHostname() {
        block38: {
            Process p = null;
            BufferedReader in = null;
            try {
                try {
                    String osname = System.getProperty("os.name");
                    if (osname.startsWith("Windows")) {
                        p = Runtime.getRuntime().exec(new String[]{"hostname"}, null);
                        in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        try {
                            String l = null;
                            while ((l = in.readLine()) != null) {
                                cachedHostname = l = l.trim();
                            }
                            break block38;
                        }
                        finally {
                            in.close();
                        }
                    }
                    p = Runtime.getRuntime().exec(new String[]{"hostname"}, null);
                    in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    try {
                        String l = null;
                        while ((l = in.readLine()) != null) {
                            cachedHostname = l = l.trim();
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (Error e) {
                    retrieveFailureMsg = "HostNameRetriever: Error while retrieving hostname.";
                    retrieveFailureCause = e;
                    throw e;
                }
                catch (Throwable th) {
                    retrieveFailureMsg = "HostNameRetriever: Unable to retrieve hostname.";
                    retrieveFailureCause = th;
                    logger.error(retrieveFailureMsg, retrieveFailureCause);
                    if (retrieveFailureCause instanceof Error) break block38;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th2) {
                        logger.error("HostNameRetriever: Problem while retrieving the hostname. Unable to close input Stream. - " + th2.getClass().getName(), th2);
                    }
                    try {
                        if (p != null) {
                            p.destroy();
                        }
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th3) {
                        logger.error("HostNameRetriever: Problem while retrieving the hostname. Unable to destroy child process. - " + th3.getClass().getName(), th3);
                    }
                }
            }
            finally {
                if (!(retrieveFailureCause instanceof Error)) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        logger.error("HostNameRetriever: Problem while retrieving the hostname. Unable to close input Stream. - " + th.getClass().getName(), th);
                    }
                    try {
                        if (p != null) {
                            p.destroy();
                        }
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable th) {
                        logger.error("HostNameRetriever: Problem while retrieving the hostname. Unable to destroy child process. - " + th.getClass().getName(), th);
                    }
                }
            }
        }
    }

    public static synchronized String getHostname() throws UnableToRetrieveHostnameException {
        if (cachedHostname == null && retrieveFailureMsg == null && retrieveFailureCause == null) {
            HostNameRetriever.detectHostname();
        }
        if (retrieveFailureMsg != null || retrieveFailureCause != null || cachedHostname == null) {
            if (retrieveFailureMsg == null) {
                retrieveFailureMsg = "Unable to retrieve Hostname.";
            }
            throw new UnableToRetrieveHostnameException(retrieveFailureMsg, retrieveFailureCause);
        }
        return cachedHostname;
    }

    public static class UnableToRetrieveHostnameException
    extends Exception {
        public UnableToRetrieveHostnameException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

