/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.locale;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class LocalisationUtils {
    public static Double parseDoubleLocalized(String stringToParse, Locale locale) throws ParseException {
        Number number = LocalisationUtils.parseNumberLocalized(stringToParse, locale, true, -1.7976931348623157E308, Double.MAX_VALUE);
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }

    public static Integer parseInteger32Localized(String stringToParse, Locale locale) throws ParseException {
        Number number = LocalisationUtils.parseNumberLocalized(stringToParse, locale, false, -2.147483648E9, 2.147483647E9);
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public static Long parseInteger64Localized(String stringToParse, Locale locale) throws ParseException {
        Number number = LocalisationUtils.parseNumberLocalized(stringToParse, locale, false, -9.223372036854776E18, 9.223372036854776E18);
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    public static char getCommaCharacter(Locale locale) {
        DecimalFormatSymbols symbols = ((DecimalFormat)NumberFormat.getNumberInstance(locale)).getDecimalFormatSymbols();
        return symbols.getDecimalSeparator();
    }

    public static char getMinusCharacter(Locale locale) {
        DecimalFormatSymbols symbols = ((DecimalFormat)NumberFormat.getNumberInstance(locale)).getDecimalFormatSymbols();
        return symbols.getMinusSign();
    }

    private static Number parseNumberLocalized(String stringToParse, Locale locale, boolean floatingAllowed, double min, double max) throws ParseException {
        char comma = LocalisationUtils.getCommaCharacter(locale);
        char minus = LocalisationUtils.getMinusCharacter(locale);
        if (stringToParse.length() > 0) {
            Number number;
            boolean commaFound = false;
            int index = 0;
            while (index < stringToParse.length()) {
                char character = stringToParse.charAt(index);
                if ("0123456789".indexOf(character) == -1) {
                    if (character == minus && index == 0) {
                        if (min >= 0.0) {
                            throw new ParseException(stringToParse, index);
                        }
                    } else if (character == comma) {
                        if (!floatingAllowed || commaFound) {
                            throw new ParseException(stringToParse, index);
                        }
                        commaFound = true;
                    } else {
                        throw new ParseException(stringToParse, index);
                    }
                }
                ++index;
            }
            try {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                number = decimalFormat.parse(stringToParse);
            }
            catch (NumberFormatException nfE) {
                throw new ParseException(stringToParse, -1);
            }
            if (floatingAllowed ? number.doubleValue() < min || number.doubleValue() > max : (double)number.longValue() < min || (double)number.longValue() > max) {
                throw new ParseException(stringToParse, -1);
            }
            return number;
        }
        return null;
    }

    public static String roundLocalized(Double value, int fractionDigits, boolean trim, boolean grouping, Locale locale) {
        if (value != null) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
            numberFormat.setMaximumFractionDigits(fractionDigits);
            if (!trim) {
                numberFormat.setMinimumFractionDigits(fractionDigits);
            }
            numberFormat.setGroupingUsed(grouping);
            return numberFormat.format(value);
        }
        return "";
    }

    public static String localizeDate(Date date, int style, Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(style, locale);
        String localizedDate = dateFormat.format(date);
        return localizedDate;
    }
}

