/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.io;

import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.io.JvmExternalResourceInteractionExceptionFactory;
import com.arcway.lib.operating.SafeRunner;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FileHelper {
    public static final char EXTENSION_SEPARATOR = '.';
    private static final String VALID_CHARS_IN_PURE_FILENAME = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.-";

    public static File addExtensionIfMissing(File file, String extension) {
        String existingExtension = FileHelper.getFileExtension(file);
        File fileWithExtension = existingExtension.length() == 0 ? new File(String.valueOf(file.getAbsolutePath()) + '.' + extension) : file;
        return fileWithExtension;
    }

    public static InputStream fileToInputStream(File file) throws JvmExternalResourceInteractionException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new JvmExternalResourceInteractionException(e);
        }
        catch (SecurityException e) {
            throw new JvmExternalResourceInteractionException(e);
        }
        return inputStream;
    }

    public static OutputStream fileToOutputStream(File file) throws JvmExternalResourceInteractionException {
        FileOutputStream outputStream;
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new JvmExternalResourceInteractionException(e);
        }
        catch (SecurityException e) {
            throw new JvmExternalResourceInteractionException(e);
        }
        return outputStream;
    }

    public static InputStream urlToInputStream(URL url) throws JvmExternalResourceInteractionException {
        InputStream inputStream;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException(e);
        }
        return inputStream;
    }

    public static void closeInputStream(InputStream inputStream) throws JvmExternalResourceInteractionException {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException(e);
        }
    }

    public static void moveFile(final File source, final File destination) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while moving file {0} to new destination {1} ", source.getPath(), destination.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Exception {
                boolean success;
                if (!source.exists()) {
                    throw exceptionFactory.createException(MessageFormat.format("Can not move file {0} to new destination {1} because it does not exist.", source.getAbsolutePath(), destination.getAbsolutePath()));
                }
                if (destination.exists() && !(success = destination.delete())) {
                    throw exceptionFactory.createException(MessageFormat.format("Can not move file {0} to new destination {1} because the destination file already exists and can not be deleted.", source.getAbsolutePath(), destination.getAbsolutePath()));
                }
                boolean renameSuccess = source.renameTo(destination);
                if (!renameSuccess) {
                    try {
                        DataCopyHelper.copyFile(source, destination);
                    }
                    catch (JvmExternalResourceInteractionException cause) {
                        throw exceptionFactory.createException(MessageFormat.format("Error while moving file by copying (sourcefile={0}, destination={1}). The source file could not be copied correctly.", source.getAbsolutePath(), destination.getAbsolutePath()), cause);
                    }
                    boolean deleteSuccess = source.delete();
                    if (!deleteSuccess) {
                        throw exceptionFactory.createException(MessageFormat.format("Error while moving file by copying (sourcefile={0}, destination={1}). The source file could not be deleted after copying it and is left over.", source.getAbsolutePath(), destination.getAbsolutePath()));
                    }
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void deleteFileOrDirectory(final File fileOrDirectory) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while trying to delete File/Directory {0}", fileOrDirectory.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Exception {
                if (fileOrDirectory.exists()) {
                    boolean success;
                    if (fileOrDirectory.isDirectory()) {
                        FileHelper.deleteContentOfDirectory(fileOrDirectory);
                    }
                    if (!(success = fileOrDirectory.delete()) && fileOrDirectory.exists()) {
                        throw exceptionFactory.createException(MessageFormat.format("Deleting the file (or directory) {0} was not successful.", fileOrDirectory.getPath()));
                    }
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void deleteExistingFileOrDirectory(final File fileOrDirectory) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while trying to delete File/Directory {0}", fileOrDirectory.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Exception {
                boolean success;
                if (fileOrDirectory.isDirectory()) {
                    FileHelper.deleteContentOfDirectory(fileOrDirectory);
                }
                if (!(success = fileOrDirectory.delete())) {
                    throw exceptionFactory.createException(MessageFormat.format("Deleting the file (or directory) {0} was not successful (Maybe it does/did not exist).", fileOrDirectory.getPath()));
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static void deleteContentOfDirectory(final File directory) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while trying to delete content of the directory {0}", directory.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Exception {
                if (directory.isDirectory()) {
                    File[] children;
                    File[] fileArray = children = directory.listFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        FileHelper.deleteExistingFileOrDirectory(child);
                        ++n2;
                    }
                } else {
                    throw exceptionFactory.createException(MessageFormat.format("Can not delete content of the directory {0} because it either does not exist or is not a directory.", directory.getAbsolutePath()));
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }

    public static Collection<File> ensureDirectoryExistance(final File directory) throws JvmExternalResourceInteractionException {
        if (directory == null) {
            return Collections.emptyList();
        }
        final String defaultmessage = MessageFormat.format("Error while checking existance/creating directory {0}.", directory.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<Collection<File>> runnable = new SafeRunner.Runnable<Collection<File>>(){

            @Override
            public Collection<File> run() throws Exception {
                boolean success;
                Collection<File> createdDirectories = null;
                File parent = directory.getParentFile();
                if (parent != null && !parent.exists()) {
                    createdDirectories = FileHelper.ensureDirectoryExistance(parent);
                }
                if (!directory.exists() && (success = directory.mkdir())) {
                    if (createdDirectories == null) {
                        createdDirectories = Collections.singletonList(directory);
                    } else {
                        createdDirectories = new ArrayList<File>(createdDirectories);
                        createdDirectories.add(directory);
                    }
                }
                if (!directory.exists()) {
                    throw exceptionFactory.createException(String.valueOf(defaultmessage) + " Reason: mkdir() failed.");
                }
                if (!directory.isDirectory()) {
                    throw exceptionFactory.createException(String.valueOf(defaultmessage) + " Reason: a file with the same name already exists which is not a directory.");
                }
                return createdDirectories != null ? createdDirectories : Collections.emptyList();
            }
        };
        return SafeRunner.safeExecute(runnable, exceptionFactory);
    }

    public static void copyDirectoryContent(File srcDirectory, File trgtDirectory) throws JvmExternalResourceInteractionException {
        FileHelper.copyDirectoryContent(srcDirectory, trgtDirectory, IFileValidator.ALL_ACCEPTING_FILE_VALIDATOR);
    }

    public static void copyDirectoryContent(File srcDirectory, File trgtDirectory, final Collection<String> exclusions) throws JvmExternalResourceInteractionException {
        FileHelper.copyDirectoryContent(srcDirectory, trgtDirectory, new IFileValidator(){

            @Override
            public boolean isValid(File file) {
                for (String exclusion : exclusions) {
                    if (!file.getName().matches(exclusion)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static Collection<File> copyDirectoryContent(final File srcDirectory, final File trgtDirectory, final IFileValidator fileValidator) throws JvmExternalResourceInteractionException {
        final String defaultmessage = MessageFormat.format("Error while trying to copy content of source directory {0} to destination directory {1} .", srcDirectory.getPath(), trgtDirectory.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<Collection<File>> runnable = new SafeRunner.Runnable<Collection<File>>(){

            @Override
            public Collection<File> run() throws Exception {
                File[] children;
                if (!srcDirectory.isDirectory()) {
                    throw exceptionFactory.createException(String.valueOf(defaultmessage) + " The source directory does not exist or is not a directory.");
                }
                if (!trgtDirectory.isDirectory()) {
                    throw exceptionFactory.createException(String.valueOf(defaultmessage) + " The destination directory does not exist or is not a directory.");
                }
                ArrayList<File> createdOrReplacedFilesAndDirectories = new ArrayList<File>();
                File[] fileArray = children = srcDirectory.listFiles();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    if (fileValidator.isValid(child)) {
                        File copy = new File(trgtDirectory, child.getName());
                        if (child.isFile()) {
                            DataCopyHelper.copyFile(child, copy);
                            createdOrReplacedFilesAndDirectories.add(copy);
                        } else if (child.isDirectory()) {
                            createdOrReplacedFilesAndDirectories.addAll(FileHelper.ensureDirectoryExistance(copy));
                            createdOrReplacedFilesAndDirectories.addAll(FileHelper.copyDirectoryContent(child, copy, fileValidator));
                        }
                    }
                    ++n2;
                }
                return createdOrReplacedFilesAndDirectories;
            }
        };
        return SafeRunner.safeExecute(runnable, exceptionFactory);
    }

    public static String getFileExtension(String fileName) {
        return FileHelper.getFileExtension(new File(fileName));
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int dotPosition = fileName.lastIndexOf(46);
        String extension = dotPosition == -1 ? "" : fileName.substring(dotPosition + 1);
        return extension;
    }

    public static boolean doesDirectoryContainEssentialFiles(File directory, boolean ignoreDirectoryEntries, boolean ignoreAuxiliaryFiles) {
        File[] files;
        assert (directory.isDirectory());
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (!ignoreDirectoryEntries || FileHelper.doesDirectoryContainEssentialFiles(file, ignoreDirectoryEntries, ignoreAuxiliaryFiles)) {
                    return true;
                }
            } else if (ignoreAuxiliaryFiles) {
                String filename = file.getName();
                if (!(".DS_Store".equalsIgnoreCase(filename) || filename.startsWith("._") || "Thumbs.db".equalsIgnoreCase(filename))) {
                    return true;
                }
            } else {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean compareFiles(final File file1, final File file2, final boolean includeFileNames) throws JvmExternalResourceInteractionException {
        final String defaultmessage = MessageFormat.format("Error while trying to compare the two files {0} and {1} .", file1.getPath(), file2.getPath());
        final JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<Boolean> runnable = new SafeRunner.Runnable<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                if (!file1.exists() || !file1.isFile()) {
                    throw exceptionFactory.createException(String.valueOf(defaultmessage) + " File 1 does not exist or is not a file.");
                }
                if (!file2.exists() || !file2.isFile()) {
                    throw exceptionFactory.createException(String.valueOf(defaultmessage) + " File 2 does not exist or is not a file.");
                }
                if (includeFileNames && !file1.getName().equals(file2.getName())) {
                    return Boolean.FALSE;
                }
                if (file1.length() != file2.length()) {
                    return Boolean.FALSE;
                }
                boolean differenceFound = false;
                FileInputStream file1Stream = new FileInputStream(file1);
                FileInputStream file2Stream = new FileInputStream(file2);
                while (file1Stream.available() > 0 && file1Stream.available() > 0 && !differenceFound) {
                    int file2NextByte;
                    int file1NextByte = file1Stream.read();
                    if (file1NextByte == (file2NextByte = file2Stream.read())) continue;
                    differenceFound = true;
                }
                if (!($assertionsDisabled || differenceFound || file1Stream.available() == 0 && file1Stream.available() == 0)) {
                    throw new AssertionError();
                }
                file1Stream.close();
                file2Stream.close();
                return differenceFound ? Boolean.FALSE : Boolean.TRUE;
            }
        };
        return SafeRunner.safeExecute(runnable, exceptionFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirectoryWritableAndNotVirtual(File file) {
        try {
            if (!file.canWrite()) {
                return false;
            }
            if (!file.isDirectory()) {
                return false;
            }
            File fileTest = null;
            try {
                try {
                    fileTest = File.createTempFile("writtableArea", ".dll", file);
                    return true;
                }
                catch (IOException e) {
                    if (fileTest == null) return false;
                    FileHelper.deleteFileOrDirectory(fileTest);
                    return false;
                }
            }
            finally {
                if (fileTest != null) {
                    FileHelper.deleteFileOrDirectory(fileTest);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDirectoryInWindowsVistaOr7VirtualStore(File file) throws JvmExternalResourceInteractionException {
        boolean dllFileCreateable;
        boolean txtFileCreateable;
        block23: {
            block21: {
                block19: {
                    block18: {
                        try {
                            if (file.canWrite()) break block18;
                            return false;
                        }
                        catch (Exception e) {
                            throw new JvmExternalResourceInteractionException(e);
                        }
                    }
                    if (file.isDirectory()) break block19;
                    return false;
                }
                File fileTest = null;
                try {
                    try {
                        fileTest = File.createTempFile("writtableArea", ".txt", file);
                        txtFileCreateable = true;
                    }
                    catch (IOException e) {
                        txtFileCreateable = false;
                        if (fileTest != null) {
                            FileHelper.deleteFileOrDirectory(fileTest);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (fileTest != null) {
                        FileHelper.deleteFileOrDirectory(fileTest);
                    }
                    throw throwable;
                }
                if (fileTest != null) {
                    FileHelper.deleteFileOrDirectory(fileTest);
                }
            }
            File fileTest = null;
            try {
                try {
                    fileTest = File.createTempFile("writtableArea", ".dll", file);
                    dllFileCreateable = true;
                }
                catch (IOException e) {
                    dllFileCreateable = false;
                    if (fileTest != null) {
                        FileHelper.deleteFileOrDirectory(fileTest);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (fileTest != null) {
                    FileHelper.deleteFileOrDirectory(fileTest);
                }
                throw throwable;
            }
            if (fileTest != null) {
                FileHelper.deleteFileOrDirectory(fileTest);
            }
        }
        return txtFileCreateable && !dllFileCreateable;
    }

    public static String convertStringToPortableFileName(String p_fileName) {
        int replacementChar = 95;
        StringBuilder result = new StringBuilder(p_fileName.length());
        int i = 0;
        while (i < p_fileName.length()) {
            char charAtI = p_fileName.charAt(i);
            if (VALID_CHARS_IN_PURE_FILENAME.indexOf(charAtI) != -1) {
                result.append(charAtI);
            } else {
                result.append('_');
            }
            ++i;
        }
        return result.toString();
    }

    public static String shortenFileName(String p_fileName, int maxLength) {
        if (p_fileName.length() <= maxLength) {
            return p_fileName;
        }
        String extension = FileHelper.getFileExtension(p_fileName);
        if (extension.length() > 0) {
            int newMaxLength = Math.max(extension.length() + 2, maxLength);
            String shortenedName = p_fileName.substring(0, Math.min(newMaxLength, p_fileName.length()) - extension.length() - 1);
            return String.valueOf(shortenedName) + '.' + extension;
        }
        return p_fileName.substring(0, Math.min(maxLength, p_fileName.length()));
    }
}

