/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.extensioning;

import com.arcway.lib.extensioning.EXInstanciationFailed;
import com.arcway.lib.extensioning.ExtensionPoint;
import com.arcway.lib.extensioning.IConfigurationElement;
import com.arcway.lib.extensioning.IConfigurationElementAttributeFactory;
import com.arcway.lib.extensioning.IExtension;
import com.arcway.lib.extensioning.IPlugin;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;

public abstract class ObjectExtensionPoint
extends ExtensionPoint {
    private static final ILogger logger = Logger.getLogger(ObjectExtensionPoint.class);

    protected ObjectExtensionPoint(IPlugin plugin, String extensionPointID, String configElementName, String attributeName, Class instanceType) {
        super(plugin, extensionPointID);
        Assert.checkArgumentBeeingNotNull(configElementName);
        Assert.checkArgumentBeeingNotNull(attributeName);
        Assert.checkArgumentBeeingNotNull(instanceType);
        ICollection_<Object> createdObjectInstances = this.createRegisteredObjects(configElementName, attributeName, instanceType);
        this.storeCreatedObjects(createdObjectInstances);
    }

    private ICollection_<Object> createRegisteredObjects(String configElementName, String attributeName, Class instanceType) {
        ArrayList_<Object> loadedExtensionInstances = new ArrayList_<Object>();
        Collection<? extends IExtension> extensions = this.getExtensions();
        for (IExtension iExtension : extensions) {
            Collection<? extends IConfigurationElement> configurationElements = iExtension.getConfigurationElements(configElementName);
            for (IConfigurationElement iConfigurationElement : configurationElements) {
                IConfigurationElementAttributeFactory objectFactory = iConfigurationElement.getAttributeAsFactory(attributeName);
                try {
                    Object createdObject = objectFactory.createInstance();
                    if (createdObject != null) {
                        if (instanceType.isInstance(createdObject)) {
                            loadedExtensionInstances.add(createdObject);
                            continue;
                        }
                        logger.error("Error while reading extension for extension point " + To.makeNotNull(this.getExtensionPointID()) + ": instanciated object " + configElementName + "/" + attributeName + " is not of type " + instanceType.getName() + " (type is " + createdObject.getClass().getName() + ")");
                        continue;
                    }
                    logger.error("Error while reading extension for extension point " + To.makeNotNull(this.getExtensionPointID()) + ": instanciated object " + configElementName + "/" + attributeName + " is null");
                }
                catch (EXInstanciationFailed e) {
                    logger.error("Error while reading extension for extension point " + To.makeNotNull(this.getExtensionPointID()) + ": could not instanciate object " + configElementName + "/" + attributeName, e);
                }
            }
        }
        return loadedExtensionInstances;
    }

    protected abstract void storeCreatedObjects(ICollection_<Object> var1);
}

