/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLAttributeValue;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;

public class XMLAttribute {
    private final XMLAttributeName attributeName;
    private final XMLAttributeValue attributeValue;

    public static IMap_<XMLAttributeName, XMLAttribute> createAttributeMap(IList_<XMLAttribute> attributes) {
        HashMap_<XMLAttributeName, XMLAttribute> attributeMap = new HashMap_<XMLAttributeName, XMLAttribute>(attributes.size(), XMLAttributeName.IS_EQUAL_XML_ATTRIBUTE_NAME_HASHER);
        for (XMLAttribute attribute : attributes) {
            attributeMap.put(attribute.getAttributeName(), attribute);
        }
        return attributeMap;
    }

    public static XMLAttributeValue findValueByAtributeName(IList_<XMLAttribute> attributes, XMLAttributeName attributeName) {
        XMLAttribute xmlAttribute = XMLAttribute.findByAtributeName(attributes, attributeName);
        XMLAttributeValue attributeValue = xmlAttribute == null ? null : xmlAttribute.getAttributeValue();
        return attributeValue;
    }

    private static XMLAttribute findByAtributeName(IList_<XMLAttribute> attributes, XMLAttributeName attributeName) {
        XMLAttribute attribute = null;
        for (XMLAttribute candidate : attributes) {
            if (!XMLAttributeName.IS_EQUAL_XML_ATTRIBUTE_NAME_HASHER.isEqual(candidate.getAttributeName(), attributeName)) continue;
            attribute = candidate;
            break;
        }
        return attribute;
    }

    public XMLAttribute(XMLAttributeName attributeName, XMLAttributeValue attributeValue) {
        Assert.checkArgumentBeeingNotNull(attributeName);
        Assert.checkArgumentBeeingNotNull(attributeValue);
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public XMLAttributeName getAttributeName() {
        return this.attributeName;
    }

    public XMLAttributeValue getAttributeValue() {
        return this.attributeValue;
    }

    public boolean isEqualXMLAttributeName(XMLAttribute attributeNameToCompare) {
        Assert.checkArgumentBeeingNotNull(attributeNameToCompare);
        return this.attributeName.isEqualXMLAttributeName(attributeNameToCompare.attributeName);
    }

    public int hashCodeForIsEqualXMLAttributeName() {
        return this.attributeName.hashCodeForIsEqualXMLAttributeName();
    }

    public String toString() {
        return String.valueOf(To.string(this)) + " (\"" + this.getAttributeName() + "\" / \"" + this.getAttributeValue() + "\" )";
    }
}

