/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.codecs.ram;

import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.data.codecs.ram.IRAMData;
import com.arcway.lib.codec.data.codecs.ram.IStructuredRAMData;
import com.arcway.lib.codec.data.codecs.ram.RAMData;
import com.arcway.lib.codec.data.codecs.ram.RAMDataCoDecForData;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;

public class StructuredRAMData
extends RAMData
implements IStructuredRAMData {
    private final IList_<IKey> allFlagAndPropertyAndChildRolesAsList;
    private final ISet_<IKey> setFlags;
    private final IMap_<IKey, IRAMData> role2property;
    private final IMap_<IKey, ? extends IList_<IRAMData>> role2children;

    public StructuredRAMData(IStructuredDataType sourceDataType, Object sourceData) {
        this.allFlagAndPropertyAndChildRolesAsList = new ArrayList_<IList_<IKey>>(sourceDataType.getFlagAndPropertyAndChildRoles(sourceData));
        HashSet_<IKey> setFlagsRW = new HashSet_<IKey>((IKey)this.allFlagAndPropertyAndChildRolesAsList.size(), IKey.IS_EQUAL_IKEY_HASHER);
        HashMap_<IKey, IRAMData> role2propertyRW = new HashMap_<IKey, IRAMData>(this.allFlagAndPropertyAndChildRolesAsList.size(), IKey.IS_EQUAL_IKEY_HASHER);
        HashMap_<IKey, ? extends IList_<IRAMData>> role2childrenRW = new HashMap_<IKey, IList_<IRAMData>>(this.allFlagAndPropertyAndChildRolesAsList.size(), IKey.IS_EQUAL_IKEY_HASHER);
        for (IKey role : this.allFlagAndPropertyAndChildRolesAsList) {
            SubDataType subDataType = sourceDataType.getSubDataType(role);
            if (subDataType.isFlag()) {
                if (!sourceDataType.isSet(sourceData, role)) continue;
                setFlagsRW.add(role);
                continue;
            }
            if (subDataType.isProperty() || subDataType.isChild()) {
                IDataType dataTypeOfPropertyOrChild = sourceDataType.getDataTypeOfPropertyOrChildren(sourceData, role);
                if (subDataType.isProperty()) {
                    Object propertyData = sourceDataType.getProperty(sourceData, role);
                    RAMData property = RAMDataCoDecForData.encodeIntoRAMData(dataTypeOfPropertyOrChild, propertyData);
                    role2propertyRW.put(role, property);
                    continue;
                }
                IList_<? extends Object> childDatas = sourceDataType.getChildren(sourceData, role);
                ArrayList_<RAMData> children = new ArrayList_<RAMData>(childDatas.size());
                for (Object e : childDatas) {
                    RAMData child = RAMDataCoDecForData.encodeIntoRAMData(dataTypeOfPropertyOrChild, e);
                    children.add(child);
                }
                role2childrenRW.put(role, children);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        this.setFlags = setFlagsRW;
        this.role2property = role2propertyRW;
        this.role2children = role2childrenRW;
    }

    @Override
    public IIterator_<IKey> keyIterator() {
        return this.allFlagAndPropertyAndChildRolesAsList.iterator();
    }

    @Override
    public boolean isFlagSet(IKey role) {
        return this.setFlags.contains(role);
    }

    @Override
    public IRAMData getProperty(IKey role) {
        return this.role2property.getByKey(role);
    }

    @Override
    public IList_<? extends IRAMData> getChildren(IKey role) {
        return this.role2children.getByKey(role);
    }

    @Override
    public Object decodeElementaryData(IElementaryDataType dataType) throws EXDataCreationFailed {
        throw new EXDataCreationFailed(new IllegalArgumentException("Elementary data type expected, but structured data was found."));
    }

    @Override
    public Object decodeStructuredData(IStructuredDataType dataType) throws EXDataCreationFailed {
        IStructuredDataFactory dataFactory = dataType.createDataFactory();
        IIterator_<IKey> i = this.keyIterator();
        while (i.hasNext()) {
            IKey role = (IKey)i.next();
            SubDataType subDataType = dataType.getSubDataType(role);
            if (subDataType.isFlag()) {
                if (!this.isFlagSet(role)) continue;
                dataFactory.setFlag(role);
                continue;
            }
            if (subDataType.isProperty() || subDataType.isChild()) {
                IDataType dataTypeOfPropertyOrChild = dataFactory.getDataTypeOfPropertyOrChildren(role);
                if (subDataType.isProperty()) {
                    IRAMData property = this.getProperty(role);
                    Object propertyData = RAMDataCoDecForData.decodeFromRAMData(dataTypeOfPropertyOrChild, property);
                    try {
                        dataFactory.addPropertyOrChild(role, propertyData);
                        continue;
                    }
                    catch (EXDataAssemblingFailed eXDataAssemblingFailed) {
                        throw new EXDataCreationFailed(eXDataAssemblingFailed.getCausingException());
                    }
                }
                IList_<? extends IRAMData> children = this.getChildren(role);
                for (IRAMData iRAMData : children) {
                    Object childData = RAMDataCoDecForData.decodeFromRAMData(dataTypeOfPropertyOrChild, iRAMData);
                    try {
                        dataFactory.addPropertyOrChild(role, childData);
                    }
                    catch (EXDataAssemblingFailed e) {
                        throw new EXDataCreationFailed(e.getCausingException());
                    }
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
        Object data = dataFactory.createDataElement();
        return data;
    }
}

