/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.mk;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Davis = new String[] {
               "\u0414\u0435\u0458\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\u041a\u0443\u0431\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u0443\u0431\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CDT",
               "\u041a\u0443\u0431\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0421\u0440\u0435\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435 \u0441\u043f\u043e\u0440\u0435\u0434 \u0413\u0440\u0438\u043d\u0438\u0447",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Paraguay = new String[] {
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PST",
               "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Maldives = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u041c\u0430\u043b\u0434\u0438\u0432\u0438",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Europe_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WET",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "WET",
            };
        final String[] Brasilia = new String[] {
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "BT",
            };
        final String[] Greenland_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WGST",
               "\u0417\u0430\u043f\u0430\u0434\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WGST",
               "\u0417\u0430\u043f\u0430\u0434\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "WGT",
            };
        final String[] Colombia = new String[] {
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CST",
               "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Suriname = new String[] {
               "\u0421\u0443\u0440\u0438\u043d\u0430\u043c \u0432\u0440\u0435\u043c\u0435",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Cocos = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u041a\u043e\u043a\u043e\u0441 \u043e\u0441\u0442\u0440\u043e\u0432\u0438",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0410\u043c\u0430\u0437\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "AST",
               "\u0410\u043c\u0430\u0437\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Seychelles = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0421\u0435\u0458\u0448\u0435\u043b\u0438",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PDT",
               "\u041f\u0430\u0446\u0438\u0444\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "WAST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] Bolivia = new String[] {
               "\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430 \u0432\u0440\u0435\u043c\u0435",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u041f\u0435\u0440\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PST",
               "\u041f\u0435\u0440\u0443 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PST",
               "\u041f\u0435\u0440\u0443 \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] French_Guiana = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Newfoundland = new String[] {
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "NST",
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "NDT",
               "\u040a\u0443\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "NT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EGST",
               "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "EGST",
               "\u0418\u0441\u0442\u043e\u0447\u0435\u043d \u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434 \u0432\u0440\u0435\u043c\u0435",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0411\u043e\u0436\u0438\u045c\u043d\u0438\u043e\u0442 \u043e\u0441\u0442\u0440\u043e\u0432",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u0432\u0440\u0435\u043c\u0435",
               "VT",
            };
        final String[] America_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CDT",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Guyana = new String[] {
               "\u0413\u0432\u0430\u0458\u0430\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Argentina = new String[] {
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "AST",
               "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0408\u0443\u0436\u043d\u043e-\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] French_Southern = new String[] {
               "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u043e \u0458\u0443\u0436\u043d\u043e \u0438 \u0430\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0447\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Mauritius = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0443\u0441",
               "MST",
               "\u041b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e \u043d\u0430 \u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0443\u0441",
               "MST",
               "Mauritius Time",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0418\u043d\u0434\u0438\u0441\u043a\u0438 \u041e\u043a\u0435\u0430\u043d",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Chile = new String[] {
               "\u0427\u0438\u043b\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0427\u0438\u043b\u0435 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CST",
               "\u0427\u0438\u043b\u0435 \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "EDT",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ET",
            };
        final String[] Venezuela = new String[] {
               "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430 \u0432\u0440\u0435\u043c\u0435",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Noronha = new String[] {
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u045a\u0430 \u0432\u0440\u0435\u043c\u0435",
               "FNT",
            };
        final String[] America_Mountain = new String[] {
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "MDT",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Mawson = new String[] {
               "\u041c\u043e\u0441\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "PMST",
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "PMDT",
               "\u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0432\u0440\u0435\u043c\u0435",
               "PMT",
            };
        final String[] Rothera = new String[] {
               "\u0420\u043e\u0442\u0435\u0440\u0430 \u0432\u0440\u0435\u043c\u0435",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "\u0421\u0440\u0435\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CET",
               "\u0421\u0440\u0435\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "CEST",
               "\u0421\u0440\u0435\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "CET",
            };
        final String[] Vostok = new String[] {
               "\u0412\u043e\u0441\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0414\u0438\u043c\u043e\u043d-\u0434\u0443\u0440\u0432\u0438\u043b \u0432\u0440\u0435\u043c\u0435",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EET",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "EEST",
               "\u0418\u0441\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0441\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0441\u043a\u043e \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "ADT",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] Reunion = new String[] {
               "\u0412\u0440\u0435\u043c\u0435 \u043d\u0430 \u0420\u0438\u0458\u0443\u043d\u0438\u043e\u043d",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Uruguay = new String[] {
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "UST",
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u043b\u0435\u0442\u043d\u043e \u0441\u043c\u0435\u0442\u0430\u045a\u0435 \u043d\u0430 \u0432\u0440\u0435\u043c\u0435\u0442\u043e",
               "UST",
               "\u0423\u0440\u0443\u0433\u0432\u0430\u0458 \u0432\u0440\u0435\u043c\u0435",
               "UT",
            };
        final String[] Ecuador = new String[] {
               "\u0415\u043a\u0432\u0430\u0434\u043e\u0440 \u0432\u0440\u0435\u043c\u0435",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Halifax", Atlantic },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "Europe/Samara", Moscow },
            { "Africa/Douala", Africa_Western },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Bogota", Colombia },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Zurich", Europe_Central },
            { "America/Montevideo", Uruguay },
            { "America/Winnipeg", America_Central },
            { "America/Resolute", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "America/Danmarkshavn", GMT },
            { "Europe/Dublin", GMT },
            { "America/Regina", America_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Ndjamena", Africa_Western },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Europe/Istanbul", Europe_Eastern },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Davis", Davis },
            { "America/Cayman", America_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Europe/Jersey", GMT },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Toronto", America_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Africa/Sao_Tome", GMT },
            { "America/Miquelon", Pierre_Miquelon },
            { "Indian/Reunion", Reunion },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Moncton", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "Africa/Dakar", GMT },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Indian/Cocos", Cocos },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Caracas", Venezuela },
            { "Africa/Accra", GMT },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Juba", Africa_Eastern },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "America/Jujuy", Argentina },
            { "America/Lima", Peru },
            { "Europe/Rome", Europe_Central },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Havana", Cuba },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Africa/Conakry", GMT },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "America/St_Thomas", Atlantic },
            { "America/Paramaribo", Suriname },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/La_Paz", Bolivia },
            { "America/Nipigon", America_Eastern },
            { "America/Cayenne", French_Guiana },
            { "America/Dominica", Atlantic },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Europe/Bratislava", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Zagreb", Europe_Central },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
