/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.shared.message.AbstractStreamDataBuffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class FragmentedStreamDataBuffer
extends AbstractStreamDataBuffer {
    private static final ILogger LOGGER = Logger.getLogger(FragmentedStreamDataBuffer.class);
    private final Occupation occupation = new Occupation();
    private long totalStreamLength = -1L;
    private StreamStorage storage = null;

    static {
        FragmentedStreamDataBuffer.testOccupation();
    }

    public FragmentedStreamDataBuffer(AbstractStreamDataBuffer.ITempFileManager tempFileManager) {
        super(tempFileManager);
    }

    private synchronized void appendData(ByteBuffer src, long position) throws IOException {
        long bufferLength = src.remaining();
        Interval bufferDataInterval = new Interval(position, bufferLength);
        Occupation.OccupationStatus occupationStatus = this.occupation.isOccupied(bufferDataInterval);
        if (occupationStatus != Occupation.OccupationStatus.fullyOccupied) {
            if (this.storage == null && src.hasRemaining()) {
                assert (false) : "totalStreamLength must be set before the first databytes are buffered to make selection of optimal buffer implementation possible. Else we will default to slow file based buffer store.";
                this.storage = new StorageFile(this.getTempFile());
            }
            while (src.hasRemaining()) {
                this.storage.write(src, position);
            }
            this.occupation.markAsOccupied(position, bufferLength);
        }
    }

    public static void depleteInputStream(long requestBytesSegmentLength, InputStream inputStream) throws IOException {
        long cummulatedInputStreamBytes = 0L;
        ByteBuffer bb = ByteBuffer.allocate(2048);
        assert (bb.hasArray());
        while (true) {
            bb.clear();
            int readResult = inputStream.read(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
            if (readResult == -1) break;
            bb.position(readResult);
            bb.flip();
            cummulatedInputStreamBytes += (long)readResult;
        }
        if (requestBytesSegmentLength > 0L && cummulatedInputStreamBytes != requestBytesSegmentLength) {
            assert (false);
            LOGGER.warn("Actual segment body length does not match body length specified in segment header.");
        }
    }

    public void append(long requestBytesStartIndex, long requestBytesSegmentLength, InputStream inputStream, AbstractStreamDataBuffer.IBufferTransferProgressWatchdog watchdog) throws IOException {
        long cummulatedInputStreamBytes = 0L;
        ByteBuffer bb = ByteBuffer.allocate(2048);
        assert (bb.hasArray());
        while (true) {
            bb.clear();
            int readResult = inputStream.read(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
            if (readResult == -1) break;
            bb.position(readResult);
            bb.flip();
            this.appendData(bb, requestBytesStartIndex + cummulatedInputStreamBytes);
            if (watchdog != null) {
                watchdog.noteTransferActivity(readResult);
            }
            cummulatedInputStreamBytes += (long)readResult;
        }
        if (cummulatedInputStreamBytes != requestBytesSegmentLength) {
            assert (false);
            LOGGER.warn("Actual segment body length does not match body length specified in segment header.");
        }
    }

    @Override
    public synchronized long getTotalStreamLength() {
        return this.totalStreamLength;
    }

    public synchronized void setTotalStreamLength(long p_totalStreamLength) throws IOException {
        assert (p_totalStreamLength == -1L || p_totalStreamLength >= 0L);
        if (this.totalStreamLength == -1L) {
            this.totalStreamLength = p_totalStreamLength;
        } else assert (this.totalStreamLength == p_totalStreamLength) : "TotalStreamLength must not change.";
        if (this.totalStreamLength != -1L && this.storage == null) {
            this.storage = this.totalStreamLength <= 10240L ? new StorageArray((int)this.totalStreamLength) : new StorageFile(this.getTempFile());
        }
    }

    public synchronized boolean isBrimming() {
        if (this.totalStreamLength != -1L) {
            if (this.totalStreamLength == 0L) {
                assert (this.occupation.getTotalOccupation() == 0L) : "Buffer is expected to contain nothing more than the stream data.";
                return true;
            }
            Interval totalStreamInterval = new Interval(0L, this.totalStreamLength);
            Occupation.OccupationStatus currentOccupation = this.occupation.isOccupied(totalStreamInterval);
            if (currentOccupation == Occupation.OccupationStatus.fullyOccupied) {
                assert (this.occupation.doesExactlyOccupy(totalStreamInterval)) : "Buffer is expected to contain nothing more than the stream data.";
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized MissingBytesInfo getMissingBytesInfo() {
        if (this.totalStreamLength != -1L) {
            return this.occupation.getMissingBytesInfo(0L, this.totalStreamLength);
        }
        return this.occupation.getMissingBytesInfo(0L, -1L);
    }

    public synchronized InputStream getContentAsStream() throws IOException {
        assert (this.isBrimming());
        return this.storage.getContentAsStream();
    }

    @Override
    public synchronized void dispose() {
        if (this.storage != null) {
            this.storage.dispose();
        }
        super.dispose();
    }

    public synchronized void getStatus(IStatusReceiver statusReceiver) {
        statusReceiver.initialise(this, this.getTotalStreamLength(), this.occupation.getTotalOccupation());
    }

    private static void testOccupation() {
        Occupation testOccupation = new Occupation();
        testOccupation.markAsOccupied(0L, 9291016L);
        testOccupation.markAsOccupied(0x900000L, 970948L);
        testOccupation.markAsOccupied(0xA00000L, 1692470L);
        MissingBytesInfo missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 12178230L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(9291016L, 12178230L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(9291017L, 12178230L);
        assert (missingBytesInfo.startIndex == 9291017L && missingBytesInfo.extent == 146167L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x8FFFFFL, 1L);
        assert (missingBytesInfo.startIndex == 0x8FFFFFL && missingBytesInfo.extent == 1L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900000L, 1L);
        assert (missingBytesInfo.startIndex == -1L && missingBytesInfo.extent == 0L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900001L, 1L);
        assert (missingBytesInfo.startIndex == -1L && missingBytesInfo.extent == 0L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x8FFFFFL, 5L);
        assert (missingBytesInfo.startIndex == 0x8FFFFFL && missingBytesInfo.extent == 1L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900000L, 970947L);
        assert (missingBytesInfo.startIndex == -1L && missingBytesInfo.extent == 0L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900001L, 970948L);
        assert (missingBytesInfo.startIndex == 10408132L && missingBytesInfo.extent == 1L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900001L, 970949L);
        assert (missingBytesInfo.startIndex == 10408132L && missingBytesInfo.extent == 2L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, -1L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(9291016L, -1L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(9291017L, -1L);
        assert (missingBytesInfo.startIndex == 9291017L && missingBytesInfo.extent == 146167L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x8FFFFFL, -1L);
        assert (missingBytesInfo.startIndex == 0x8FFFFFL && missingBytesInfo.extent == 1L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900000L, -1L);
        assert (missingBytesInfo.startIndex == 10408132L && missingBytesInfo.extent == 77628L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0x900001L, -1L);
        assert (missingBytesInfo.startIndex == 10408132L && missingBytesInfo.extent == 77628L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(12178230L, -1L);
        assert (missingBytesInfo.startIndex == 12178230L && missingBytesInfo.extent == -1L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 9291015L);
        assert (missingBytesInfo.startIndex == -1L && missingBytesInfo.extent == 0L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 9291016L);
        assert (missingBytesInfo.startIndex == -1L && missingBytesInfo.extent == 0L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 9291017L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 1L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0x8FFFFCL);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146164L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0x8FFFFFL);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146167L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0x900000L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0x900001L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0x9FFFFFL);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0xA00000L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        missingBytesInfo = testOccupation.getMissingBytesInfo(0L, 0xA00005L);
        assert (missingBytesInfo.startIndex == 9291016L && missingBytesInfo.extent == 146168L);
        MissingBytesInfo missingBytesInfo2 = testOccupation.getMissingBytesInfo(0x900001L, 970949L);
    }

    public static interface IStatusReceiver {
        public void initialise(FragmentedStreamDataBuffer var1, long var2, long var4);
    }

    public static class Interval {
        private final long startIndex;
        private final long length;

        public Interval(long startIndex, long length) {
            assert (length > 0L);
            assert (startIndex >= 0L);
            assert (length <= Long.MAX_VALUE - startIndex);
            this.startIndex = startIndex;
            this.length = length;
        }

        public boolean contains(long index) {
            return index >= this.startIndex && index < this.startIndex + this.length;
        }

        public static Interval merge(Interval i1, Interval i2) {
            Interval higherInterval;
            Interval lowerInterval;
            if (i1.startIndex == i2.startIndex) {
                if (i1.length >= i2.length) {
                    return i1;
                }
                return i2;
            }
            if (i1.startIndex < i2.startIndex) {
                lowerInterval = i1;
                higherInterval = i2;
            } else {
                lowerInterval = i2;
                higherInterval = i1;
            }
            if (lowerInterval.contains(higherInterval.startIndex) || lowerInterval.startIndex + lowerInterval.length == higherInterval.startIndex) {
                return new Interval(lowerInterval.startIndex, Math.max(lowerInterval.length, higherInterval.startIndex + higherInterval.length - lowerInterval.startIndex));
            }
            return null;
        }

        public Interval getIntersectionInterval(Interval secondInterval) {
            Interval higherInterval;
            Interval lowerInterval;
            if (this.startIndex == secondInterval.startIndex) {
                if (secondInterval.length <= this.length) {
                    return secondInterval;
                }
                return this;
            }
            if (this.startIndex < secondInterval.startIndex) {
                lowerInterval = this;
                higherInterval = secondInterval;
            } else {
                lowerInterval = secondInterval;
                higherInterval = this;
            }
            if (lowerInterval.contains(higherInterval.startIndex)) {
                long intersectionIntervalStartIndex = higherInterval.startIndex;
                long lowerIntervalEndIndex = lowerInterval.startIndex + lowerInterval.length - 1L;
                long higherIntervalEndIndex = higherInterval.startIndex + higherInterval.length - 1L;
                long intersectionIntervalEndIndex = Math.min(lowerIntervalEndIndex, higherIntervalEndIndex);
                long intersectionLength = intersectionIntervalEndIndex - intersectionIntervalStartIndex + 1L;
                return new Interval(intersectionIntervalStartIndex, intersectionLength);
            }
            return null;
        }

        public long getStartIndex() {
            return this.startIndex;
        }

        public long getLength() {
            return this.length;
        }

        public long getEndIndex() {
            return this.startIndex + (this.length - 1L);
        }
    }

    public static class MissingBytesInfo {
        private final long startIndex;
        private final long extent;
        public static final long nothingMissingStartIndex = -1L;
        public static final long unknownExtent = -1L;

        public MissingBytesInfo(long startIndex, long extent) {
            assert (startIndex != -1L || extent == 0L);
            assert (startIndex >= 0L || startIndex == -1L);
            assert (extent >= 0L || extent == -1L);
            this.startIndex = startIndex;
            this.extent = extent;
        }

        public long getStartIndex() {
            return this.startIndex;
        }

        public long getExtent() {
            return this.extent;
        }
    }

    private static class Occupation {
        private final List<Interval> occcupiedIntervals = new ArrayList<Interval>();

        private Occupation() {
        }

        /*
         * Unable to fully structure code
         */
        public void markAsOccupied(long startIndex, long length) {
            insertPos_ = -1;
            newInterval = new Interval(startIndex, length);
            i = 0;
            while (i < this.occcupiedIntervals.size() && insertPos_ == -1) {
                if (Interval.access$0(this.occcupiedIntervals.get(i)) > Interval.access$0(newInterval)) {
                    insertPos_ = i;
                    this.occcupiedIntervals.add(i, newInterval);
                }
                ++i;
            }
            if (insertPos_ == -1) {
                insertPos_ = this.occcupiedIntervals.size();
                this.occcupiedIntervals.add(newInterval);
            }
            insertPos = insertPos_;
            if (Occupation.$assertionsDisabled || insertPos != -1) ** GOTO lbl22
            throw new AssertionError();
            while ((mergeResult = Interval.merge(this.occcupiedIntervals.get(insertPos), this.occcupiedIntervals.get(insertPos + 1))) != null) {
                this.occcupiedIntervals.remove(insertPos);
                this.occcupiedIntervals.set(insertPos, mergeResult);
lbl22:
                // 2 sources

                if (insertPos + 1 < this.occcupiedIntervals.size()) continue;
            }
            if (insertPos > 0 && (mergeResult = Interval.merge(this.occcupiedIntervals.get(insertPos - 1), this.occcupiedIntervals.get(insertPos))) != null) {
                this.occcupiedIntervals.remove(insertPos - 1);
                this.occcupiedIntervals.set(insertPos - 1, mergeResult);
            }
        }

        public OccupationStatus isOccupied(Interval interval) {
            for (Interval i : this.occcupiedIntervals) {
                Interval intersectionInterval = i.getIntersectionInterval(interval);
                if (intersectionInterval == null) continue;
                if (intersectionInterval.length == interval.length) {
                    return OccupationStatus.fullyOccupied;
                }
                return OccupationStatus.partialyOccupied;
            }
            return OccupationStatus.unoccupied;
        }

        public boolean doesExactlyOccupy(Interval interval) {
            if (this.occcupiedIntervals.size() == 1) {
                Interval singleOccupationInterval = this.occcupiedIntervals.get(0);
                return singleOccupationInterval.getLength() == interval.getLength() && singleOccupationInterval.getStartIndex() == interval.getStartIndex();
            }
            return false;
        }

        private Interval getMissingBytesInfo_UpTo_Long_MAX_VALUE(long startIndex) {
            Interval searchInterval = new Interval(startIndex, Long.MAX_VALUE - startIndex);
            int firstIntersectingIntervalIndex = -1;
            Interval firstIntersectingInterval = null;
            Interval intersectionInterval = null;
            int i = 0;
            while (i < this.occcupiedIntervals.size()) {
                intersectionInterval = this.occcupiedIntervals.get(i).getIntersectionInterval(searchInterval);
                if (intersectionInterval != null) {
                    firstIntersectingInterval = this.occcupiedIntervals.get(i);
                    firstIntersectingIntervalIndex = i;
                    break;
                }
                ++i;
            }
            if (firstIntersectingInterval == null) {
                return new Interval(startIndex, Long.MAX_VALUE - startIndex);
            }
            assert (intersectionInterval != null);
            if (intersectionInterval.getStartIndex() == startIndex) {
                long firstIndexBehindFirstIntersectingInterval = firstIntersectingInterval.getStartIndex() + firstIntersectingInterval.getLength();
                if (firstIntersectingIntervalIndex + 1 < this.occcupiedIntervals.size()) {
                    Interval nextOccupiedInterval = this.occcupiedIntervals.get(firstIntersectingIntervalIndex + 1);
                    return new Interval(firstIndexBehindFirstIntersectingInterval, nextOccupiedInterval.startIndex - firstIndexBehindFirstIntersectingInterval);
                }
                return new Interval(firstIndexBehindFirstIntersectingInterval, Long.MAX_VALUE - firstIndexBehindFirstIntersectingInterval);
            }
            assert (startIndex < intersectionInterval.getStartIndex());
            return new Interval(startIndex, intersectionInterval.getStartIndex() - startIndex);
        }

        public MissingBytesInfo getMissingBytesInfo(long startIndex, long extent) {
            Interval missingBytesInfo_UpTo_Long_MAX_VALUE = this.getMissingBytesInfo_UpTo_Long_MAX_VALUE(startIndex);
            if (extent == -1L) {
                if (missingBytesInfo_UpTo_Long_MAX_VALUE.getLength() == Long.MAX_VALUE - startIndex) {
                    return new MissingBytesInfo(missingBytesInfo_UpTo_Long_MAX_VALUE.startIndex, -1L);
                }
                return new MissingBytesInfo(missingBytesInfo_UpTo_Long_MAX_VALUE.startIndex, missingBytesInfo_UpTo_Long_MAX_VALUE.length);
            }
            long endIndex = startIndex + extent - 1L;
            if (endIndex < missingBytesInfo_UpTo_Long_MAX_VALUE.startIndex) {
                return new MissingBytesInfo(-1L, 0L);
            }
            if (missingBytesInfo_UpTo_Long_MAX_VALUE.contains(endIndex)) {
                return new MissingBytesInfo(missingBytesInfo_UpTo_Long_MAX_VALUE.startIndex, endIndex - missingBytesInfo_UpTo_Long_MAX_VALUE.startIndex + 1L);
            }
            return new MissingBytesInfo(missingBytesInfo_UpTo_Long_MAX_VALUE.startIndex, missingBytesInfo_UpTo_Long_MAX_VALUE.length);
        }

        public long getAvailable(long startIndex, long maxBytes) {
            Interval wantedInterval = new Interval(startIndex, maxBytes);
            Interval intersectionInterval = null;
            for (Interval i : this.occcupiedIntervals) {
                intersectionInterval = i.getIntersectionInterval(wantedInterval);
                if (intersectionInterval != null) break;
            }
            if (intersectionInterval != null && intersectionInterval.startIndex == startIndex) {
                return intersectionInterval.length;
            }
            return 0L;
        }

        public long getTotalOccupation() {
            long totalOccupation = 0L;
            for (Interval i : this.occcupiedIntervals) {
                totalOccupation += i.length;
            }
            return totalOccupation;
        }

        public static enum OccupationStatus {
            fullyOccupied,
            partialyOccupied,
            unoccupied;

        }
    }

    private static class StorageArray
    extends StreamStorage {
        private byte[] buf;

        private StorageArray(int totalStreamLength) {
            assert (totalStreamLength >= 0);
            this.buf = new byte[totalStreamLength];
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            int bytesWritten = src.remaining();
            if (bytesWritten > 0) {
                src.get(this.buf, (int)position, bytesWritten);
            }
            return bytesWritten;
        }

        @Override
        public InputStream getContentAsStream() throws IOException {
            return new ByteArrayInputStream(this.buf);
        }

        @Override
        public void dispose() {
            this.buf = null;
        }
    }

    private static class StorageFile
    extends StreamStorage {
        private final File streamDataTmpFile;
        private FileChannel randomAccessFilechannel;

        public StorageFile(File streamDataTmpFile) {
            this.streamDataTmpFile = streamDataTmpFile;
        }

        private FileChannel getRandomAccessFilechannel() throws FileNotFoundException {
            if (this.randomAccessFilechannel == null) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.streamDataTmpFile, "rw");
                this.randomAccessFilechannel = randomAccessFile.getChannel();
            }
            return this.randomAccessFilechannel;
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.getRandomAccessFilechannel().write(src, position);
        }

        @Override
        public InputStream getContentAsStream() throws IOException {
            return new FileInputStream(this.streamDataTmpFile);
        }

        @Override
        public void dispose() {
            if (this.randomAccessFilechannel != null) {
                try {
                    this.randomAccessFilechannel.close();
                }
                catch (Exception e) {
                    LOGGER.error("Problem while closing filechannel refering to obsolete tmp file.", e);
                }
            }
        }
    }

    private static abstract class StreamStorage {
        private StreamStorage() {
        }

        public abstract int write(ByteBuffer var1, long var2) throws IOException;

        public abstract InputStream getContentAsStream() throws IOException;

        public abstract void dispose();
    }
}

