/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.model;

import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.model.PSCListDataEvent;
import de.plans.psc.client.model.PSCListDataListener;
import de.plans.psc.client.model.PSCListModel;
import de.plans.psc.client.model.User;
import de.plans.psc.client.model.UserWithGroups;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.EOUserAndGroups;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.misc.StringMatcher;

public class UserListModel
implements PSCListModel {
    protected List users = new ArrayList();
    private final List listeners = new ArrayList();

    public void clear() {
        this.users.clear();
    }

    @Override
    public int getSize() {
        return this.users.size();
    }

    public User getElement(int index) {
        return (User)this.users.get(index);
    }

    @Override
    public Object getElementAt(int index) {
        return this.users.get(index);
    }

    public Object[] toArray() {
        return this.users.toArray();
    }

    public Object set(int index, User o) {
        return this.users.set(index, o);
    }

    public int indexOf(Object priv) {
        return this.users.indexOf(priv);
    }

    public boolean removeElement(User user) {
        int index = this.users.indexOf(user);
        boolean success = this.users.remove(user);
        if (success) {
            this.postRemoveEventToListeners(index, index);
        }
        return success;
    }

    public void setUsers(List users) {
        this.users = users;
        this.postChangeEventToListeners(0, users.size());
    }

    public void loadUsersFromServer(String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("User", "GetAllUsers", null);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
        this.users.clear();
        if (response != null) {
            EOList list = (EOList)response.getResponseData();
            int i = 0;
            while (i < list.size()) {
                this.addElement(new User((EOUser)list.get(i)));
                ++i;
            }
        }
        this.postChangeEventToListeners(0, this.users.size());
    }

    public void loadUsersWithGroupsFromServer(String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("User", "GetAllUsersWithGroups", null);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
        if (response != null) {
            this.users.clear();
            EOList list = (EOList)response.getResponseData();
            int i = 0;
            while (i < list.size()) {
                EOUserAndGroups userGroups = (EOUserAndGroups)list.get(i);
                this.users.add(new UserWithGroups(userGroups));
                ++i;
            }
        }
        this.postChangeEventToListeners(0, this.users.size());
    }

    public boolean addElement(User user) {
        boolean inserted = false;
        String insertString = user.getUserName().toLowerCase();
        if (insertString.length() == 0) {
            return false;
        }
        int i = 0;
        i = 0;
        while (i < this.users.size()) {
            int j = ((User)this.users.get(i)).getUserName().toLowerCase().compareTo(insertString);
            if (j == 0) {
                return false;
            }
            if (j > 0) {
                this.users.add(i, user);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.users.add(user);
        }
        this.postAddEventToListeners(i, i);
        return true;
    }

    public User find(String searchString) {
        StringMatcher sm = new StringMatcher(String.valueOf(searchString) + "*", true, false);
        for (User user : this.users) {
            if (!sm.match(user.getUserName())) continue;
            return user;
        }
        return null;
    }

    public String[] getUserNames() {
        String[] names = new String[this.users.size()];
        int i = 0;
        while (i < names.length) {
            try {
                names[i] = ((User)this.users.get(i)).getUserName();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return names;
    }

    public void clearSelectedFlag() {
        int i = 0;
        while (i < this.users.size()) {
            ((User)this.users.get(i)).setSelected(false);
            ++i;
        }
    }

    private void postAddEventToListeners(int index0, int index1) {
        int i = 0;
        while (i < this.listeners.size()) {
            PSCListDataListener l = (PSCListDataListener)this.listeners.get(i);
            l.intervalAdded(new PSCListDataEvent(this, 1, index0, index1));
            ++i;
        }
    }

    private void postRemoveEventToListeners(int index0, int index1) {
        int i = 0;
        while (i < this.listeners.size()) {
            PSCListDataListener l = (PSCListDataListener)this.listeners.get(i);
            l.intervalRemoved(new PSCListDataEvent(this, 2, index0, index1));
            ++i;
        }
    }

    private void postChangeEventToListeners(int index0, int index1) {
        int i = 0;
        while (i < this.listeners.size()) {
            PSCListDataListener l = (PSCListDataListener)this.listeners.get(i);
            l.contentsChanged(new PSCListDataEvent(this, 0, index0, index1));
            ++i;
        }
    }

    @Override
    public void addListDataListener(PSCListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(PSCListDataListener l) {
        this.listeners.remove(l);
    }
}

