/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.eclipseplugin;

import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.dialogs.swt.ServerConnectionFailureUI;
import de.plans.psc.client.eclipseplugin.Messages;
import de.plans.psc.shared.serverexceptions.EXNeedReloginException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExceptionListener
implements INotificationBusListener {
    private static final ILogger logger = Logger.getLogger(ExceptionListener.class);

    public ExceptionListener() {
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListener(this, ".show.exception", null);
    }

    @Override
    public void receiveNotification(Notification notification) {
        Object parameter = notification.getParameter();
        if (parameter instanceof Throwable) {
            logger.warn("Received Exception Notification from server " + notification.getServerID(), (Throwable)parameter);
        } else {
            logger.warn("Received Exception Notification from server " + notification.getServerID() + " - " + parameter);
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (parameter instanceof ServerNotAvailableException || parameter instanceof EXNeedReloginException) {
            display.asyncExec((Runnable)new ServerConnectionFailureDialogStarter((Exception)parameter));
        } else if (parameter instanceof EXServerException) {
            display.asyncExec((Runnable)new ServerExceptionDialogStarter((EXServerException)parameter));
        } else if (parameter instanceof Throwable) {
            display.asyncExec((Runnable)new ThrowableDialogStarter((Throwable)parameter));
        }
    }

    private void openProblemsDialog(IModificationProblem mProblem, String dialogTitle, String dialogMessage) {
        ArrayList<IModificationProblem> mProblems = new ArrayList<IModificationProblem>();
        mProblems.add(mProblem);
        ModificationProblemsDialog mDialog = new ModificationProblemsDialog(mProblems, dialogTitle, dialogMessage, EclipseSWTHelper.getShell());
        mDialog.open();
    }

    private class Problem
    implements IModificationProblem {
        private int severity = 2;
        private final String descriptionOfConsequence;
        private final String descriptionOfCause;

        public Problem(String descriptionOfCause, String descriptionOfConsequence, int severity) {
            this.descriptionOfCause = descriptionOfCause;
            this.descriptionOfConsequence = descriptionOfConsequence;
            this.severity = severity;
        }

        public Problem(String descriptionOfCause, String descriptionOfConsequence) {
            this.descriptionOfCause = descriptionOfCause;
            this.descriptionOfConsequence = descriptionOfConsequence;
        }

        public Problem(Exception exception, String descriptionOfConsequence, int severity) {
            this.descriptionOfCause = exception.getLocalizedMessage();
            this.descriptionOfConsequence = descriptionOfConsequence;
            this.severity = severity;
        }

        public Problem(Exception exception, String descriptionOfConsequence) {
            this.descriptionOfCause = exception.getLocalizedMessage();
            this.descriptionOfConsequence = descriptionOfConsequence;
        }

        public String getCauserID() {
            return "Not specified";
        }

        public String getHumanReadableDescriptionOfCause() {
            return this.descriptionOfCause;
        }

        public String getHumanReadableDescriptionOfConsequence() {
            return this.descriptionOfConsequence;
        }

        public int getSeverity() {
            return this.severity;
        }
    }

    private class ServerConnectionFailureDialogStarter
    implements Runnable {
        private final Exception e;

        private ServerConnectionFailureDialogStarter(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            ServerConnectionFailureUI.troubleshootServerConnectionFailure(EclipseSWTHelper.getShell(), null, this.e);
        }
    }

    private class ServerExceptionDialogStarter
    implements Runnable {
        private final EXServerException e;

        private ServerExceptionDialogStarter(EXServerException e) {
            this.e = e;
        }

        @Override
        public void run() {
            String descriptionOfCause = this.e.getLocalizedMessage();
            String dialogTitle = Messages.getString("ExceptionListener.EXServerException.ProblemDialogTitle");
            String dialogMesage = Messages.getString("ExceptionListener.EXServerException.ProblemDialogMessage");
            if (descriptionOfCause == null || descriptionOfCause == "") {
                descriptionOfCause = Messages.getString("ExceptionListener.EXServerException.DefaultCause");
            }
            String descriptionOfConsequence = Messages.getString("ExceptionListener.EXServerException.DefaultDescOfConsequence");
            Problem mProblem = new Problem(descriptionOfCause, descriptionOfConsequence);
            ExceptionListener.this.openProblemsDialog(mProblem, dialogTitle, dialogMesage);
        }
    }

    private class ThrowableDialogStarter
    implements Runnable {
        private final Throwable t;

        private ThrowableDialogStarter(Throwable t) {
            this.t = t;
        }

        @Override
        public void run() {
            String descriptionOfConsequence;
            String descriptionOfCause = this.t.getLocalizedMessage();
            String dialogTitle = Messages.getString("ExceptionListener.Throwable.ProblemDialogTitle");
            String dialogMesage = Messages.getString("ExceptionListener.Throwable.ProblemDialogMessage");
            if (this.t instanceof ServerNotAvailableException) {
                if (descriptionOfCause == null || descriptionOfCause == "") {
                    descriptionOfCause = Messages.getString("ExceptionListener.ServerNotAvailableException.Cause");
                }
                descriptionOfConsequence = Messages.getString("ExceptionListener.ServerNotAvailableException.DescOfConsequence");
            } else {
                if (descriptionOfCause == null || descriptionOfCause == "") {
                    descriptionOfCause = Messages.getString("ExceptionListener.Throwable.DefaultCause");
                }
                descriptionOfConsequence = Messages.getString("ExceptionListener.Throwable.DefaultDescOfConsequence");
            }
            Problem mProblem = new Problem(descriptionOfCause, descriptionOfConsequence);
            ExceptionListener.this.openProblemsDialog(mProblem, dialogTitle, dialogMesage);
        }
    }
}

