/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.eclipseplugin;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.client.eclipseplugin.IEclipsePluginMessageDataFactoryProvider;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EclipsePluginMessageDataFactory
extends PSCAbstractMessageDataFactory {
    private static final String CONFIGURATION_ELEMENT_NAME = "MessageDataFactory";
    private static final String CLASS_ATTRIBUTE = "class";
    private List factories;

    private void loadExtensions() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        assert (registry != null) : "registry must not be null";
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.lib.psc.client", "factories");
        assert (extensionPoint != null) : "extensionPoint must not be null";
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (CONFIGURATION_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    try {
                        IEncodableObjectFactory messageDataFactory = ((IEclipsePluginMessageDataFactoryProvider)currentConfigElement.createExecutableExtension(CLASS_ATTRIBUTE)).getInstance();
                        this.addFactory(messageDataFactory);
                    }
                    catch (CoreException e) {
                        WorkbenchPlugin.log((String)("Unable to instantiate Message Data Factory for PSC system " + e.getStatus()));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public EncodableObjectBase createApplEncodableObject(String name, XMLContext attributes) {
        if (this.factories == null) {
            this.factories = new ArrayList();
            this.loadExtensions();
        }
        int i = 0;
        while (i < this.factories.size()) {
            try {
                IEncodableObjectFactory factory = (IEncodableObjectFactory)this.factories.get(i);
                EncodableObjectBase object = factory.createEncodableObject(name, null);
                if (object != null) {
                    return object;
                }
            }
            catch (EXDecoderException eXDecoderException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    private void addFactory(IEncodableObjectFactory factory) {
        this.factories.add(factory);
    }
}

