/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.IServerSelectionListener;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class UIPnlSelectServerDropList
implements SelectionListener {
    private static final ILogger logger = Logger.getLogger(UIPnlSelectServerDropList.class);
    private final Combo serverListCombo;
    private int lastSelection = -1;
    private List serverConnectionList;
    private IServerSelectionListener selectionListener;

    public UIPnlSelectServerDropList(Composite parent) {
        this.serverListCombo = new Combo(parent, 12);
        this.fillServerList();
        this.serverListCombo.addSelectionListener((SelectionListener)this);
    }

    public UIPnlSelectServerDropList(Composite parent, IServerSelectionListener listener) {
        this(parent);
        this.selectionListener = listener;
    }

    private void fillServerList() {
        this.serverConnectionList = PSCClientServiceFacade.getFacade().getServerConnections();
        int i = 0;
        while (i < this.serverConnectionList.size()) {
            ServerConnection sc = (ServerConnection)this.serverConnectionList.get(i);
            this.serverListCombo.add(sc.getServerName());
            ++i;
        }
    }

    public void setLayout(Layout layout) {
        this.serverListCombo.setLayout(layout);
    }

    public void setLayoutData(Object layoutData) {
        this.serverListCombo.setLayoutData(layoutData);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.selectionListener != null) {
            try {
                this.selectionListener.serverSelected(this.getSelectedServer());
            }
            catch (ServerNotAvailableException e1) {
                logger.warn("widgetDefaultSelected()", e1);
            }
            catch (UnknownServerException e1) {
                logger.warn("widgetDefaultSelected()", e1);
            }
            catch (EXServerException e1) {
                logger.error("widgetDefaultSelected()", e1);
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.selectionListener != null) {
            try {
                this.selectionListener.serverSelected(this.getSelectedServer());
                this.lastSelection = this.serverListCombo.getSelectionIndex();
                return;
            }
            catch (ServerNotAvailableException e1) {
                logger.warn("widgetDefaultSelected()", e1);
            }
            catch (UnknownServerException e1) {
                logger.warn("widgetDefaultSelected()", e1);
            }
            catch (EXServerException e1) {
                logger.error("widgetDefaultSelected()", e1);
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
            this.serverListCombo.select(this.lastSelection);
        }
    }

    public ServerConnection getSelectedServer() {
        if (this.serverConnectionList != null && this.serverConnectionList.size() > 0) {
            return (ServerConnection)this.serverConnectionList.get(this.serverListCombo.getSelectionIndex());
        }
        return null;
    }

    public int size() {
        if (this.serverConnectionList != null) {
            return this.serverConnectionList.size();
        }
        return 0;
    }

    public void select(int index) {
        if (this.serverConnectionList != null && index < this.serverConnectionList.size()) {
            try {
                this.selectionListener.serverSelected((ServerConnection)this.serverConnectionList.get(index));
                this.serverListCombo.select(index);
            }
            catch (ServerNotAvailableException e1) {
                logger.warn("widgetDefaultSelected()", e1);
            }
            catch (UnknownServerException e1) {
                logger.warn("widgetDefaultSelected()", e1);
            }
            catch (EXServerException e1) {
                logger.error("widgetDefaultSelected()", e1);
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.serverListCombo.setEnabled(enabled);
    }
}

