/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.dialogs.admin.swt.UIPnlSelectGroups;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.client.model.UserWithGroups;
import de.plans.psc.shared.PSCUserAndGroupConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class UserWizardAssignGroupsPage
extends WizardPage {
    private UIPnlSelectGroups panelGroups;
    private GroupListModel proposedList;
    private GroupListModel selectedList;

    public UserWizardAssignGroupsPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.panelGroups = new UIPnlSelectGroups(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.panelGroups.setLayoutData(gridData);
        if (this.proposedList == null) {
            this.proposedList = new GroupListModel();
        }
        if (this.selectedList == null) {
            this.selectedList = new GroupListModel();
        }
        this.panelGroups.setLists(this.proposedList, this.selectedList);
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    protected void setGroupList(GroupListModel groups) {
        this.proposedList = new GroupListModel();
        this.selectedList = new GroupListModel();
        int i = 0;
        while (i < groups.getSize()) {
            UserGroup group = groups.getElement(i);
            if (PSCUserAndGroupConstants.isDefaultGroup(group.getEOGroup())) {
                this.selectedList.addElement(group);
            } else {
                this.proposedList.addElement(group);
            }
            ++i;
        }
        if (this.panelGroups != null) {
            this.panelGroups.setLists(this.proposedList, this.selectedList);
        }
    }

    protected void setUserAndGroupList(UserWithGroups user, GroupListModel groups) {
        this.proposedList = groups;
        this.selectedList = new GroupListModel();
        List<UserGroup> userGroups = user.getGroups();
        int i = 0;
        while (i < userGroups.size()) {
            UserGroup group = userGroups.get(i);
            if (user.isSuperAdmin() && group.isSuperGroup()) {
                group.setEnabled(false);
            }
            this.selectedList.addElement(group);
            this.proposedList.removeElement(group);
            ++i;
        }
        if (this.panelGroups != null) {
            this.panelGroups.setLists(this.proposedList, this.selectedList);
        }
    }

    protected void fillIn(UserWithGroups user) {
        ArrayList<Object> groups = new ArrayList<Object>();
        int i = 0;
        while (i < this.selectedList.getSize()) {
            groups.add(this.selectedList.getElementAt(i));
            ++i;
        }
        user.setGroups(groups);
    }
}

