/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin;

import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.lib.util.PasswordEncoder2;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.admin.AdminDialogFactoryIF;
import de.plans.psc.client.dialogs.admin.ChangePasswordWizardIF;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXPermissionException;
import de.plans.psc.shared.serverexceptions.EXServerException;

public class CtrlChangePassword
implements INotificationBusListener {
    private final AdminDialogFactoryIF factory;
    private String serverID;

    public CtrlChangePassword(AdminDialogFactoryIF factory) {
        this.factory = factory;
    }

    public void construct() {
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListener(this, "admin.change_login_password", null);
    }

    @Override
    public void receiveNotification(Notification notification) {
        this.serverID = notification.getServerID();
        EOUserAndGroupAndPermissions user = null;
        try {
            user = PSCClientServiceFacade.getFacade().getUserData(this.serverID, true);
        }
        catch (EXServerException e) {
            PSCClientServiceFacade.getFacade().showException(e, this.serverID);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
        if (user != null) {
            this.doChangePassword(user.getUser());
        }
    }

    public void doChangePassword(EOUser user) {
        boolean invalidPassword = false;
        while (true) {
            ChangePasswordWizardIF wizard = this.factory.getChangePasswordWizard();
            wizard.invokeWizard(invalidPassword ? 2 : 1);
            String newPassword = wizard.getNewPassword();
            String oldPassword = wizard.getOldPassword();
            if (newPassword == null || oldPassword == null) break;
            try {
                CtrlChangePassword.sendPasswortChangeRequest(this.serverID, user.getUserName(), oldPassword, newPassword);
            }
            catch (EXPermissionException e) {
                invalidPassword = true;
                continue;
            }
            catch (EXServerException e) {
                PSCClientServiceFacade.getFacade().showException(e, this.serverID);
            }
            catch (ServerNotAvailableException e) {
            }
            catch (UnknownServerException e) {
            }
            catch (LoginCanceledException loginCanceledException) {
                // empty catch block
            }
            break;
        }
    }

    public static EOServerResponse sendPasswortChangeRequest(String serverID, String userName, String oldPassword, String newPassword) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOGenericMessage data = new EOGenericMessage();
        data.setMsgID("changepasswd");
        data.addAttribute("username", userName);
        data.addAttribute("newPassword", PasswordEncoder2.encodePassword(newPassword));
        data.addAttribute("oldPassword2", PasswordEncoder2.encodePassword(oldPassword));
        EOClientRequest request = new EOClientRequest("User", "ChangePassword", data);
        return PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
    }
}

