/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.client.communication.ICancelableRequestJob;
import de.plans.psc.client.communication.IDataTransferRequestJob;
import de.plans.psc.client.communication.IProgressProvidingRequestJob;
import de.plans.psc.client.communication.SegmentExchangeSupervisor;
import de.plans.psc.client.communication.transmissionprocessor.ClientRequestTable;
import de.plans.psc.client.communication.transmissionprocessor.CommunicationSession;
import de.plans.psc.client.communication.transmissionprocessor.ControlAndUpdateEnquiryThread;
import de.plans.psc.client.communication.transmissionprocessor.IWorkloadProcessorStep;
import de.plans.psc.client.communication.transmissionprocessor.RequestCoDec;
import de.plans.psc.client.communication.transmissionprocessor.RequestJobProgressSummary;
import de.plans.psc.client.communication.transmissionprocessor.StepAbstractStandardRequestJob;
import de.plans.psc.client.communication.transmissionprocessor.StepFileDownloadRequestJob;
import de.plans.psc.client.communication.transmissionprocessor.StepFileUploadRequestJob;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import de.plans.psc.shared.message.RequestFamily;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class WorkloadTransmissionThread
implements Runnable {
    private static final ILogger logger = Logger.getLogger(WorkloadTransmissionThread.class);
    private static final String THREAD_NAME = "TransmissionProcessor - Workload";
    private final XMLDecoder xmlDecoder;
    private final ControlAndUpdateEnquiryThread controlAndUpdateEnquiryThread;
    private final PSCAbstractMessageDataFactory messageFactory;
    private final LinkedList<IWorkloadProcessorStep> processorStepQueue;
    private boolean mainLoopStopInitiated;
    private boolean mainLoopStopped;
    private final IWorkloadProcessorStep stepNOP = new IWorkloadProcessorStep(){

        @Override
        public void executeStep() {
        }
    };
    private final IWorkloadProcessorStep stepStopProcessor = new IWorkloadProcessorStep(){

        @Override
        public void executeStep() {
            WorkloadTransmissionThread.this.mainLoopStopped = true;
        }
    };

    public WorkloadTransmissionThread(String processorName, PSCAbstractMessageDataFactory messageFactory, ControlAndUpdateEnquiryThread controlAndUpdateEnquiryThread) {
        this.xmlDecoder = new XMLDecoder();
        this.controlAndUpdateEnquiryThread = controlAndUpdateEnquiryThread;
        this.messageFactory = messageFactory;
        this.processorStepQueue = new LinkedList();
        this.mainLoopStopInitiated = false;
        this.mainLoopStopped = false;
        Thread t = new Thread((Runnable)this, "TransmissionProcessor - Workload -- " + processorName);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.mainLoopStopped) {
            IWorkloadProcessorStep nextStep = null;
            WorkloadTransmissionThread workloadTransmissionThread = this;
            synchronized (workloadTransmissionThread) {
                if (!this.processorStepQueue.isEmpty()) {
                    nextStep = this.processorStepQueue.removeFirst();
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    nextStep = this.stepNOP;
                }
            }
            try {
                nextStep.executeStep();
            }
            catch (Throwable throwable) {
                logger.error("TransmissionProcessor - Workload: An Exception was encountered within the WorkloadTransmissionThread main-loop.", throwable);
            }
        }
    }

    public synchronized void stopProcessor() {
        if (!this.mainLoopStopInitiated) {
            this.mainLoopStopInitiated = true;
            this.processorStepQueue.clear();
            this.processorStepQueue.add(this.stepStopProcessor);
            this.notifyAll();
        }
    }

    private synchronized void queueNewProcessorStep(IWorkloadProcessorStep newStep) {
        if (this.mainLoopStopInitiated) {
            logger.warn("Attempt to enque new control processor Steps after the processor has been taken out of service.", new Exception());
        } else {
            this.processorStepQueue.add(newStep);
            this.notifyAll();
        }
    }

    public StepAbstractStandardRequestJob chargeRequest(EOClientRequest request) {
        StepRequestJob newRequestJob = new StepRequestJob(request);
        this.queueNewProcessorStep(newRequestJob);
        return newRequestJob;
    }

    public IDataTransferRequestJob chargeFileUploadRequest(List<String> transferIDs, List<File> files) {
        StepFileUploadRequestJob newRequestJob = new StepFileUploadRequestJob(transferIDs, files);
        this.queueNewProcessorStep(new DiscreteWorkloadProcessorStep(newRequestJob));
        return newRequestJob;
    }

    public IDataTransferRequestJob chargeFileDownloadRequest(List<String> transferIDs, List<File> files) {
        StepFileDownloadRequestJob newRequestJob = new StepFileDownloadRequestJob(transferIDs, files);
        this.queueNewProcessorStep(new DiscreteWorkloadProcessorStep(newRequestJob));
        return newRequestJob;
    }

    private class DiscreteWorkloadProcessorStep
    implements IWorkloadProcessorStep {
        private final IDiscreteWorkloadProcessorActivity activity;

        public DiscreteWorkloadProcessorStep(IDiscreteWorkloadProcessorActivity activity) {
            this.activity = activity;
        }

        @Override
        public void executeStep() {
            CommunicationSession communicationSession = WorkloadTransmissionThread.this.controlAndUpdateEnquiryThread.approveStartOfDiscreteWorkloadRequestJob();
            boolean communicationErrorOccured = this.activity.execute(communicationSession);
            if (communicationSession != null) {
                WorkloadTransmissionThread.this.controlAndUpdateEnquiryThread.considerDiscreteWorkloadRequestJobFeedback(communicationSession, communicationErrorOccured);
            }
        }
    }

    public static interface IDiscreteWorkloadProcessorActivity {
        public boolean execute(CommunicationSession var1);
    }

    private class StepRequestJob
    extends StepAbstractStandardRequestJob
    implements IWorkloadProcessorStep,
    ICancelableRequestJob,
    IProgressProvidingRequestJob {
        private ClientRequestTable.RequestTableEntry requestTableEntry;
        private final Object requestTableEntryMonitor;

        public StepRequestJob(EOClientRequest request) {
            this.request = request;
            this.requestTableEntry = null;
            this.requestTableEntryMonitor = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeStep() {
            block13: {
                CommunicationSession communicationSession = WorkloadTransmissionThread.this.controlAndUpdateEnquiryThread.approveStartOfWorkloadRequestWithNotificationFetch(this);
                try {
                    if (communicationSession == null) break block13;
                    try {
                        ClientRequestTable requestTable = communicationSession.getRequestTable();
                        Object object = this.requestTableEntryMonitor;
                        synchronized (object) {
                            this.requestTableEntry = requestTable.getNextFreeRequestEntry(RequestFamily.REQUEST_FAMILY_StandardRequest, null);
                        }
                        try {
                            RequestCoDec.encodeEOAsStream(this.request, this.requestTableEntry.getRequest());
                            SegmentExchangeSupervisor.exchangeSegments(communicationSession, this.requestTableEntry);
                            this.response = (EOServerResponse)RequestCoDec.decodeInputStream(this.requestTableEntry.getResponse().getContentAsStream(), WorkloadTransmissionThread.this.xmlDecoder, WorkloadTransmissionThread.this.messageFactory);
                        }
                        finally {
                            requestTable.requestCycleCompleted(this.requestTableEntry);
                        }
                    }
                    catch (IOException e) {
                        this.ioException = e;
                    }
                    catch (EXDecoderException e) {
                        this.exDecoderException = e;
                    }
                    catch (Exception e) {
                        logger.error("EXEncoderException ", e);
                        IOException ioex = new IOException("EXEncoderException");
                        ioex.initCause(e);
                        this.ioException = ioex;
                    }
                }
                finally {
                    WorkloadTransmissionThread.this.controlAndUpdateEnquiryThread.finalizeWorkloadRequestWithNotificationFetch(communicationSession, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelRequest() {
            Object object = this.requestTableEntryMonitor;
            synchronized (object) {
                if (this.requestTableEntry != null) {
                    this.requestTableEntry.cancel();
                } else {
                    assert (false);
                    logger.error("cancelRequest() is currently not possible before Request is in process of execution.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IProgressProvidingRequestJob.IProgressSummary getProgressSummary() {
            Object object = this.requestTableEntryMonitor;
            synchronized (object) {
                if (this.requestTableEntry != null) {
                    return new RequestJobProgressSummary(this.requestTableEntry.getProgressSummarySnapshot());
                }
                return new RequestJobProgressSummary(null);
            }
        }
    }
}

