/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.transmissionprocessor.ClientRequestTable;
import de.plans.psc.client.communication.transmissionprocessor.CommunicationSession;
import de.plans.psc.client.communication.transmissionprocessor.RequestProgressStatus;
import de.plans.psc.client.communication.transmissionprocessor.SegmentExchangeJob;
import de.plans.psc.client.communication.transmissionprocessor.SegmentExchangeProcessorPool;
import de.plans.psc.shared.message.ClientSegmentHeader;
import de.plans.psc.shared.message.RequestStatus;
import de.plans.psc.shared.message.ServerSegmentHeader;

public class SegmentExchangeSupervisor {
    private static final ILogger LOGGER = Logger.getLogger(SegmentExchangeSupervisor.class);
    private static final long maxRequestBytes = 49152L;
    private static final long maxResponseBytes = 131072L;
    private final CommunicationSession communicationSession;
    private final ClientRequestTable.RequestTableEntry requestEntry;
    private final RequestProgressStatus progressStatus;
    private int segmentCountTotal;
    private int segmentCountSuccess;
    private RequestStatus serverSideRequestStatus;
    private SegmentExchangeProcessorPool.ExPrematureEndOfSegmentExchange failureReason;
    private SegmentExchangeJob previousSegmentExchangeJob;

    public static void exchangeSegments(CommunicationSession communicationSession, ClientRequestTable.RequestTableEntry requestEntry) throws SegmentExchangeProcessorPool.ExPrematureEndOfSegmentExchange {
        SegmentExchangeSupervisor segmentExchangeSupervisor = new SegmentExchangeSupervisor(communicationSession, requestEntry);
        segmentExchangeSupervisor.exchangeSegments();
    }

    private SegmentExchangeSupervisor(CommunicationSession communicationSession, ClientRequestTable.RequestTableEntry requestEntry) {
        this.communicationSession = communicationSession;
        this.requestEntry = requestEntry;
        this.progressStatus = requestEntry.getProgressStatus();
        this.segmentCountTotal = 0;
        this.segmentCountSuccess = 0;
        this.serverSideRequestStatus = null;
        this.failureReason = null;
        this.previousSegmentExchangeJob = null;
    }

    /*
     * Unable to fully structure code
     */
    public void exchangeSegments() throws SegmentExchangeProcessorPool.ExPrematureEndOfSegmentExchange {
        block19: {
            try {
                try {
                    block20: {
                        request = this.requestEntry.getRequest();
                        activeRequestInfo = this.requestEntry.getRequestTable().getActiveRequestInfo();
                        while (this.previousSegmentExchangeJob == null || this.previousSegmentExchangeJob.getSegmentExchangeJobStatus() != SegmentExchangeJob.SegmentExchangeJobStatus.Completed || this.previousSegmentExchangeJob.getServerSegmentHeader().getRequestStatus() == RequestStatus.ReceivingRequestData) {
                            if (this.previousSegmentExchangeJob == null) {
                                requestBytesStartIndex = request.getMark() + 1L;
                                requestBytesSegmentLength = request.getAvailable(requestBytesStartIndex, 49152L);
                            } else if (this.previousSegmentExchangeJob.getSegmentExchangeJobStatus() == SegmentExchangeJob.SegmentExchangeJobStatus.Completed) {
                                serverSegmentHeader = this.previousSegmentExchangeJob.getServerSegmentHeader();
                                missingBytesStartIndex = serverSegmentHeader.getRequestBytesMissingBytesStartIndex();
                                if (missingBytesStartIndex == -1L || missingBytesStartIndex == request.getMark() + 1L) {
                                    requestBytesStartIndex = request.getMark() + 1L;
                                    requestBytesSegmentLength = request.getAvailable(requestBytesStartIndex, 49152L);
                                } else {
                                    requestBytesStartIndex = missingBytesStartIndex;
                                    requestBytesSegmentLength = Math.min(49152L, serverSegmentHeader.getRequestBytesMissingBytesLength());
                                }
                            } else {
                                requestBytesStartIndex = request.getMark() + 1L;
                                requestBytesSegmentLength = request.getAvailable(requestBytesStartIndex, 49152L);
                            }
                            if (requestBytesSegmentLength > 0L) {
                                indexOflastByte = requestBytesStartIndex + requestBytesSegmentLength - 1L;
                                if (request.getMark() < indexOflastByte) {
                                    request.setMark(indexOflastByte);
                                }
                            }
                            clientSegmentHeader = new ClientSegmentHeader(this.requestEntry.getRequestID(), this.requestEntry.getRequestFamily(), activeRequestInfo.getT1(), activeRequestInfo.getT2(), requestBytesStartIndex, requestBytesSegmentLength, this.requestEntry.getRequest().getTotalStreamLength(), -1L, 131072L, this.requestEntry.getRequestExtraHeaderFields());
                            this.exchangeSegment(clientSegmentHeader);
                        }
                        break block20;
                        while (true) {
                            missingBytesInfo = this.requestEntry.getResponse().getMissingBytesInfo();
                            if (-1L == missingBytesInfo.getStartIndex()) {
                                if (this.requestEntry.getResponse().isBrimming()) {
                                    break block19;
                                }
                                SegmentExchangeSupervisor.LOGGER.error("The client has detected that he has not yet received the complete response, but can not tell which bytes are missing?");
                                if (!SegmentExchangeSupervisor.$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                                responseBytesMissingBytesStartIndex = -1L;
                                responseBytesMaxSegmentBytes = 131072L;
                            } else {
                                responseBytesMissingBytesStartIndex = missingBytesInfo.getStartIndex();
                                responseBytesMaxSegmentBytes = missingBytesInfo.getExtent() == -1L ? 131072L : (missingBytesInfo.getExtent() >= 131072L ? 131072L : missingBytesInfo.getExtent());
                            }
                            clientSegmentHeader = new ClientSegmentHeader(this.requestEntry.getRequestID(), this.requestEntry.getRequestFamily(), activeRequestInfo.getT1(), activeRequestInfo.getT2(), 0L, 0L, this.requestEntry.getRequest().getTotalStreamLength(), responseBytesMissingBytesStartIndex, responseBytesMaxSegmentBytes, this.requestEntry.getRequestExtraHeaderFields());
                            this.exchangeSegment(clientSegmentHeader);
                            break;
                        }
                    }
                    if (!this.requestEntry.getResponse().isBrimming()) ** continue;
                }
                catch (SegmentExchangeProcessorPool.ExPrematureEndOfSegmentExchange e) {
                    this.failureReason = e;
                    throw e;
                }
            }
            finally {
                this.progressStatus.updateRequestProgressStatus(this.segmentCountTotal, this.segmentCountSuccess, this.serverSideRequestStatus, this.failureReason);
            }
        }
    }

    private void exchangeSegment(ClientSegmentHeader clientSegmentHeader) throws SegmentExchangeProcessorPool.ExSegmentExchangeImpossible, ExSegmentExchangeCancelled {
        SegmentExchangeJob segmentExchangeJob;
        if (this.progressStatus.updateRequestProgressStatus(this.segmentCountTotal, this.segmentCountSuccess, this.serverSideRequestStatus, this.failureReason)) {
            throw new ExSegmentExchangeCancelled();
        }
        this.previousSegmentExchangeJob = segmentExchangeJob = new SegmentExchangeJob(this.communicationSession.getUrl(), clientSegmentHeader, this.requestEntry.getRequest(), this.requestEntry.getResponse());
        this.communicationSession.getSegmentExchangeProcessorPool().exchangeSegment(segmentExchangeJob);
        ++this.segmentCountTotal;
        SegmentExchangeJob.SegmentExchangeJobStatus segmentExchangeJobStatus = segmentExchangeJob.getSegmentExchangeJobStatus();
        if (segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.Completed) {
            ++this.segmentCountSuccess;
        }
        if (segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.Completed || segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.ServerSegmentHeaderReceived) {
            ServerSegmentHeader serverSegmentHeader = segmentExchangeJob.getServerSegmentHeader();
            if (serverSegmentHeader != null) {
                RequestStatus requestStatus = serverSegmentHeader.getRequestStatus();
                if (requestStatus != null) {
                    this.serverSideRequestStatus = requestStatus;
                } else assert (false);
            } else assert (false);
        }
    }

    public static class ExSegmentExchangeCancelled
    extends SegmentExchangeProcessorPool.ExPrematureEndOfSegmentExchange {
        private static final long serialVersionUID = 1L;

        public ExSegmentExchangeCancelled() {
        }

        public ExSegmentExchangeCancelled(String message) {
            super(message);
        }
    }
}

