/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.HashSet;
import java.util.Set;

public class PermissionChangeListener
implements INotificationBusListener {
    private static final ILogger logger = Logger.getLogger(PermissionChangeListener.class);
    private final ServerConnection connection;
    private String notificationTypeAddUserPermission;
    private String notificationTypeDeleteUserPermission;
    private String notificationTypeAddRolePermission;
    private String notificationTypeDeleteRolePermission;
    private final Set<String> notificationTypesAddGroup = new HashSet<String>();
    private final Set<String> notificationTypesDeleteGroup = new HashSet<String>();

    protected PermissionChangeListener(ServerConnection c) {
        assert (c != null) : "Connection not given";
        this.connection = c;
        EOUserAndGroupAndPermissions userData = this.connection.getUserData();
        assert (userData != null) : "user data not available, login must have failed";
        try {
            this.notificationTypeAddUserPermission = "psc.permission.user.add." + userData.getUser().getUserName();
            PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(this, this.notificationTypeAddUserPermission, c.getServerID());
            this.notificationTypeDeleteUserPermission = "psc.permission.user.delete." + userData.getUser().getUserName();
            PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(this, this.notificationTypeDeleteUserPermission, c.getServerID());
            this.notificationTypeAddRolePermission = "psc.permission.stakeholderrole.add";
            PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(this, this.notificationTypeAddRolePermission, c.getServerID());
            this.notificationTypeDeleteRolePermission = "psc.permission.stakeholderrole.delete";
            PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(this, this.notificationTypeDeleteRolePermission, c.getServerID());
            if (userData.getGroups() != null) {
                for (EOGroup group : userData.getGroups()) {
                    String notificationTypeAddGroup = "psc.permission.group.add." + group.getGroupName();
                    PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(this, notificationTypeAddGroup, c.getServerID());
                    this.notificationTypesAddGroup.add(notificationTypeAddGroup);
                    String notificationTypeDeleteGroup = "psc.permission.group.delete." + group.getGroupName();
                    PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListenerOnServer(this, notificationTypeDeleteGroup, c.getServerID());
                    this.notificationTypesDeleteGroup.add(notificationTypeDeleteGroup);
                }
            }
        }
        catch (ServerNotAvailableException e) {
            logger.error("PermissionChangeListener() - Server not available when subscribing for permission change notifications.", new Exception(e));
        }
        catch (EXServerException e) {
            logger.error("PermissionChangeListener() - Server exception when subscribing for permission change notifications.", new Exception(e));
        }
        catch (LoginCanceledException e) {
            logger.fatal("PermissionChangeListener() - Login canceled when subscribing for permission change notifications.", new Exception(e));
        }
        catch (UnknownServerException e) {
            logger.fatal("PermissionChangeListener() - Unknown server when subscribing for permission change notifications.", new Exception(e));
        }
    }

    @Override
    public void receiveNotification(Notification notification) {
        String notificationType;
        EOPermission permission;
        String serverID = notification.getServerID();
        if (!this.connection.getServerID().equals(serverID)) {
            logger.error("receiveNotification() - received invalid permission change notification.");
        }
        if ((permission = (EOPermission)notification.getParameter()) == null) {
            logger.error("receiveNotification() - received permission change notification without permission.");
        }
        if ((notificationType = notification.getType()).equals(this.notificationTypeAddUserPermission)) {
            this.addPermission(permission);
        } else if (notificationType.equals(this.notificationTypeDeleteUserPermission)) {
            this.deletePermission(permission);
        } else if (this.notificationTypesAddGroup.contains(notificationType)) {
            this.addPermission(permission);
        } else if (this.notificationTypesDeleteGroup.contains(notificationType)) {
            this.deletePermission(permission);
        } else if (notificationType.equals(this.notificationTypeAddRolePermission)) {
            this.addPermission(permission);
        } else if (notificationType.equals(this.notificationTypeDeleteRolePermission)) {
            this.deletePermission(permission);
        }
    }

    public void unsubscribeAllEventsAtServerDisconnect() {
        this.notificationTypeAddUserPermission = null;
        this.notificationTypeDeleteUserPermission = null;
        this.notificationTypeAddRolePermission = null;
        this.notificationTypeDeleteRolePermission = null;
        this.notificationTypesAddGroup.clear();
        this.notificationTypesDeleteGroup.clear();
    }

    private void addPermission(EOPermission permission) {
        this.connection.getUserData().addPermission(permission);
    }

    private void deletePermission(EOPermission permission) {
        this.connection.getUserData().removePermission(permission);
    }
}

