/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.HashMap;

public class PSCAuthenticator
extends Authenticator {
    private static final PasswordAuthentication dummyPasswordAuthentication = new PasswordAuthentication("dummy", "dummy".toCharArray());
    private static final HashMap provider2tuple = new HashMap();
    private static RequestorInfo lastUnknownRequestor = null;
    private static final PSCAuthenticator pscAuthenticator = new PSCAuthenticator();
    private static final Object unknownRequestorDiscoverySequencerLock = new Object();

    public static Object getUnknownRequestorDiscoverySequencerLock() {
        return unknownRequestorDiscoverySequencerLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestorInfo getLastUnknownRequestor() {
        Class<PSCAuthenticator> clazz = PSCAuthenticator.class;
        synchronized (PSCAuthenticator.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return lastUnknownRequestor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetLastUnknownRequestor() {
        Class<PSCAuthenticator> clazz = PSCAuthenticator.class;
        synchronized (PSCAuthenticator.class) {
            lastUnknownRequestor = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void memorizePasswordAuthentication(Object provider, RequestorInfo requestorInfo, PasswordAuthentication passwordAuthentication) {
        Class<PSCAuthenticator> clazz = PSCAuthenticator.class;
        synchronized (PSCAuthenticator.class) {
            RequestorAuthenticationData raData = new RequestorAuthenticationData();
            raData.passwordAuthentication = passwordAuthentication;
            raData.requestorInfo = requestorInfo;
            provider2tuple.put(provider, raData);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revokePasswordAuthentication(Object provider) {
        Class<PSCAuthenticator> clazz = PSCAuthenticator.class;
        synchronized (PSCAuthenticator.class) {
            RequestorAuthenticationData requestorAuthT = (RequestorAuthenticationData)provider2tuple.remove(provider);
            if (requestorAuthT != null) {
                char[] passwordChars = requestorAuthT.passwordAuthentication.getPassword();
                int ci = 0;
                while (passwordChars != null && ci < passwordChars.length) {
                    passwordChars[ci] = '\u0000';
                    ++ci;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static PSCAuthenticator getInstance() {
        return pscAuthenticator;
    }

    private PSCAuthenticator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String host = this.getRequestingHost();
        int port = this.getRequestingPort();
        String prompt = this.getRequestingPrompt();
        String protocol = this.getRequestingProtocol();
        String sheme = this.getRequestingScheme();
        InetAddress site = this.getRequestingSite();
        PasswordAuthentication passwordAuthentication = null;
        Class<PSCAuthenticator> clazz = PSCAuthenticator.class;
        // MONITORENTER : de.plans.psc.client.communication.PSCAuthenticator.class
        for (RequestorAuthenticationData t : provider2tuple.values()) {
            if (!t.requestorInfo.matches(host, port, prompt, protocol, sheme, site)) continue;
            passwordAuthentication = t.passwordAuthentication;
            break;
        }
        // MONITOREXIT : clazz
        RequestorInfo previousUnknownRequestor = null;
        if (passwordAuthentication == null) {
            Class<PSCAuthenticator> clazz2 = PSCAuthenticator.class;
            // MONITORENTER : de.plans.psc.client.communication.PSCAuthenticator.class
            previousUnknownRequestor = lastUnknownRequestor;
            lastUnknownRequestor = new RequestorInfo();
            lastUnknownRequestor.host = host;
            lastUnknownRequestor.port = port;
            lastUnknownRequestor.prompt = prompt;
            lastUnknownRequestor.protocol = protocol;
            lastUnknownRequestor.sheme = sheme;
            lastUnknownRequestor.site = site;
            // MONITOREXIT : clazz2
        }
        if (passwordAuthentication != null) return passwordAuthentication;
        if (previousUnknownRequestor != null) return passwordAuthentication;
        return dummyPasswordAuthentication;
    }

    private static class RequestorAuthenticationData {
        private RequestorInfo requestorInfo;
        private PasswordAuthentication passwordAuthentication;

        private RequestorAuthenticationData() {
        }
    }

    public static class RequestorInfo {
        private String host;
        private int port;
        private String prompt;
        private String protocol;
        private String sheme;
        private InetAddress site;

        public boolean matches(String host2, int port2, String prompt2, String protocol2, String sheme2, InetAddress site2) {
            return !(this.host != null && host2 != null && !this.host.equals(host2) || this.port != port2 || this.prompt != null && prompt2 != null && !this.prompt.equals(prompt2) || this.protocol != null && protocol2 != null && !this.protocol.equals(protocol2) || this.sheme != null && sheme2 != null && !this.sheme.equals(sheme2) || this.site != null && site2 != null && !this.site.equals(site2));
        }

        public boolean matches(RequestorInfo r2) {
            return this.matches(r2.host, r2.port, r2.prompt, r2.protocol, r2.sheme, r2.site);
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getSheme() {
            return this.sheme;
        }

        public InetAddress getSite() {
            return this.site;
        }

        public String toString() {
            String NULL = "<null>";
            StringBuilder sb = new StringBuilder();
            sb.append("RequestorInfo ");
            sb.append("- host=");
            sb.append(this.host == null ? "<null>" : this.host);
            sb.append(", port=");
            sb.append(this.port);
            sb.append(", prompt=");
            sb.append(this.prompt == null ? "<null>" : this.prompt);
            sb.append(", protocol=");
            sb.append(this.protocol == null ? "<null>" : this.protocol);
            sb.append(", sheme=");
            sb.append(this.sheme == null ? "<null>" : this.sheme);
            sb.append(", site=");
            sb.append(this.site == null ? "<null>" : this.site.toString());
            return sb.toString();
        }
    }
}

