/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.primitiveTypes;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EODouble
extends EOEncodableObjectWithRole {
    private static final ILogger logger = Logger.getLogger(EODouble.class);
    public static final String XML_NAME = "frame.datatype.double";
    private static final String DEFAULT_ROLE = "value";
    private Double value;

    public EODouble(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EODouble(Double value, String role) {
        super(XML_NAME);
        assert (value != null);
        assert (role != null);
        this.value = value;
        this.setRole(role);
    }

    public EODouble(Double value) {
        this(value, DEFAULT_ROLE);
    }

    public Double getValue() {
        return this.value;
    }

    @Override
    protected boolean setContentFromXML(String strValue) {
        if (this.value == null) {
            try {
                this.value = new Double(Double.parseDouble(strValue));
            }
            catch (NumberFormatException e) {
                logger.error("wrong number format", e);
                this.value = new Double(0.0);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void writeContentToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendContentToXML(writeContext, this.value);
    }

    @Override
    protected boolean hasContent() {
        return true;
    }
}

