/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding.sequential.read;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.encoding.sequential.processing.IEOContainerProcessor;
import de.plans.lib.xml.encoding.sequential.read.AbstractEOContainerReader;
import java.io.File;
import java.io.InputStream;

public class EOContainerReader<C extends EncodableObjectBase, E extends EncodableObjectBase>
extends AbstractEOContainerReader<C, E> {
    private final IEncodableObjectFactory eoFactory;

    public static <C extends EncodableObjectBase, E extends EncodableObjectBase> void readContainer(File file, XMLDecoder xmlDecoder, IEncodableObjectFactory eoFactory, IEOContainerProcessor<C, E> containerProcessor) throws EXDecoderException, JvmExternalResourceInteractionException {
        EOContainerReader.readContainer(FileHelper.fileToInputStream(file), xmlDecoder, eoFactory, containerProcessor);
    }

    public static <C extends EncodableObjectBase, E extends EncodableObjectBase> void readContainer(InputStream inputStream, XMLDecoder xmlDecoder, IEncodableObjectFactory eoFactory, IEOContainerProcessor<C, E> containerProcessor) throws EXDecoderException {
        EOContainerReader<C, E> containerReader = new EOContainerReader<C, E>(eoFactory, containerProcessor);
        xmlDecoder.decodeXML(inputStream, containerReader, true);
    }

    public EOContainerReader(IEncodableObjectFactory eoFactory, IEOContainerProcessor<C, E> containerProcessor) {
        super(containerProcessor);
        this.eoFactory = eoFactory;
    }

    @Override
    protected IEncodableObjectFactory getEOFactoryForDecoder() {
        return this.eoFactory;
    }

    @Override
    protected IEncodableObjectFactory getEOFactoryForEmptyContainer() {
        IEncodableObjectFactory eoFactoryForEmptyContainer = this.eoFactory instanceof EOContainerReader ? ((EOContainerReader)this.eoFactory).getEOFactoryForEmptyContainer() : this.eoFactory;
        return eoFactoryForEmptyContainer;
    }
}

