/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class XMLEncoder {
    public static final Set<Character> INVALID_XML_CHARACTERS = new HashSet<Character>();
    public static final String INVALID_XML_CHARACTER_REPLACEMENT_STRING = " ";
    static final String[] EscapeSequencesUpTo31;

    static {
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0000'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0001'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0002'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0003'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0004'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0005'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0006'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0007'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\b'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u000b'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\f'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u000e'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u000f'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0010'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0011'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0012'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0013'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0014'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0015'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0016'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0017'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0018'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u0019'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u001a'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u001b'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u001c'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u001d'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u001e'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u001f'));
        INVALID_XML_CHARACTERS.add(Character.valueOf('\u007f'));
        EscapeSequencesUpTo31 = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
        for (Character invalidCharacter : INVALID_XML_CHARACTERS) {
            char c = invalidCharacter.charValue();
            if (c < '\u0000' || c >= EscapeSequencesUpTo31.length) continue;
            XMLEncoder.EscapeSequencesUpTo31[c] = INVALID_XML_CHARACTER_REPLACEMENT_STRING;
        }
    }

    public static String xmlEscapeCharacters(String s, boolean asASCII) {
        if (asASCII) {
            return XMLEncoder.xmlEscapeCharactersAsASCII(s);
        }
        return XMLEncoder.xmlEscapeCharactersXMLAndASCIIControls(s);
    }

    public static String xmlEscapeCharactersAsASCII(String s) {
        StringBuffer result = null;
        int i = 0;
        int max = s.length();
        int delta = 0;
        while (i < max) {
            char c = s.charAt(i);
            String replacement = null;
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\'') {
                replacement = "&apos;";
            } else if (c < ' ') {
                replacement = EscapeSequencesUpTo31[c];
            } else if (c == '\u007f' && INVALID_XML_CHARACTERS.contains(Character.valueOf(c))) {
                replacement = INVALID_XML_CHARACTER_REPLACEMENT_STRING;
            } else if (c >= '\u0080') {
                char cAsInt = c;
                replacement = "&#" + Integer.toString(cAsInt) + ";";
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public static String xmlDeescapeCharactersFromASCII(String s) {
        StringBuffer result = null;
        int i = 0;
        int max = s.length();
        int delta = 0;
        while (i < max) {
            char c = s.charAt(i);
            String replacement = null;
            int replacedSequenceLength = 0;
            if (c == '&') {
                int semicolonIndex;
                String remainder = s.substring(i);
                if (remainder.startsWith("&amp;")) {
                    replacement = "&";
                    replacedSequenceLength = 5;
                } else if (remainder.startsWith("&lt;")) {
                    replacement = "<";
                    replacedSequenceLength = 4;
                } else if (remainder.startsWith("&gt;")) {
                    replacement = ">";
                    replacedSequenceLength = 4;
                } else if (remainder.startsWith("&quot;")) {
                    replacement = "\"";
                    replacedSequenceLength = 6;
                } else if (remainder.startsWith("&apos;")) {
                    replacement = "'";
                    replacedSequenceLength = 6;
                } else if (remainder.startsWith("&#") && (semicolonIndex = remainder.indexOf(59)) >= 0) {
                    try {
                        int number = Integer.parseInt(remainder.substring(2, semicolonIndex));
                        replacement = String.valueOf((char)number);
                        replacedSequenceLength = semicolonIndex + 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (replacement != null) {
                    if (result == null) {
                        result = new StringBuffer(s);
                    }
                    result.replace(i + delta, i + delta + replacedSequenceLength, replacement);
                    delta += replacement.length() - replacedSequenceLength;
                }
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public static String xmlEscapeCharactersXMLAndASCIIControls(String s) {
        StringBuffer result = null;
        int i = 0;
        int max = s.length();
        int delta = 0;
        while (i < max) {
            char c = s.charAt(i);
            String replacement = null;
            switch (c) {
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '\"': {
                    replacement = "&quot;";
                    break;
                }
                case '\'': {
                    replacement = "&apos;";
                    break;
                }
                default: {
                    if (c < ' ') {
                        replacement = EscapeSequencesUpTo31[c];
                        break;
                    }
                    if (c != '\u007f' || !INVALID_XML_CHARACTERS.contains(Character.valueOf(c))) break;
                    replacement = INVALID_XML_CHARACTER_REPLACEMENT_STRING;
                }
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    static void appendStringEscapedToXML(EncodableObjectBase.WriteContext outp, String unescapedtext) throws IOException {
        int unescapedlength = unescapedtext.length();
        int lastreplacementPos = -1;
        int i = 0;
        while (i < unescapedlength) {
            char c = unescapedtext.charAt(i);
            String replacement = null;
            switch (c) {
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '\"': {
                    replacement = "&quot;";
                    break;
                }
                case '\'': {
                    replacement = "&apos;";
                    break;
                }
                default: {
                    if (c < ' ') {
                        replacement = EscapeSequencesUpTo31[c];
                        break;
                    }
                    if (c != '\u007f' || !INVALID_XML_CHARACTERS.contains(Character.valueOf(c))) break;
                    replacement = INVALID_XML_CHARACTER_REPLACEMENT_STRING;
                }
            }
            if (replacement != null) {
                if (lastreplacementPos < i - 1) {
                    outp.write(unescapedtext.substring(lastreplacementPos + 1, i));
                }
                outp.write(replacement);
                lastreplacementPos = i;
            }
            ++i;
        }
        if (lastreplacementPos < 0) {
            outp.write(unescapedtext);
        } else if (lastreplacementPos < unescapedlength - 1) {
            outp.write(unescapedtext.substring(lastreplacementPos + 1, unescapedlength));
        }
    }
}

