/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.codec.Base64;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject_Interlacing;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class EOEncodableObject
extends EOEncodableObject_Interlacing {
    private static final ILogger LOGGER = Logger.getLogger(EOEncodableObject.class);
    private static final String STRINGSTREAMING_CHARSET = "ASCII";
    private Base64.Decoder decoder = null;
    private StringBuilder content = null;

    public EOEncodableObject(String xmlName) {
        super(xmlName);
    }

    public EOEncodableObject(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    @Override
    protected boolean hasContent() {
        return this.hasBinaryContent();
    }

    @Override
    boolean canHaveBinaryContentFromBase() {
        return this.canHaveBinaryContent();
    }

    @Override
    protected void writeContentAndChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.writeContentToXML(writeContext);
        this.writeChildrenToXML(writeContext, depth);
    }

    protected abstract void writeChildrenToXML(EncodableObjectBase.WriteContext var1, int var2) throws EXEncoderException;

    protected void writeContentToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (this.hasBinaryContent()) {
            try {
                InputStream byteArrayInputStream = this.writeBinaryContentToXML();
                if (byteArrayInputStream != null) {
                    Base64.InputStream base64EncodedInputStream = new Base64.InputStream(byteArrayInputStream, true, false);
                    InputStreamReader base64EncodedPNGReader = new InputStreamReader((InputStream)base64EncodedInputStream, STRINGSTREAMING_CHARSET);
                    writeContext.writeRawData(base64EncodedPNGReader);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while encoding binary content", e);
            }
        }
    }

    @Override
    protected void beginReadingBinaryContentFromBase() throws EXDecoderException {
        this.decoder = new Base64.Decoder();
        this.beginReadingBinaryContent();
    }

    @Override
    final void readPartOfBinaryContentFromBase(char[] ch, int start, int length) throws EXDecoderException {
        this.decoder.decode(ch, start, length);
        this.processDecodedBinaryContent();
    }

    private void processDecodedBinaryContent() throws EXDecoderException {
        while (this.decoder.hasNext()) {
            this.readPartOfBinaryContent(this.decoder.next());
        }
    }

    @Override
    void endReadingBinaryContentFromBase() throws EXDecoderException {
        this.decoder.end();
        this.processDecodedBinaryContent();
        this.decoder = null;
        this.endReadingBinaryContent();
    }

    protected boolean canHaveBinaryContent() {
        return false;
    }

    protected void beginReadingBinaryContent() throws EXDecoderException {
    }

    protected void readPartOfBinaryContent(byte[] bytes) throws EXDecoderException {
    }

    protected void endReadingBinaryContent() throws EXDecoderException {
    }

    protected boolean hasBinaryContent() {
        return false;
    }

    protected InputStream writeBinaryContentToXML() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean addContentFromXML(String value) {
        boolean knownContent;
        if (value.length() > 0) {
            if (this.content == null) {
                this.content = new StringBuilder();
            }
            this.content.append(value);
            knownContent = this.setContentFromXML(this.content.toString());
        } else {
            knownContent = this.setContentFromXML(value);
        }
        return knownContent;
    }

    @Override
    public void endElement() throws EXDecoderException {
        super.endElement();
        this.content = null;
    }

    @Override
    protected void addUnknownContentFromXML(String value) {
    }

    protected boolean setContentFromXML(String value) {
        return false;
    }

    @Override
    protected void setUnknownAttribute(String name, String value) {
    }

    @Override
    protected void addUnknownChild(EncodableObjectBase newChild) {
    }

    protected void setUnknownContentFromXML(String value) {
    }
}

