/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.html;

import de.plans.lib.util.html.HTMLText;
import de.plans.lib.util.html.IF_HTMLText;
import java.util.ArrayList;
import java.util.List;

public class HTMLPage
implements IF_HTMLText {
    private final List content = new ArrayList();
    private String title = null;
    private boolean usePLANSStyle = true;

    public HTMLPage setTitle(String value) {
        this.title = value;
        return this;
    }

    public HTMLPage addContent(IF_HTMLText value) {
        this.content.add(value);
        return this;
    }

    public HTMLPage addContent(String value) {
        return this.addContent(new HTMLText(value));
    }

    @Override
    public String getHTMLText() {
        String text = this.getHeaderString();
        text = String.valueOf(text) + "<body>";
        int i = 0;
        while (i < this.content.size()) {
            text = String.valueOf(text) + ((IF_HTMLText)this.content.get(i)).getHTMLText();
            ++i;
        }
        text = String.valueOf(text) + "</body></html>";
        return text;
    }

    public String getHeaderString() {
        String text = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Strict//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
        text = String.valueOf(text) + "<html><head>";
        if (this.title != null) {
            text = String.valueOf(text) + "<title>" + this.title + "</title>";
        }
        if (this.usePLANSStyle) {
            text = String.valueOf(text) + "<style type=\"text/css\"><!--p,h1,h2,h3,h4,h5,ul,ol,li,div,td,th,body { font-family:Arial,Helvetica,sans-serif}td,th { font-size:10}--></style>";
        }
        text = String.valueOf(text) + "</head>";
        return text;
    }

    public HTMLPage usePLANSStyle(boolean value) {
        this.usePLANSStyle = value;
        return this;
    }

    public String toString() {
        return this.getHTMLText();
    }
}

