/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.gui.elements;

import de.plans.lib.util.gui.elements.IUIElement;
import de.plans.lib.util.valueranges.IValueRangeHelperList;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class UIETextDropDown
implements IUIElement {
    private Combo combo = null;
    private String description = null;
    private final IValueRangeHelperList valueRangeHelper;

    public UIETextDropDown(String description, IValueRangeHelperList valueRangeHelper) {
        this.description = description;
        this.valueRangeHelper = valueRangeHelper;
    }

    @Override
    public Control getControl(Composite parent) {
        if (this.combo == null || this.combo.isDisposed()) {
            boolean readOnly = !this.valueRangeHelper.acceptsNewValues();
            int readOnlyMask = readOnly ? 8 : 0;
            this.combo = new Combo(parent, 0x804 | readOnlyMask);
        }
        return this.combo;
    }

    @Override
    public void getValue() {
        this.valueRangeHelper.setPersistentValue(this.combo.getText().trim());
    }

    @Override
    public void setValue() {
        String[] values;
        String[] stringArray = values = this.valueRangeHelper.getPossibleValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String valueName = stringArray[n2];
            this.combo.add(valueName.trim());
            ++n2;
        }
        String valueString = this.valueRangeHelper.getDisplayFormat();
        this.combo.setText(valueString);
    }

    @Override
    public String checkCurrentValue() {
        if (this.valueRangeHelper.check(this.combo.getText().trim())) {
            return null;
        }
        return this.valueRangeHelper.getErrorMessage(this.description);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        this.combo.addModifyListener(listener);
    }

    @Override
    public void removeModifyListener(ModifyListener listener) {
        this.combo.removeModifyListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    public String getCurrentValue() {
        return this.combo.getText();
    }

    public int getCurrentIndex() {
        return this.combo.getSelectionIndex();
    }

    public void forceValue(String value) {
        String[] values;
        String[] stringArray = values = this.valueRangeHelper.getPossibleValues();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String valueName = stringArray[n2];
            this.combo.add(valueName.trim());
            ++n2;
        }
        this.combo.setText(value);
    }

    protected Combo getCombo() {
        return this.combo;
    }
}

