/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.io.RelativeFilePath;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.FileHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static final ILogger logger = Logger.getLogger(Zip.class);

    public static void createZipFile(File sourceDirectory, File destinationFile) throws IOException {
        ZipOutputStream zos = Zip.createZipOutputStream(destinationFile);
        try {
            Zip.createZipEntries(sourceDirectory, sourceDirectory, zos);
            zos.flush();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                logger.warn("Zip Output stream could not be closed successfully. ZipFile: " + destinationFile.getPath(), e);
            }
        }
    }

    public static void createZipFile(ArrayList<File> zipIngredients, File destinationFile) throws IOException {
        ZipOutputStream zos = Zip.createZipOutputStream(destinationFile);
        try {
            for (File ingredient : zipIngredients) {
                if (!ingredient.exists()) {
                    throw new IOException("Error while opening zip file: cannot find file " + ingredient.getAbsolutePath());
                }
                if (ingredient.isDirectory()) {
                    File[] content;
                    File[] fileArray = content = ingredient.listFiles();
                    int n = content.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File element = fileArray[n2];
                        Zip.createZipEntries(element, ingredient.getParentFile(), zos);
                        ++n2;
                    }
                    continue;
                }
                Zip.createZipEntry(ingredient, ingredient.getParentFile(), zos);
            }
            zos.flush();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                logger.warn("Zip Output stream could not be closed successfully. ZipFile: " + destinationFile.getPath(), e);
            }
        }
    }

    public static ZipOutputStream createZipFileDontCloseStream(File sourceDirectory, File destinationFile) throws IOException {
        ZipOutputStream zos = Zip.createZipOutputStream(destinationFile);
        Zip.createZipEntries(sourceDirectory, sourceDirectory, zos);
        zos.flush();
        return zos;
    }

    private static ZipOutputStream createZipOutputStream(File destination) throws IOException {
        if (destination.exists()) {
            throw new IOException("Destination File already exists.");
        }
        if (destination.getParentFile() == null || !destination.getParentFile().exists()) {
            throw new FileNotFoundException("Cannot find the path specified.");
        }
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        return zos;
    }

    public static void unzipFile(String sourceFile, String destinationDirectory) throws IOException {
        Zip.unzipFile(new File(sourceFile), new File(destinationDirectory));
    }

    public static void unzipFile(File sourceFile, File destinationDirectory) throws IOException {
        Zip.unzipMatchingEntriesFromFile(sourceFile, destinationDirectory, null);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipMatchingEntriesFromFile(File sourceFile, File destinationDirectory, IZipEntryFilter zipEntryFilter) throws IOException {
        if (!destinationDirectory.exists()) {
            throw new FileNotFoundException("Can't find destination directory " + destinationDirectory.getPath());
        }
        if (!destinationDirectory.isDirectory()) {
            throw new IOException("Destination " + destinationDirectory.getPath() + "is not a directory");
        }
        ZipFile zipFile = new ZipFile(sourceFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            block18: {
                block17: {
                    if (!true) break block17;
                    if (!entries.hasMoreElements()) return;
                    if (zipEntryFilter != null && !zipEntryFilter.proceed()) break block18;
                }
                do {
                    boolean entryPathAccepted;
                    ZipEntry e = entries.nextElement();
                    File out = new File(destinationDirectory, Zip.decodeZipEntryName(e.getName()));
                    RelativeFilePath entryPath = null;
                    if (zipEntryFilter == null) {
                        entryPathAccepted = true;
                    } else {
                        ArrayList<String> relPathElementNames = new ArrayList<String>();
                        File c = out;
                        while (!destinationDirectory.equals(c)) {
                            assert (c != null);
                            if (destinationDirectory.getCanonicalPath().length() >= c.getCanonicalPath().length()) {
                                if ($assertionsDisabled) throw new IOException("Invalid Zip Archive - ..");
                                throw new AssertionError();
                            }
                            relPathElementNames.add(0, c.getName());
                            c = c.getParentFile();
                        }
                        entryPath = new RelativeFilePath(relPathElementNames);
                        entryPathAccepted = zipEntryFilter.accept(entryPath);
                    }
                    if (entryPathAccepted) {
                        if (e.isDirectory()) {
                            out.mkdirs();
                        } else {
                            File parent = out.getParentFile();
                            if (!parent.exists()) {
                                parent.mkdirs();
                            }
                            InputStream in = zipFile.getInputStream(e);
                            FileHelper.copyFile(in, out);
                        }
                        if (zipEntryFilter != null) {
                            zipEntryFilter.provisionedAcceptedFile(entryPath);
                        }
                    }
                    if (!entries.hasMoreElements()) return;
                } while (zipEntryFilter == null || zipEntryFilter.proceed());
            }
            return;
        }
        finally {
            zipFile.close();
        }
    }

    private static void createZipEntries(File file, File root, ZipOutputStream zos) throws IOException {
        if (!file.exists()) {
            throw new IOException("Error while opening zip file: cannot find file " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            File[] content;
            File[] fileArray = content = file.listFiles();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                Zip.createZipEntries(element, root, zos);
                ++n2;
            }
        } else {
            Zip.createZipEntry(file, root, zos);
        }
    }

    private static void createZipEntry(File source, File root, ZipOutputStream zos) throws IOException {
        if (!source.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IOException("File to compress is not in directory to compress.");
        }
        Zip.writeZipEntry(source, source.getAbsolutePath().substring(root.getAbsolutePath().length() + 1), zos);
    }

    public static void writeZipEntry(File source, String name, ZipOutputStream zos) throws IOException {
        ZipEntry e = new ZipEntry(Zip.encodeZipEntryName(name));
        zos.putNextEntry(e);
        FileHelper.copyFile(source, zos, false);
    }

    public static void uncompressZipEntry(File source, String entryName, File destination) throws IOException {
        ZipFile file = new ZipFile(source);
        try {
            ZipEntry e = file.getEntry(Zip.encodeZipEntryName(entryName));
            if (e == null) {
                throw new ZipException("Unable to find zip entry " + entryName);
            }
            FileHelper.copyFile(file.getInputStream(e), destination);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                logger.warn("Zip File could not be closed successfully. ZipFile: " + source, e);
            }
        }
    }

    private static String encodeZipEntryName(String name) {
        char[] input = name.toCharArray();
        StringBuffer result = new StringBuffer();
        String encoding = "UTF-8";
        char[] cArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            switch (element) {
                case '/': {
                    result.append('/');
                    break;
                }
                case '\\': {
                    result.append('/');
                    break;
                }
                default: {
                    try {
                        result.append(URLEncoder.encode("" + element, encoding));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++n2;
        }
        return result.toString();
    }

    private static String decodeZipEntryName(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface IZipEntryFilter {
        public boolean accept(RelativeFilePath var1);

        public boolean proceed();

        public void provisionedAcceptedFile(RelativeFilePath var1);
    }
}

