/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Lock {
    private static final ILogger logger = Logger.getLogger(Lock.class);
    private boolean lockAvailable = true;

    public synchronized void acquire() {
        while (true) {
            if (this.lockAvailable) {
                this.lockAvailable = false;
                return;
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                logger.error("InterruptedException while waiting for lock.", e);
                continue;
            }
            break;
        }
    }

    public synchronized void release() {
        assert (!this.lockAvailable);
        if (this.lockAvailable) {
            logger.error("Could not release lock because it has already been released before.");
        }
        this.lockAvailable = true;
        this.notifyAll();
    }
}

