/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.svg.DeviceDriverSVG11;
import de.plans.lib.svg.ILink;
import de.plans.lib.xml.encoding.EXEncoderException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class SVGPrinter
implements IPrinter {
    private static final ILogger logger = Logger.getLogger(SVGPrinter.class);
    private ByteArrayOutputStream svg;
    private final Collection<ByteArrayOutputStream> svgs = new ArrayList<ByteArrayOutputStream>();
    protected IPageDescription info;
    private final TransformationAffiliate mmToSVG;
    private boolean isInPixel = false;
    private Map<String, String> classIDMap;
    private String cssStyleSheetFileName;
    private Map<String, ILink> linkMap;

    private SVGPrinter(IPageDescription info) {
        assert (info != null) : "info is null";
        this.info = info;
        double FX = 1.0;
        double FY = 1.0;
        this.mmToSVG = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(FX, FY));
    }

    public SVGPrinter(IPageDescription info, boolean isInPixel, Map<String, String> classIDMap, String cssStyleSheetFileName, Map<String, ILink> linkMap) {
        this(info);
        this.isInPixel = isInPixel;
        this.classIDMap = classIDMap;
        this.cssStyleSheetFileName = cssStyleSheetFileName;
        this.linkMap = linkMap;
    }

    private static ByteArrayOutputStream createNewSVG() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        return outputStream;
    }

    public Rectangle getPageSize() {
        return new Rectangle(0.0, 0.0, this.info.getPageDimension().width, this.info.getPageDimension().height);
    }

    public Rectangle getDrawingArea() {
        Rectangle pageSize = this.getPageSize();
        Rectangle area = new Rectangle(pageSize.upperLeft.x + this.info.getPrintAreaInsets().leftInset, pageSize.upperLeft.y + this.info.getPrintAreaInsets().upperInset, pageSize.lowerRight.x - this.info.getPrintAreaInsets().rightInset, pageSize.lowerRight.y - this.info.getPrintAreaInsets().lowerInset);
        return area;
    }

    public void performJob(String jobName, IPrinter.IPrintingJobProcessor jobProcessor) throws PrintingFailure {
        jobProcessor.processPrintingJob(new IPrinter.IPrintingJob(){

            public void drawPage(Rectangle totalDrawingHint, IPrinter.IPagePrinter pagePrinter) throws PrintingFailure {
                DeviceDriverSVG11 driver;
                SVGPrinter.this.svg = SVGPrinter.createNewSVG();
                try {
                    driver = new DeviceDriverSVG11(SVGPrinter.this.svg, SVGPrinter.this.info.getPageDimension().width, SVGPrinter.this.info.getPageDimension().height, SVGPrinter.this.getPageSize(), SVGPrinter.this.isInPixel, SVGPrinter.this.classIDMap, SVGPrinter.this.cssStyleSheetFileName, SVGPrinter.this.linkMap);
                }
                catch (EXEncoderException e) {
                    throw new PrintingFailure((Throwable)e);
                }
                Device device = new Device((IDeviceDriver)driver, (Transformation)SVGPrinter.this.mmToSVG);
                pagePrinter.printPage(device);
                try {
                    driver.closeSVGStream();
                }
                finally {
                    driver.dispose();
                }
                SVGPrinter.this.svgs.add(SVGPrinter.this.svg);
            }
        });
    }

    public Collection<ByteArrayOutputStream> getCreatedImages() {
        return this.svgs;
    }

    public void saveCreatedSVGs(File directory, String prefix, int offset) {
        Iterator<ByteArrayOutputStream> svgIterator = this.svgs.iterator();
        int count = offset;
        while (svgIterator.hasNext()) {
            ByteArrayOutputStream iAF;
            ByteArrayOutputStream svgLocal = iAF = svgIterator.next();
            String fileName = String.valueOf(directory.getAbsolutePath()) + prefix + count + ".svg";
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(fileName);
                fileOutputStream.write(svgLocal.toByteArray());
                fileOutputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++count;
        }
    }

    public void saveSVGDirectly(File absoluteSVGPath, String svgFileName) throws EXEmptyResult {
        Iterator<ByteArrayOutputStream> svgIterator = this.svgs.iterator();
        assert (this.svgs.size() <= 1) : "if saveImageDirectly, only one image will be saved because onlyone filename is provided";
        if (svgIterator.hasNext()) {
            ByteArrayOutputStream iAF;
            ByteArrayOutputStream svgLocal = iAF = svgIterator.next();
            File file = new File(absoluteSVGPath, svgFileName);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                boolean noWriteErrorOccured = false;
                try {
                    fileOutputStream.write(svgLocal.toByteArray());
                    noWriteErrorOccured = true;
                }
                finally {
                    if (noWriteErrorOccured) {
                        fileOutputStream.close();
                    } else {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception e) {
                            logger.debug("Problem wile closing WMF Image File stream (probably caused by a previous error)", e);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new EXEmptyResult();
        }
    }

    public void disposeImages() {
        Iterator<ByteArrayOutputStream> iterator = this.svgs.iterator();
        while (iterator.hasNext()) {
            ByteArrayOutputStream svgAndImage;
            ByteArrayOutputStream svgLocal = svgAndImage = iterator.next();
            try {
                ((OutputStream)svgLocal).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

