/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.svg;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverLineDrawing;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.svg.ILink;
import de.plans.lib.svg.SVGAbstractConverter;
import de.plans.lib.svg.SVGArc;
import de.plans.lib.svg.SVGGroup;
import de.plans.lib.svg.SVGImage;
import de.plans.lib.svg.SVGLine;
import de.plans.lib.svg.SVGLink;
import de.plans.lib.svg.SVGPoint;
import de.plans.lib.svg.SVGPolygon;
import de.plans.lib.svg.SVGRoot;
import de.plans.lib.svg.SVGText;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class DeviceDriverSVG11
extends DeviceDriverLineDrawing {
    private static final ILogger logger = Logger.getLogger(DeviceDriverSVG11.class);
    private int indention = 0;
    private final EncodableObjectBase.WriteContext writeContext;
    private final SVGRoot svgRoot;
    private Map<String, String> classIDMap;
    private Map<String, ILink> linkMap;
    private boolean hasLinks = false;
    private EXEncoderException svgXMLOutputFailure = null;

    public DeviceDriverSVG11(OutputStream outputStream, double width, double height, Rectangle viewBox, boolean isInPixel, Map<String, String> classIDMap, String cssFileName, Map<String, ILink> linkMap) throws EXEncoderException {
        assert (outputStream != null);
        assert (viewBox != null);
        boolean formatOutput = true;
        this.writeContext = EncodableObjectBase.openXMLStreamInNonARCWAYFormat(outputStream, formatOutput);
        if (cssFileName != null && cssFileName.length() > 0) {
            EncodableObjectBase.writeProcessingInstruction(this.writeContext, "xml-stylesheet", "type=\"text/css\" href=\"" + cssFileName + "\"", formatOutput);
        }
        this.classIDMap = classIDMap != null ? classIDMap : Collections.emptyMap();
        if (linkMap != null) {
            this.hasLinks = true;
            this.linkMap = linkMap;
        }
        this.svgRoot = new SVGRoot(width, height, viewBox, isInPixel);
        this.svgRoot.writeToXMLStartTag(this.writeContext, this.indention);
        ++this.indention;
    }

    public void dispose() {
    }

    public void fill(Polygon polygon) {
        SVGPolygon svgPolygon = new SVGPolygon(polygon, this.getFillColor(), this.getFillAlpha());
        this.writeToXml(svgPolygon);
    }

    public void plot(Point point) {
        SVGPoint svgPoint = new SVGPoint(point, this.getLineColor(), this.getLineWidth());
        this.writeToXml(svgPoint);
    }

    public void line(Line line) {
        SVGLine svgLine = new SVGLine(line, this.getLineColor(), this.getLineWidth());
        this.writeToXml(svgLine);
    }

    public void arc(Arc arc) {
        SVGArc svgArc = new SVGArc(arc, this.getLineColor(), this.getLineWidth());
        this.writeToXml(svgArc);
    }

    public void skipPlot(Point point) {
    }

    public void skipLine(Line line) {
    }

    public void skipArc(Arc arc) {
    }

    public boolean isNotInterestedInRealTextDrawing() {
        return false;
    }

    public void text(Point p, double textLenght, String text, TurnedRectangle clippingHint) {
        double textHgHeigt = this.getTextAscent() - this.getTextDescent();
        SVGText svgText = new SVGText(text, p, this.getTextDirection(), this.getTextAlignment(), textLenght, this.getTextColor(), this.getTextFontName(), textHgHeigt, this.isTextBold(), this.isTextItalic());
        this.writeToXml(svgText);
    }

    public void drawImage(IOffscreenBitmap image, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle scaleToRectangle, int alpha) {
        assert (image != null);
        assert (sourceX >= 0);
        assert (sourceY >= 0);
        assert (sourceX < image.getWidthInPixels());
        assert (sourceY < image.getHeightInPixels());
        assert (sourceW > 0);
        assert (sourceH > 0);
        assert (sourceW <= image.getWidthInPixels() - sourceX);
        assert (sourceH <= image.getHeightInPixels() - sourceY);
        assert (scaleToRectangle != null);
        if (scaleToRectangle.getW().abs() > 1.0E-10 && scaleToRectangle.getH().abs() > 1.0E-10) {
            SVGImage svgImage = new SVGImage(image, scaleToRectangle);
            this.writeToXml(svgImage);
        }
    }

    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        this.startElement(elementName, elementTypeID, elementID, optionalTransformation);
        runnable.run();
        this.endElement(elementName, elementTypeID, elementID, optionalTransformation);
    }

    private void startElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation) {
        String classID = this.classIDMap.get(elementID);
        SVGGroup svgGroup = new SVGGroup(elementName, elementTypeID, elementID, classID, optionalTransformation);
        if (this.svgXMLOutputFailure == null) {
            try {
                svgGroup.writeToXMLStartTag(this.writeContext, this.indention);
            }
            catch (EXEncoderException e) {
                this.svgXMLOutputFailure = e;
            }
        }
        if (this.hasLinks && this.linkMap.containsKey(elementID)) {
            ++this.indention;
            ILink svgLE = this.linkMap.get(elementID);
            SVGLink svgLink = new SVGLink(svgLE.getHRef(), svgLE.getTitle(), svgLE.getShow(), svgLE.getTarget());
            if (this.svgXMLOutputFailure == null) {
                try {
                    svgLink.writeToXMLStartTag(this.writeContext, this.indention);
                }
                catch (EXEncoderException e) {
                    this.svgXMLOutputFailure = e;
                }
            }
        }
        ++this.indention;
    }

    private void endElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation) {
        if (this.hasLinks && this.linkMap.containsKey(elementID)) {
            --this.indention;
            ILink svgLE = this.linkMap.get(elementID);
            SVGLink svgLink = new SVGLink(svgLE.getHRef(), svgLE.getTitle(), svgLE.getShow(), svgLE.getTarget());
            if (this.svgXMLOutputFailure == null) {
                try {
                    svgLink.writeToXMLEndTag(this.writeContext, this.indention);
                }
                catch (EXEncoderException e) {
                    this.svgXMLOutputFailure = e;
                }
            }
        }
        --this.indention;
        String classID = this.classIDMap.get(elementID);
        SVGGroup svgGroup = new SVGGroup(elementName, elementTypeID, elementID, classID, optionalTransformation);
        if (this.svgXMLOutputFailure == null) {
            try {
                svgGroup.writeToXMLEndTag(this.writeContext, this.indention);
            }
            catch (EXEncoderException e) {
                this.svgXMLOutputFailure = e;
            }
        }
    }

    public void closeSVGStream() throws PrintingFailure {
        if (this.svgXMLOutputFailure == null) {
            try {
                --this.indention;
                this.svgRoot.writeToXMLEndTag(this.writeContext, this.indention);
            }
            catch (EXEncoderException e) {
                this.svgXMLOutputFailure = e;
            }
        }
        try {
            EncodableObjectBase.closeXMLStream(this.writeContext);
        }
        catch (EXEncoderException e) {
            if (this.svgXMLOutputFailure == null) {
                this.svgXMLOutputFailure = e;
            }
            logger.debug(e.getLocalizedMessage(), e);
        }
        if (this.svgXMLOutputFailure != null) {
            throw new PrintingFailure((Throwable)this.svgXMLOutputFailure);
        }
    }

    private void writeToXml(SVGAbstractConverter converter) {
        if (this.svgXMLOutputFailure == null) {
            try {
                converter.writeToXML(this.writeContext, this.indention);
            }
            catch (EXEncoderException e) {
                this.svgXMLOutputFailure = e;
            }
        }
    }

    public boolean supportsNullImage() {
        return false;
    }

    public boolean driverSupportsTransformationForSubElements() {
        return true;
    }
}

