/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.resource;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.Assert;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.InputStream;
import java.net.URL;

public class URLResource
implements IStreamResource {
    private final URL url;

    public URLResource(URL url) {
        Assert.checkArgumentBeeingNotNull(url);
        this.url = url;
    }

    @Override
    public String getName() {
        String path = this.url.getPath();
        int pos = path.lastIndexOf(47);
        String name = pos >= 0 ? path.substring(pos + 1) : path;
        return name;
    }

    @Override
    public InputStream toInputStream() throws JvmExternalResourceInteractionException {
        return FileHelper.urlToInputStream(this.url);
    }
}

