/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.logging;

import com.arcway.lib.logging.ILogger;
import java.util.Collection;
import java.util.Iterator;

public class LoggerBroadcaster
implements ILogger {
    private final Collection<ILogger> loggers;

    public LoggerBroadcaster(Collection<ILogger> loggers) {
        if (loggers == null) {
            throw new IllegalArgumentException();
        }
        this.loggers = loggers;
    }

    @Override
    public void trace(String message) {
        for (ILogger logger : this.loggers) {
            logger.trace(message);
        }
    }

    @Override
    public void debug(int debugCategory, String message) {
        for (ILogger logger : this.loggers) {
            logger.debug(debugCategory, message);
        }
    }

    @Override
    public void debug(int debugCategory, String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.debug(debugCategory, message, t);
        }
    }

    @Override
    public void debug(String message) {
        for (ILogger logger : this.loggers) {
            logger.debug(message);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.debug(message, t);
        }
    }

    @Override
    public void error(String message) {
        this.error(message, new Exception("This exception was generated automatically to get a stack trace."));
    }

    @Override
    public void error(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.error(message, t);
        }
    }

    @Override
    public void error(Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.error(t);
        }
    }

    @Override
    public void fatal(String message) {
        this.fatal(message, new Exception("This exception was generated automatically to get a stack trace."));
    }

    @Override
    public void fatal(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.fatal(message, t);
        }
    }

    @Override
    public void fatal(Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.fatal(t);
        }
    }

    @Override
    public void info(String message) {
        for (ILogger logger : this.loggers) {
            logger.info(message);
        }
    }

    @Override
    public void info(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.info(message, t);
        }
    }

    @Override
    public void warn(String message) {
        for (ILogger logger : this.loggers) {
            logger.warn(message);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.warn(message, t);
        }
    }

    @Override
    public void warn(Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.warn(t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isInfoEnabled();
        }
        return enabled;
    }

    @Override
    public boolean isDebugEnabled() {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isDebugEnabled();
        }
        return enabled;
    }

    @Override
    public boolean isDebugEnabled(int debugCategory) {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isDebugEnabled(debugCategory);
        }
        return enabled;
    }

    @Override
    public boolean isTraceEnabled() {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isTraceEnabled();
        }
        return enabled;
    }
}

